/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.api;

import ic2classic.core.block.machine.tileentity.TileEntityCompressor;
import ic2classic.core.block.machine.tileentity.TileEntityExtractor;
import ic2classic.core.block.machine.tileentity.TileEntityMacerator;
import ic2classic.core.block.machine.tileentity.TileEntityMatter;
import ic2classic.core.block.machine.tileentity.TileEntityRecycler;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class Ic2Recipes {
    public static void addCompressorRecipe(Item input, Item output) {
        Ic2Recipes.addCompressorRecipe(new ItemStack(input), new ItemStack(output));
    }

    public static void addCompressorRecipe(Item input, ItemStack output) {
        Ic2Recipes.addCompressorRecipe(new ItemStack(input), output);
    }

    public static void addCompressorRecipe(ItemStack input, ItemStack output) {
        TileEntityCompressor.recipes.add(new AbstractMap.SimpleEntry<ItemStack, ItemStack>(input, output));
    }

    public static ItemStack getCompressorOutputFor(ItemStack input, boolean adjustInput) {
        return Ic2Recipes.getOutputFor(input, adjustInput, TileEntityCompressor.recipes);
    }

    public static void addExtractorRecipe(ItemStack input, ItemStack output) {
        TileEntityExtractor.recipes.add(new AbstractMap.SimpleEntry<ItemStack, ItemStack>(input, output));
    }

    public static ItemStack getExtractorOutputFor(ItemStack input, boolean adjustInput) {
        return Ic2Recipes.getOutputFor(input, adjustInput, TileEntityExtractor.recipes);
    }

    public static void addMaceratorRecipe(ItemStack input, ItemStack output) {
        TileEntityMacerator.recipes.add(new AbstractMap.SimpleEntry<ItemStack, ItemStack>(input, output));
    }

    public static ItemStack getMaceratorOutputFor(ItemStack input, boolean adjustInput) {
        return Ic2Recipes.getOutputFor(input, adjustInput, TileEntityMacerator.recipes);
    }

    private static ItemStack getOutputFor(ItemStack input, boolean adjustInput, List<Map.Entry<ItemStack, ItemStack>> recipeList) {
        assert (input != null);
        for (Map.Entry<ItemStack, ItemStack> entry : recipeList) {
            if (!entry.getKey().func_77969_a(input) || input.field_77994_a < entry.getKey().field_77994_a) continue;
            if (adjustInput) {
                input.field_77994_a -= entry.getKey().field_77994_a;
            }
            return entry.getValue().func_77946_l();
        }
        return null;
    }

    public static void addRecyclerBlacklistItem(ItemStack newBlacklistedItem) {
        if (newBlacklistedItem.func_77973_b() == null) {
            throw new RuntimeException();
        }
        TileEntityRecycler.blacklist.add(newBlacklistedItem);
    }

    public static void addRecyclerBlacklistItem(Item newBlacklistedItem) {
        Ic2Recipes.addRecyclerBlacklistItem(new ItemStack(newBlacklistedItem, 1, -1));
    }

    public static void addRecyclerBlacklistItem(Block newBlacklistedBlock) {
        Ic2Recipes.addRecyclerBlacklistItem(new ItemStack(newBlacklistedBlock, 1, -1));
    }

    public static boolean isRecyclerInputBlacklisted(ItemStack itemStack) {
        for (ItemStack blackItem : TileEntityRecycler.blacklist) {
            if (!itemStack.func_77969_a(blackItem)) continue;
            return true;
        }
        return false;
    }

    public static List<?> getScrapboxDrops() {
        try {
            return (List)Class.forName(String.valueOf(Ic2Recipes.getPackage()) + ".core.item.ItemScrapbox").getMethod("getDropList", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addScrapboxDrop(ItemStack dropItem, float chance) {
        try {
            Class.forName(String.valueOf(Ic2Recipes.getPackage()) + ".core.item.ItemScrapbox").getMethod("addDrop", ItemStack.class, Float.TYPE).invoke(null, dropItem, Float.valueOf(chance));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addScrapboxDrop(Item dropItem, float chance) {
        Ic2Recipes.addScrapboxDrop(new ItemStack(dropItem, 1), chance);
    }

    public static void addScrapboxDrop(Block dropItem, float chance) {
        Ic2Recipes.addScrapboxDrop(new ItemStack(dropItem), chance);
    }

    public static void addMatterAmplifier(ItemStack amplifierItem, int value) {
        TileEntityMatter.amplifiers.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(amplifierItem, value));
    }

    public static void addMatterAmplifier(Item amplifierItem, int value) {
        Ic2Recipes.addMatterAmplifier(new ItemStack(amplifierItem, 1, -1), value);
    }

    public static void addMatterAmplifier(Block amplifierItem, int value) {
        Ic2Recipes.addMatterAmplifier(new ItemStack(amplifierItem, 1, -1), value);
    }

    private static String getPackage() {
        Package pkg = Ic2Recipes.class.getPackage();
        if (pkg != null) {
            return pkg.getName().substring(0, pkg.getName().lastIndexOf(46));
        }
        return "ic2classic";
    }
}

