/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.crop;

import ic2classic.api.CropCard;
import ic2classic.api.TECrop;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Items;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class CropVenomilia
extends CropCard {
    @Override
    public String name() {
        return "Venomilia";
    }

    @Override
    public String discoveredBy() {
        return "raGan";
    }

    @Override
    public int tier() {
        return 3;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 3;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Purple", "Flower", "Tulip", "Poison"};
    }

    @Override
    public int getSpriteIndex(TECrop crop) {
        if (crop.size <= 3) {
            return crop.size + 11;
        }
        if (crop.size == 4) {
            return 23;
        }
        return 25;
    }

    @Override
    public boolean canGrow(TECrop crop) {
        return crop.size <= 4 && crop.getLightLevel() >= 12 || crop.size == 5;
    }

    @Override
    public boolean canBeHarvested(TECrop crop) {
        return crop.size >= 4;
    }

    @Override
    public ItemStack getGain(TECrop crop) {
        if (crop.size == 5) {
            return new ItemStack(Ic2Items.grinPowder, 1);
        }
        if (crop.size >= 4) {
            return new ItemStack(Items.field_151100_aR, 1, 5);
        }
        return null;
    }

    @Override
    public byte getSizeAfterHarvest(TECrop crop) {
        return 3;
    }

    @Override
    public int growthDuration(TECrop crop) {
        if (crop.size >= 3) {
            return 600;
        }
        return 400;
    }

    @Override
    public boolean rightclick(TECrop crop, EntityPlayer player) {
        if (!player.func_70093_af()) {
            this.onEntityCollision(crop, (Entity)player);
        }
        return crop.harvest(true);
    }

    @Override
    public boolean leftclick(TECrop crop, EntityPlayer player) {
        if (!player.func_70093_af()) {
            this.onEntityCollision(crop, (Entity)player);
        }
        return crop.pick(true);
    }

    @Override
    public boolean onEntityCollision(TECrop crop, Entity entity) {
        if (crop.size == 5 && entity instanceof EntityLivingBase) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70093_af() && IC2.random.nextInt(50) != 0) {
                return super.onEntityCollision(crop, entity);
            }
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(19, (IC2.random.nextInt(10) + 5) * 20, 0));
            crop.size = (byte)4;
            crop.updateState();
        }
        return super.onEntityCollision(crop, entity);
    }

    @Override
    public boolean isWeed(TECrop crop) {
        return crop.size == 5 && crop.statGrowth >= 8;
    }
}

