/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.generator.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Icons;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.BlockContainerCommon;
import ic2classic.core.block.generator.tileentity.TileEntityNuclearReactor;
import ic2classic.core.block.generator.tileentity.TileEntityReactorChamber;
import ic2classic.core.block.generator.tileentity.TileEntityReactorChamberElectric;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockReactorChamber
extends BlockContainerCommon {
    public static Class<? extends TileEntityReactorChamber> tileEntityReactorChamberClass = TileEntityReactorChamberElectric.class;

    public BlockReactorChamber() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c("blockReactorChamber");
        this.func_149647_a(IC2.tabIC2);
        GameRegistry.registerBlock((Block)this, (String)"reactorChamber");
        Ic2Items.reactorChamber = new ItemStack((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int par2) {
        if (side == 0) {
            return Ic2Icons.b0_16;
        }
        if (side == 1) {
            return Ic2Icons.b0_17;
        }
        return Ic2Icons.b0_67;
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (!this.func_149742_c(world, i, j, k)) {
            this.func_149642_a(world, i, j, k, new ItemStack(world.func_147439_a(i, j, k), 1, 0));
            world.func_147468_f(i, j, k);
        }
    }

    public boolean func_149742_c(World world, int i, int j, int k) {
        int count = 0;
        if (this.isReactorAt(world, i + 1, j, k)) {
            ++count;
        }
        if (this.isReactorAt(world, i - 1, j, k)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j + 1, k)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j - 1, k)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j, k + 1)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j, k - 1)) {
            ++count;
        }
        return count == 1;
    }

    public void func_149734_b(World world, int i, int j, int k, Random random) {
        TileEntityNuclearReactor reactor = this.getReactorEntity(world, i, j, k);
        if (reactor == null) {
            this.func_149695_a(world, i, j, k, (Block)this);
            return;
        }
        int puffs = reactor.heat / 1000;
        if (puffs <= 0) {
            return;
        }
        puffs = world.field_73012_v.nextInt(puffs);
        int n = 0;
        while (n < puffs) {
            world.func_72869_a("smoke", (double)((float)i + random.nextFloat()), (double)((float)j + 0.95f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
            ++n;
        }
        puffs -= world.field_73012_v.nextInt(4) + 3;
        n = 0;
        while (n < puffs) {
            world.func_72869_a("flame", (double)((float)i + random.nextFloat()), (double)((float)j + 1.0f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
            ++n;
        }
    }

    public boolean isReactorAt(World world, int x, int y, int z) {
        return world.func_147438_o(x, y, z) instanceof TileEntityNuclearReactor && world.func_147439_a(x, y, z) == Block.func_149634_a((Item)Ic2Items.nuclearReactor.func_77973_b()) && world.func_72805_g(x, y, z) == Ic2Items.nuclearReactor.func_77960_j();
    }

    public TileEntityNuclearReactor getReactorEntity(World world, int i, int j, int k) {
        if (this.isReactorAt(world, i + 1, j, k)) {
            return (TileEntityNuclearReactor)world.func_147438_o(i + 1, j, k);
        }
        if (this.isReactorAt(world, i - 1, j, k)) {
            return (TileEntityNuclearReactor)world.func_147438_o(i - 1, j, k);
        }
        if (this.isReactorAt(world, i, j + 1, k)) {
            return (TileEntityNuclearReactor)world.func_147438_o(i, j + 1, k);
        }
        if (this.isReactorAt(world, i, j - 1, k)) {
            return (TileEntityNuclearReactor)world.func_147438_o(i, j - 1, k);
        }
        if (this.isReactorAt(world, i, j, k + 1)) {
            return (TileEntityNuclearReactor)world.func_147438_o(i, j, k + 1);
        }
        if (this.isReactorAt(world, i, j, k - 1)) {
            return (TileEntityNuclearReactor)world.func_147438_o(i, j, k - 1);
        }
        this.func_149695_a(world, i, j, k, world.func_147439_a(i, j, k));
        return null;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        if (entityplayer.func_70093_af()) {
            return false;
        }
        TileEntityNuclearReactor reactor = this.getReactorEntity(world, i, j, k);
        if (reactor == null) {
            this.func_149695_a(world, i, j, k, (Block)this);
            return false;
        }
        if (!IC2.platform.isSimulating()) {
            return true;
        }
        return IC2.platform.launchGui(entityplayer, reactor);
    }

    public TileEntity func_149915_a(World world, int meta) {
        try {
            return tileEntityReactorChamberClass.newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Item func_149650_a(int meta, Random random, int j) {
        return Ic2Items.machine.func_77973_b();
    }

    public int func_149692_a(int meta) {
        return Ic2Items.machine.func_77960_j();
    }

    public String getTextureFile() {
        return "/ic2classic/sprites/block_0.png";
    }
}

