/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.generator.tileentity;

import ic2classic.core.ContainerIC2;
import ic2classic.core.IC2;
import ic2classic.core.block.generator.container.ContainerSolarGenerator;
import ic2classic.core.block.generator.tileentity.TileEntityBaseGenerator;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenDesert;

public class TileEntitySolarGenerator
extends TileEntityBaseGenerator
implements ISidedInventory {
    public static Random randomizer = new Random();
    public int ticker = randomizer.nextInt(this.tickRate());
    public boolean sunIsVisible = false;

    public TileEntitySolarGenerator() {
        super(1, 1, 1);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateSunVisibility();
    }

    @Override
    public int gaugeFuelScaled(int i) {
        return i;
    }

    @Override
    public boolean gainEnergy() {
        if (this.ticker++ % this.tickRate() == 0) {
            this.updateSunVisibility();
        }
        if (this.sunIsVisible) {
            double gen = (double)IC2.energyGeneratorSolar / 100.0;
            if (gen >= 1.0 || this.ticker % (100 - IC2.energyGeneratorSolar) == 0) {
                this.storage = (short)(this.storage + (int)Math.ceil(gen));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean gainFuel() {
        return false;
    }

    public void updateSunVisibility() {
        this.sunIsVisible = TileEntitySolarGenerator.isSunVisible(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    public static boolean isSunVisible(World world, int x, int y, int z) {
        return world.func_72935_r() && !world.field_73011_w.field_76576_e && world.func_72937_j(x, y, z) && (world.func_72959_q().func_76935_a(x, z) instanceof BiomeGenDesert || !world.func_72896_J() && !world.func_72911_I());
    }

    @Override
    public boolean needsFuel() {
        return true;
    }

    @Override
    public String func_145825_b() {
        return "Solar Panel";
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSolarGenerator(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.generator.gui.GuiSolarGenerator";
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public int[] func_94128_d(int var1) {
        return new int[1];
    }
}

