/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.personal;

import ic2classic.api.Direction;
import ic2classic.api.network.INetworkTileEntityEventListener;
import ic2classic.core.ContainerIC2;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.audio.PositionSpec;
import ic2classic.core.block.machine.tileentity.TileEntityMachine;
import ic2classic.core.block.personal.ContainerTradeOMatClosed;
import ic2classic.core.block.personal.ContainerTradeOMatOpen;
import ic2classic.core.block.personal.IPersonalBlock;
import ic2classic.core.block.personal.TileEntityPersonalChest;
import ic2classic.core.util.StackUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;

public class TileEntityTradeOMat
extends TileEntityMachine
implements IPersonalBlock,
IHasGui,
ISidedInventory,
INetworkTileEntityEventListener {
    private static final Direction[] directions = Direction.values();
    public static Random randomizer = new Random();
    public String owner = "null";
    public int totalTradeCount = 0;
    public int stock = 0;

    public TileEntityTradeOMat() {
        super(4);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.owner = nbttagcompound.func_74779_i("owner");
        this.totalTradeCount = nbttagcompound.func_74762_e("totalTradeCount");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74778_a("owner", this.owner);
        nbttagcompound.func_74768_a("totalTradeCount", this.totalTradeCount);
    }

    @Override
    public void readDescriptionNBT(NBTTagCompound tag) {
        super.readDescriptionNBT(tag);
        this.owner = tag.func_74779_i("owner");
    }

    @Override
    public void writeDescriptionNBT(NBTTagCompound tag) {
        super.writeDescriptionNBT(tag);
        tag.func_74778_a("owner", this.owner);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.inventory[0] != null && this.inventory[1] != null && this.inventory[2] != null && StackUtil.isStackEqual(this.inventory[0], this.inventory[2]) && this.inventory[2].field_77994_a >= this.inventory[0].field_77994_a && (this.inventory[3] == null || StackUtil.isStackEqual(this.inventory[1], this.inventory[3]) && this.inventory[3].field_77994_a + this.inventory[1].field_77994_a <= this.inventory[3].func_77976_d())) {
            boolean tradePerformed = false;
            Direction[] directionArray = directions;
            int n = directions.length;
            int n2 = 0;
            while (n2 < n) {
                Direction direction = directionArray[n2];
                TileEntity target = direction.applyToTileEntity(this);
                if (target instanceof IInventory && (!(target instanceof TileEntityPersonalChest) || ((TileEntityPersonalChest)target).owner.equals(this.owner))) {
                    IInventory targetInventory = (IInventory)target;
                    if (target instanceof TileEntityChest) {
                        targetInventory = Blocks.field_150486_ae.func_149951_m(target.func_145831_w(), target.field_145851_c, target.field_145848_d, target.field_145849_e);
                    }
                    if (targetInventory.func_70302_i_() >= 18) {
                        int inputSpace = 0;
                        int outputAvailable = 0;
                        int i = 0;
                        while (i < targetInventory.func_70302_i_()) {
                            ItemStack itemStack = targetInventory.func_70301_a(i);
                            if (itemStack == null) {
                                inputSpace += this.inventory[0].func_77976_d();
                            } else {
                                if (StackUtil.isStackEqual(itemStack, this.inventory[0])) {
                                    inputSpace += itemStack.func_77976_d() - itemStack.field_77994_a;
                                }
                                if (StackUtil.isStackEqual(itemStack, this.inventory[1])) {
                                    outputAvailable += itemStack.field_77994_a;
                                }
                            }
                            ++i;
                        }
                        int outputSpace = this.inventory[3] == null ? this.inventory[1].func_77976_d() : this.inventory[3].func_77976_d() - this.inventory[3].field_77994_a;
                        int tradeCount = Math.min(Math.min(Math.min(this.inventory[2].field_77994_a / this.inventory[0].field_77994_a, inputSpace / this.inventory[0].field_77994_a), outputSpace / this.inventory[1].field_77994_a), outputAvailable / this.inventory[1].field_77994_a);
                        if (tradeCount > 0) {
                            ItemStack gs;
                            int inputCount = this.inventory[0].field_77994_a * tradeCount;
                            int outputCount = this.inventory[1].field_77994_a * tradeCount;
                            this.inventory[2].field_77994_a -= inputCount;
                            if (this.inventory[2].field_77994_a == 0) {
                                this.inventory[2] = null;
                            }
                            if ((gs = StackUtil.getFromInventory(targetInventory, new ItemStack(this.inventory[1].func_77973_b(), outputCount, this.inventory[1].func_77960_j()))) != null) {
                                if (this.inventory[3] == null) {
                                    this.inventory[3] = gs;
                                } else {
                                    this.inventory[3].field_77994_a += gs.field_77994_a;
                                }
                            }
                            StackUtil.putInInventory(targetInventory, new ItemStack(this.inventory[0].func_77973_b(), inputCount, this.inventory[0].func_77960_j()));
                            this.totalTradeCount += tradeCount;
                            tradePerformed = true;
                            IC2.network.initiateTileEntityEvent(this, 0, true);
                            this.func_70296_d();
                            break;
                        }
                    }
                }
                ++n2;
            }
            if (tradePerformed) {
                this.updateStock();
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.updateStock();
        }
    }

    public void updateStock() {
        this.stock = 0;
        Direction[] directionArray = directions;
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            TileEntity target = direction.applyToTileEntity(this);
            if (target instanceof IInventory && (!(target instanceof TileEntityPersonalChest) || ((TileEntityPersonalChest)target).owner.equals(this.owner))) {
                IInventory targetInventory = (IInventory)target;
                if (target instanceof TileEntityChest) {
                    targetInventory = Blocks.field_150486_ae.func_149951_m(target.func_145831_w(), target.field_145851_c, target.field_145848_d, target.field_145849_e);
                }
                if (targetInventory.func_70302_i_() >= 18) {
                    int i = 0;
                    while (i < targetInventory.func_70302_i_()) {
                        ItemStack stack = targetInventory.func_70301_a(i);
                        if (StackUtil.isStackEqual(this.inventory[1], stack)) {
                            this.stock += stack.field_77994_a;
                        }
                        ++i;
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return this.canAccess(entityPlayer);
    }

    @Override
    public boolean canAccess(EntityPlayer player) {
        if (this.owner.equals("null")) {
            this.owner = player.func_146103_bH().getId();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return this.owner.equalsIgnoreCase(player.func_146103_bH().getId());
    }

    @Override
    public String func_145825_b() {
        return "Trade-O-Mat";
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        if (this.canAccess(entityPlayer)) {
            return new ContainerTradeOMatOpen(entityPlayer, this);
        }
        return new ContainerTradeOMatClosed(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        if (this.canAccess(entityPlayer)) {
            return "block.personal.GuiTradeOMatOpen";
        }
        return "block.personal.GuiTradeOMatClosed";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int[] func_94128_d(int var1) {
        return new int[]{var1 == 1 ? 3 : 2};
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                IC2.audioManager.playOnce(this, PositionSpec.Center, "Machines/o-mat.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\n" + "T: " + this + " (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ")");
            }
        }
    }
}

