/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2classic.api.Direction;
import ic2classic.api.energy.event.EnergyTileLoadEvent;
import ic2classic.api.energy.event.EnergyTileUnloadEvent;
import ic2classic.api.energy.tile.IEnergySink;
import ic2classic.core.ExplosionIC2;
import ic2classic.core.IC2;
import ic2classic.core.ITickCallback;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.wiring.TileEntityCable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityLuminator
extends TileEntity
implements IEnergySink {
    public int energy = 0;
    public int ticker = -1;
    public boolean ignoreBlockStay = false;
    public int maxInput = 32;
    public boolean addedToEnergyNet = false;
    private boolean loaded = false;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", (short)this.energy);
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.loaded) {
            if (!this.func_145837_r() && this.field_145850_b != null) {
                if (IC2.platform.isSimulating()) {
                    IC2.addSingleTickCallback(this.field_145850_b, new ITickCallback(){

                        @Override
                        public void tickCallback(World world) {
                            TileEntityLuminator.this.onLoaded();
                        }
                    });
                } else {
                    this.onLoaded();
                }
            } else {
                IC2.log.warn(this + " (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ") was not added, isInvalid=" + this.func_145837_r() + ", worldObj=" + this.field_145850_b);
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    public void func_145845_h() {
        if (IC2.platform.isSimulating()) {
            ++this.ticker;
            if (this.ticker % 4 == 0) {
                --this.energy;
                if (this.energy <= 0) {
                    this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Block.func_149634_a((Item)Ic2Items.luminator.func_77973_b()), this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), 3);
                }
            }
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return emitter instanceof TileEntityCable;
    }

    @Override
    public int demandsEnergy() {
        return this.getMaxEnergy() - this.energy;
    }

    @Override
    public boolean injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            this.poof();
            return false;
        }
        if (amount <= 0) {
            return false;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) == Block.func_149634_a((Item)Ic2Items.luminator.func_77973_b())) {
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Block.func_149634_a((Item)Ic2Items.activeLuminator.func_77973_b()), this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), 3);
            TileEntityLuminator newLumi = (TileEntityLuminator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return newLumi.injectEnergy(directionFrom, amount);
        }
        if (this.energy >= this.getMaxEnergy()) {
            return false;
        }
        this.energy += amount;
        return true;
    }

    @Override
    public int getMaxSafeInput() {
        return this.maxInput;
    }

    public int getMaxEnergy() {
        return 10000;
    }

    public void poof() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ExplosionIC2 explosion = new ExplosionIC2(this.field_145850_b, null, 0.5 + (double)this.field_145851_c, 0.5 + (double)this.field_145848_d, 0.5 + (double)this.field_145849_e, 0.5f, 0.85f, 2.0f);
        explosion.doExplosion();
    }

    public boolean canCableConnectFrom(int x, int y, int z) {
        int facing = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        switch (facing) {
            case 0: {
                return x == this.field_145851_c && y == this.field_145848_d + 1 && z == this.field_145849_e;
            }
            case 1: {
                return x == this.field_145851_c && y == this.field_145848_d - 1 && z == this.field_145849_e;
            }
            case 2: {
                return x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e + 1;
            }
            case 3: {
                return x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e - 1;
            }
            case 4: {
                return x == this.field_145851_c + 1 && y == this.field_145848_d && z == this.field_145849_e;
            }
            case 5: {
                return x == this.field_145851_c - 1 && y == this.field_145848_d && z == this.field_145849_e;
            }
        }
        return false;
    }
}

