/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item;

import ic2classic.core.IC2;
import ic2classic.core.Ic2Items;
import ic2classic.core.item.BehaviorScrapboxDispense;
import ic2classic.core.item.ItemIC2;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemScrapbox
extends ItemIC2 {
    public static List<Drop> dropList = new ArrayList<Drop>();

    public ItemScrapbox(int sprite) {
        super(sprite);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new BehaviorScrapboxDispense());
    }

    public static void init() {
        ArrayList ores;
        if (IC2.suddenlyHoes) {
            ItemScrapbox.addDrop(Items.field_151017_I, 9001.0f);
        } else {
            ItemScrapbox.addDrop(Items.field_151017_I, 5.01f);
        }
        ItemScrapbox.addDrop(Blocks.field_150346_d, 5.0f);
        ItemScrapbox.addDrop(Items.field_151055_y, 4.0f);
        ItemScrapbox.addDrop((Block)Blocks.field_150349_c, 3.0f);
        ItemScrapbox.addDrop(Blocks.field_150351_n, 3.0f);
        ItemScrapbox.addDrop(Blocks.field_150424_aL, 2.0f);
        ItemScrapbox.addDrop(Items.field_151078_bh, 2.0f);
        ItemScrapbox.addDrop(Items.field_151034_e, 1.5f);
        ItemScrapbox.addDrop(Items.field_151025_P, 1.5f);
        ItemScrapbox.addDrop(Ic2Items.filledTinCan, 1.5f);
        ItemScrapbox.addDrop(Items.field_151041_m);
        ItemScrapbox.addDrop(Items.field_151038_n);
        ItemScrapbox.addDrop(Items.field_151039_o);
        ItemScrapbox.addDrop(Blocks.field_150425_aM);
        ItemScrapbox.addDrop(Items.field_151155_ap);
        ItemScrapbox.addDrop(Items.field_151116_aA);
        ItemScrapbox.addDrop(Items.field_151008_G);
        ItemScrapbox.addDrop(Items.field_151103_aS);
        ItemScrapbox.addDrop(Items.field_151157_am, 0.9f);
        ItemScrapbox.addDrop(Items.field_151083_be, 0.9f);
        ItemScrapbox.addDrop(Blocks.field_150423_aK, 0.9f);
        ItemScrapbox.addDrop(Items.field_151077_bg, 0.9f);
        ItemScrapbox.addDrop(Items.field_151143_au, 0.9f);
        ItemScrapbox.addDrop(Items.field_151137_ax, 0.9f);
        ItemScrapbox.addDrop(Ic2Items.rubber, 0.8f);
        ItemScrapbox.addDrop(Items.field_151114_aO, 0.8f);
        ItemScrapbox.addDrop(Ic2Items.coalDust, 0.8f);
        ItemScrapbox.addDrop(Ic2Items.copperDust, 0.8f);
        ItemScrapbox.addDrop(Ic2Items.tinDust, 0.8f);
        ItemScrapbox.addDrop(Ic2Items.plantBall, 0.7f);
        ItemScrapbox.addDrop(Ic2Items.suBattery, 0.7f);
        ItemScrapbox.addDrop(Ic2Items.ironDust, 0.7f);
        ItemScrapbox.addDrop(Ic2Items.goldDust, 0.7f);
        ItemScrapbox.addDrop(Items.field_151123_aH, 0.6f);
        ItemScrapbox.addDrop(Blocks.field_150366_p, 0.5f);
        ItemScrapbox.addDrop((Item)Items.field_151169_ag, 0.5f);
        ItemScrapbox.addDrop(Blocks.field_150352_o, 0.5f);
        ItemScrapbox.addDrop(Items.field_151105_aU, 0.5f);
        ItemScrapbox.addDrop(Items.field_151045_i, 0.1f);
        ItemScrapbox.addDrop(Items.field_151166_bC, 0.05f);
        if (Ic2Items.copperOre != null) {
            ItemScrapbox.addDrop(Ic2Items.copperOre.func_77973_b(), 0.7f);
        } else {
            ores = OreDictionary.getOres((String)"oreCopper");
            if (!ores.isEmpty()) {
                ItemScrapbox.addDrop(((ItemStack)ores.get(0)).func_77946_l(), 0.7f);
            }
        }
        if (Ic2Items.tinOre != null) {
            ItemScrapbox.addDrop(Ic2Items.tinOre.func_77973_b(), 0.7f);
        } else {
            ores = OreDictionary.getOres((String)"oreTin");
            if (!ores.isEmpty()) {
                ItemScrapbox.addDrop(((ItemStack)ores.get(0)).func_77946_l(), 0.7f);
            }
        }
    }

    public static void addDrop(Item item) {
        ItemScrapbox.addDrop(new ItemStack(item), 1.0f);
    }

    public static void addDrop(Item item, float chance) {
        ItemScrapbox.addDrop(new ItemStack(item), chance);
    }

    public static void addDrop(Block block) {
        ItemScrapbox.addDrop(new ItemStack(block), 1.0f);
    }

    public static void addDrop(Block block, float chance) {
        ItemScrapbox.addDrop(new ItemStack(block), chance);
    }

    public static void addDrop(ItemStack item) {
        ItemScrapbox.addDrop(item, 1.0f);
    }

    public static void addDrop(ItemStack item, float chance) {
        dropList.add(new Drop(item, chance));
    }

    public static ItemStack getDrop(World world) {
        if (!dropList.isEmpty()) {
            float dropChance = world.field_73012_v.nextFloat() * ItemScrapbox.dropList.get((int)(ItemScrapbox.dropList.size() - 1)).upperChanceBound;
            for (Drop drop : dropList) {
                if (!(drop.upperChanceBound >= dropChance)) continue;
                return drop.itemStack.func_77946_l();
            }
        }
        return null;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        ItemStack itemStack;
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
        }
        if ((itemStack = ItemScrapbox.getDrop(world)) != null) {
            entityplayer.func_145779_a(itemStack.func_77973_b(), itemStack.func_77960_j());
        }
        return itemstack;
    }

    public static List<Map.Entry<ItemStack, Float>> getDropList() {
        ArrayList<Map.Entry<ItemStack, Float>> ret = new ArrayList<Map.Entry<ItemStack, Float>>();
        for (Drop drop : dropList) {
            ret.add(new AbstractMap.SimpleEntry<ItemStack, Float>(drop.itemStack, Float.valueOf(drop.upperChanceBound)));
        }
        return ret;
    }

    static class Drop {
        ItemStack itemStack;
        float upperChanceBound;

        Drop(ItemStack itemStack, float chance) {
            this.itemStack = itemStack;
            this.upperChanceBound = dropList.isEmpty() ? chance : ItemScrapbox.dropList.get((int)(ItemScrapbox.dropList.size() - 1)).upperChanceBound + chance;
        }
    }
}

