/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.armor;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.api.IMetalArmor;
import ic2classic.core.IC2;
import ic2classic.core.item.ElectricItem;
import ic2classic.core.item.armor.ItemArmorElectric;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorNanoSuit
extends ItemArmorElectric
implements IMetalArmor {
    public ItemArmorNanoSuit(int index, int armorrendering, int armorType) {
        super(index, armorrendering, armorType, 100000, 160, 2);
        if (armorType == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "ic2classic:nano";
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == 3) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = energyPerDamage > 0 ? 25 * ElectricItem.discharge(armor, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true) / energyPerDamage : 0;
            return new ISpecialArmor.ArmorProperties(10, damage < 8.0 ? 1.0 : 0.875, damageLimit);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (IC2.platform.isSimulating() && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ItemStack armor = player.field_71071_by.field_70460_b[0];
            if (armor != null && armor.func_77973_b() == this) {
                int fallDamage = (int)event.distance - 3;
                if (fallDamage >= 8) {
                    return;
                }
                int energyCost = this.getEnergyPerDamage() * fallDamage;
                if (energyCost <= ElectricItem.discharge(armor, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true)) {
                    ElectricItem.discharge(armor, energyCost, Integer.MAX_VALUE, true, false);
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.9;
    }

    @Override
    public int getEnergyPerDamage() {
        return 800;
    }

    @Override
    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }
}

