/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.api.BaseSeed;
import ic2classic.api.CropCard;
import ic2classic.api.Crops;
import ic2classic.api.TECrop;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Icons;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.crop.IC2Crops;
import ic2classic.core.item.ItemCropSeed;
import ic2classic.core.util.StackUtil;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;

public class TileEntityCrop
extends TECrop {
    public int growthPoints = 0;
    public boolean upgraded = false;
    public char ticker = (char)IC2.random.nextInt(tickRate);
    @Deprecated
    public boolean dirty = true;
    public static char tickRate = (char)256;
    private boolean created = false;
    public byte humidity = (byte)-1;
    public byte nutrients = (byte)-1;
    public byte airQuality = (byte)-1;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.id = nbttagcompound.func_74765_d("cropid");
        this.size = nbttagcompound.func_74771_c("size");
        this.statGrowth = nbttagcompound.func_74771_c("statGrowth");
        this.statGain = nbttagcompound.func_74771_c("statGain");
        this.statResistance = nbttagcompound.func_74771_c("statResistance");
        this.custumData = nbttagcompound.func_74770_j("customData");
        this.growthPoints = nbttagcompound.func_74762_e("growthPoints");
        try {
            this.nutrientStorage = nbttagcompound.func_74762_e("nutrientStorage");
            this.waterStorage = nbttagcompound.func_74762_e("waterStorage");
        }
        catch (Throwable e) {
            this.nutrientStorage = nbttagcompound.func_74771_c("nutrientStorage");
            this.waterStorage = nbttagcompound.func_74771_c("waterStorage");
        }
        this.upgraded = nbttagcompound.func_74767_n("upgraded");
        this.scanLevel = nbttagcompound.func_74771_c("scanLevel");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("cropid", this.id);
        nbttagcompound.func_74774_a("size", this.size);
        nbttagcompound.func_74774_a("statGrowth", this.statGrowth);
        nbttagcompound.func_74774_a("statGain", this.statGain);
        nbttagcompound.func_74774_a("statResistance", this.statResistance);
        nbttagcompound.func_74773_a("customData", this.custumData);
        nbttagcompound.func_74768_a("growthPoints", this.growthPoints);
        nbttagcompound.func_74768_a("nutrientStorage", this.nutrientStorage);
        nbttagcompound.func_74768_a("waterStorage", this.waterStorage);
        nbttagcompound.func_74757_a("upgraded", this.upgraded);
        nbttagcompound.func_74774_a("scanLevel", this.scanLevel);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.created && !IC2.platform.isSimulating()) {
            this.created = true;
        }
        this.ticker = (char)(this.ticker + '\u0001');
        if (this.ticker % tickRate == 0) {
            this.tick();
        }
        if (this.dirty) {
            this.dirty = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (IC2.platform.isSimulating()) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public final Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeDescriptionNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readDescriptionNBT(pkt.func_148857_g());
    }

    public void writeDescriptionNBT(NBTTagCompound tag) {
        tag.func_74777_a("id", this.id);
        tag.func_74774_a("size", this.size);
        tag.func_74757_a("upgraded", this.upgraded);
        tag.func_74773_a("customData", this.custumData);
    }

    public void readDescriptionNBT(NBTTagCompound tag) {
        this.id = tag.func_74765_d("id");
        this.size = tag.func_74771_c("size");
        this.upgraded = tag.func_74767_n("upgraded");
        this.custumData = tag.func_74770_j("customData");
        this.dirty = true;
    }

    public void tick() {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (this.ticker % (tickRate << 2) == 0) {
            this.humidity = this.updateHumidity();
        }
        if ((this.ticker + tickRate) % (tickRate << 2) == 0) {
            this.nutrients = this.updateNutrients();
        }
        if ((this.ticker + tickRate * 2) % (tickRate << 2) == 0) {
            this.airQuality = this.updateAirQuality();
        }
        if (!(this.id >= 0 || this.upgraded && this.attemptCrossing())) {
            if (IC2.random.nextInt(100) == 0 && !this.hasEx()) {
                this.reset();
                this.id = (short)IC2Crops.weed.getId();
                this.size = 1;
            } else {
                if (this.exStorage > 0 && IC2.random.nextInt(10) == 0) {
                    --this.exStorage;
                }
                return;
            }
        }
        this.crop().tick(this);
        if (this.crop().canGrow(this)) {
            this.growthPoints += this.calcGrowthRate();
            if (this.id > -1 && this.growthPoints >= this.crop().growthDuration(this)) {
                this.growthPoints = 0;
                this.size = (byte)(this.size + 1);
                this.dirty = true;
            }
        }
        if (this.nutrientStorage > 0) {
            --this.nutrientStorage;
        }
        if (this.waterStorage > 0) {
            --this.waterStorage;
        }
        if (this.crop().isWeed(this) && IC2.random.nextInt(50) - this.statGrowth <= 2) {
            this.generateWeed();
        }
    }

    public void generateWeed() {
        Block block;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        switch (IC2.random.nextInt(4)) {
            case 0: {
                ++x;
            }
            case 1: {
                --x;
            }
            case 2: {
                ++z;
            }
            case 3: {
                --z;
            }
        }
        if (this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)this.field_145850_b.func_147438_o(x, y, z);
            if (crop.id == -1 || !crop.crop().isWeed(crop) && IC2.random.nextInt(32) >= crop.statResistance && !crop.hasEx()) {
                byte newGrowth = this.statGrowth;
                if (crop.statGrowth > newGrowth) {
                    newGrowth = crop.statGrowth;
                }
                if (newGrowth < 31 && IC2.random.nextBoolean()) {
                    newGrowth = (byte)(newGrowth + 1);
                }
                crop.reset();
                crop.id = 0;
                crop.size = 1;
                crop.statGrowth = newGrowth;
            }
        } else if (this.field_145850_b.func_147437_c(x, y, z) && ((block = this.field_145850_b.func_147439_a(x, y - 1, z)) == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150458_ak)) {
            this.field_145850_b.func_147449_b(x, y - 1, z, (Block)Blocks.field_150349_c);
            this.field_145850_b.func_147465_d(x, y, z, (Block)Blocks.field_150329_H, 1, 3);
        }
    }

    public boolean hasEx() {
        if (this.exStorage > 0) {
            this.exStorage -= 5;
            return true;
        }
        return false;
    }

    public boolean attemptCrossing() {
        if (IC2.random.nextInt(3) != 0) {
            return false;
        }
        LinkedList<TileEntityCrop> crops = new LinkedList<TileEntityCrop>();
        this.askCropJoinCross(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, crops);
        this.askCropJoinCross(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, crops);
        this.askCropJoinCross(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, crops);
        this.askCropJoinCross(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, crops);
        if (crops.size() < 2) {
            return false;
        }
        int[] ratios = new int[256];
        int i = 1;
        while (i < ratios.length) {
            if (CropCard.idExists(i) && CropCard.getCrop(i).canGrow(this)) {
                int j = 0;
                while (j < crops.size()) {
                    int n = i;
                    ratios[n] = ratios[n] + this.calculateRatioFor(CropCard.getCrop(i), crops.get(j).crop());
                    ++j;
                }
            }
            ++i;
        }
        int total = 0;
        int i2 = 0;
        while (i2 < ratios.length) {
            total += ratios[i2];
            ++i2;
        }
        total = IC2.random.nextInt(total);
        i2 = 0;
        while (i2 < ratios.length) {
            if (ratios[i2] > 0 && ratios[i2] > total) {
                total = i2;
                break;
            }
            total -= ratios[i2];
            ++i2;
        }
        this.upgraded = false;
        this.id = (short)total;
        this.dirty = true;
        this.size = 1;
        this.statGrowth = 0;
        this.statResistance = 0;
        this.statGain = 0;
        i2 = 0;
        while (i2 < crops.size()) {
            this.statGrowth = (byte)(this.statGrowth + crops.get((int)i2).statGrowth);
            this.statResistance = (byte)(this.statResistance + crops.get((int)i2).statResistance);
            this.statGain = (byte)(this.statGain + crops.get((int)i2).statGain);
            ++i2;
        }
        int count = crops.size();
        this.statGrowth = (byte)(this.statGrowth / count);
        this.statResistance = (byte)(this.statResistance / count);
        this.statGain = (byte)(this.statGain / count);
        this.statGrowth = (byte)(this.statGrowth + (IC2.random.nextInt(1 + 2 * count) - count));
        if (this.statGrowth < 0) {
            this.statGrowth = 0;
        }
        if (this.statGrowth > 31) {
            this.statGrowth = (byte)31;
        }
        this.statGain = (byte)(this.statGain + (IC2.random.nextInt(1 + 2 * count) - count));
        if (this.statGain < 0) {
            this.statGain = 0;
        }
        if (this.statGain > 31) {
            this.statGain = (byte)31;
        }
        this.statResistance = (byte)(this.statResistance + (IC2.random.nextInt(1 + 2 * count) - count));
        if (this.statResistance < 0) {
            this.statResistance = 0;
        }
        if (this.statResistance > 31) {
            this.statResistance = (byte)31;
        }
        return true;
    }

    public int calculateRatioFor(CropCard a, CropCard b) {
        if (a == b) {
            return 500;
        }
        int value = 0;
        int i = 0;
        while (i < 5) {
            int c = a.stat(i) - b.stat(i);
            if (c < 0) {
                c *= -1;
            }
            switch (c) {
                default: {
                    --value;
                }
                case 0: {
                    value += 2;
                }
                case 1: {
                    ++value;
                }
                case 2: 
            }
            ++i;
        }
        i = 0;
        while (i < a.attributes().length) {
            int j = 0;
            while (j < b.attributes().length) {
                if (a.attributes()[i].equalsIgnoreCase(b.attributes()[j])) {
                    value += 5;
                }
                ++j;
            }
            ++i;
        }
        if (b.tier() < a.tier() - 1) {
            value -= 2 * (a.tier() - b.tier());
        }
        if (b.tier() - 3 > a.tier()) {
            value -= b.tier() - a.tier();
        }
        if (value < 0) {
            value = 0;
        }
        return value;
    }

    public void askCropJoinCross(int x, int y, int z, LinkedList<TileEntityCrop> crops) {
        if (!(this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityCrop)) {
            return;
        }
        TileEntityCrop sidecrop = (TileEntityCrop)this.field_145850_b.func_147438_o(x, y, z);
        if (sidecrop.id <= 0) {
            return;
        }
        if (!sidecrop.crop().canGrow(this) || !sidecrop.crop().canCross(sidecrop)) {
            return;
        }
        int base = 4;
        if (sidecrop.statGrowth >= 16) {
            ++base;
        }
        if (sidecrop.statGrowth >= 30) {
            ++base;
        }
        if (sidecrop.statResistance >= 28) {
            base += 27 - sidecrop.statResistance;
        }
        if (base >= IC2.random.nextInt(20)) {
            crops.add(sidecrop);
        }
    }

    public boolean leftclick(EntityPlayer player) {
        if (this.id < 0) {
            if (this.upgraded) {
                this.upgraded = false;
                this.dirty = true;
                if (IC2.platform.isSimulating()) {
                    StackUtil.dropAsEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, new ItemStack(Ic2Items.crop.func_77973_b()));
                }
                return true;
            }
            return false;
        }
        return this.crop().leftclick(this, player);
    }

    @Override
    public boolean pick(boolean manual) {
        int i;
        if (this.id < 0) {
            return false;
        }
        boolean bonus = this.harvest(false);
        float firstchance = this.crop().dropSeedChance(this);
        int i2 = 0;
        while (i2 < this.statResistance) {
            firstchance *= 1.1f;
            ++i2;
        }
        int drop = 0;
        if (bonus) {
            if (IC2.random.nextFloat() <= (firstchance + 1.0f) * 0.8f) {
                ++drop;
            }
            float chance = this.crop().dropSeedChance(this) + (float)this.statGrowth / 100.0f;
            if (!manual) {
                chance *= 0.8f;
            }
            i = 23;
            while (i < this.statGain) {
                chance *= 0.95f;
                ++i;
            }
            if (IC2.random.nextFloat() <= chance) {
                ++drop;
            }
        } else if (IC2.random.nextFloat() <= firstchance * 1.5f) {
            ++drop;
        }
        ItemStack[] re = new ItemStack[drop];
        i = 0;
        while (i < drop) {
            re[i] = this.crop().getSeeds(this);
            ++i;
        }
        this.reset();
        if (IC2.platform.isSimulating() && re != null && re.length > 0) {
            int x = 0;
            while (x < re.length) {
                if (re[x].func_77973_b() != Ic2Items.cropSeed) {
                    re[x].field_77990_d = null;
                }
                StackUtil.dropAsEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, re[x]);
                ++x;
            }
        }
        return true;
    }

    public boolean rightclick(EntityPlayer player) {
        ItemStack current = player.func_71045_bC();
        if (current != null) {
            if (this.id < 0) {
                if (current.func_77973_b() == Ic2Items.crop.func_77973_b() && !this.upgraded) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --current.field_77994_a;
                        if (current.field_77994_a <= 0) {
                            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                        }
                    }
                    this.upgraded = true;
                    this.dirty = true;
                    return true;
                }
                if (this.applyBaseSeed(current, player)) {
                    return true;
                }
            } else if (current.func_77973_b() == Ic2Items.cropnalyzer) {
                if (IC2.platform.isSimulating()) {
                    String desc = this.getScanned();
                    if (desc == null) {
                        desc = "Unknown Crop";
                    }
                    IC2.platform.messagePlayer(player, desc);
                }
                return true;
            }
            if (current.func_77973_b() == Items.field_151131_as || current.func_77973_b() == Ic2Items.waterCell) {
                if (this.waterStorage < 10) {
                    this.waterStorage = 10;
                    return true;
                }
                return current.func_77973_b() == Items.field_151131_as;
            }
            if (current.func_77973_b() == Items.field_151014_N) {
                if (this.nutrientStorage <= 50) {
                    this.nutrientStorage += 25;
                    --current.field_77994_a;
                    if (current.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                    return true;
                }
                return false;
            }
            if (current.func_77973_b() == Items.field_151100_aR && current.func_77960_j() == 15 || current.func_77973_b() == Ic2Items.fertilizer) {
                if (this.applyFertilizer(true)) {
                    --current.field_77994_a;
                    if (current.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                    return true;
                }
                return false;
            }
            if (current.func_77973_b() == Ic2Items.hydratingCell) {
                if (this.applyHydration(true, current)) {
                    if (current.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                    return true;
                }
                return false;
            }
            if (current.func_77973_b() == Ic2Items.weedEx && this.applyWeedEx(true)) {
                current.func_77972_a(1, (EntityLivingBase)player);
                if (current.func_77960_j() >= current.func_77958_k()) {
                    --current.field_77994_a;
                }
                if (current.field_77994_a <= 0) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                }
                return true;
            }
        }
        if (this.id < 0) {
            return false;
        }
        return this.crop().rightclick(this, player);
    }

    public boolean applyBaseSeed(ItemStack current, EntityPlayer player) {
        BaseSeed seed = CropCard.getBaseSeed(current);
        if (seed != null) {
            if (current.field_77994_a < seed.stackSize) {
                return false;
            }
            if (this.tryPlantIn(seed.id, seed.size, seed.statGrowth, seed.statGain, seed.statResistance, 1)) {
                if (current.func_77973_b().hasContainerItem(current)) {
                    current = current.func_77973_b().getContainerItem(current);
                } else {
                    current.field_77994_a -= seed.stackSize;
                    if (current.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean tryPlantIn(int i, int si, int statGr, int statGa, int statRe, int scan) {
        if (this.id > -1 || i <= 0 || this.upgraded) {
            return false;
        }
        if (!CropCard.getCrop(i).canGrow(this)) {
            return false;
        }
        this.reset();
        this.id = (short)i;
        this.size = (byte)si;
        this.statGrowth = (byte)statGr;
        this.statGain = (byte)statGa;
        this.statResistance = (byte)statRe;
        this.scanLevel = (byte)scan;
        return true;
    }

    public boolean applyFertilizer(boolean manual) {
        if (this.nutrientStorage >= 100) {
            return false;
        }
        this.nutrientStorage += manual ? 100 : 90;
        return true;
    }

    public boolean applyHydration(boolean manual, ItemStack current) {
        int apply;
        if (!manual && this.waterStorage >= 180 || this.waterStorage >= 200) {
            return false;
        }
        int n = apply = manual ? 200 - this.waterStorage : 180 - this.waterStorage;
        if (apply + current.func_77960_j() > current.func_77958_k()) {
            apply = current.func_77958_k() - current.func_77960_j();
        }
        current.func_77964_b(current.func_77960_j() + apply);
        if (current.func_77960_j() >= current.func_77958_k()) {
            --current.field_77994_a;
        }
        this.waterStorage += apply;
        return true;
    }

    public boolean applyWeedEx(boolean manual) {
        boolean trigger;
        if (this.exStorage >= 100 && manual || this.exStorage >= 150) {
            return false;
        }
        this.exStorage += 50;
        boolean bl = trigger = this.field_145850_b.field_73012_v.nextInt(3) == 0;
        if (manual) {
            boolean bl2 = trigger = this.field_145850_b.field_73012_v.nextInt(5) == 0;
        }
        if (this.id > 0 && this.exStorage >= 75 && trigger) {
            switch (this.field_145850_b.field_73012_v.nextInt(5)) {
                case 0: {
                    if (this.statGrowth > 0) {
                        this.statGrowth = (byte)(this.statGrowth - 1);
                    }
                }
                case 1: {
                    if (this.statGain <= 0) break;
                    this.statGain = (byte)(this.statGain - 1);
                }
            }
            if (this.statResistance > 0) {
                this.statResistance = (byte)(this.statResistance - 1);
            }
        }
        return true;
    }

    @Override
    public boolean harvest(boolean manual) {
        if (this.id < 0 || !this.crop().canBeHarvested(this)) {
            return false;
        }
        float chance = this.crop().dropGainChance();
        int i = 0;
        while (i < this.statGain) {
            chance *= 1.03f;
            ++i;
        }
        chance -= IC2.random.nextFloat();
        int drop = 0;
        while (chance > 0.0f) {
            ++drop;
            chance -= IC2.random.nextFloat();
        }
        ItemStack[] re = new ItemStack[drop];
        int i2 = 0;
        while (i2 < drop) {
            re[i2] = this.crop().getGain(this);
            if (re[i2] != null && IC2.random.nextInt(100) <= this.statGain) {
                ++re[i2].field_77994_a;
            }
            ++i2;
        }
        this.size = this.crop().getSizeAfterHarvest(this);
        this.dirty = true;
        if (IC2.platform.isSimulating() && re != null && re.length > 0) {
            int x = 0;
            while (x < re.length) {
                StackUtil.dropAsEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, re[x]);
                ++x;
            }
        }
        return true;
    }

    public void onNeighbourChange() {
        if (this.id < 0) {
            return;
        }
        this.crop().onNeighbourChange(this);
    }

    public boolean emitRedstone() {
        if (this.id < 0) {
            return false;
        }
        return this.crop().emitRedstone(this);
    }

    public void onBlockDestroyed() {
        if (this.id < 0) {
            return;
        }
        this.crop().onBlockDestroyed(this);
    }

    public int getEmittedLight() {
        if (this.id < 0) {
            return 0;
        }
        return this.crop().getEmittedLight(this);
    }

    @Override
    public byte getHumidity() {
        if (this.humidity == -1) {
            this.humidity = this.updateHumidity();
        }
        return this.humidity;
    }

    @Override
    public byte getNutrients() {
        if (this.nutrients == -1) {
            this.nutrients = this.updateNutrients();
        }
        return this.nutrients;
    }

    @Override
    public byte getAirQuality() {
        if (this.airQuality == -1) {
            this.airQuality = this.updateAirQuality();
        }
        return this.airQuality;
    }

    public byte updateHumidity() {
        int value = Crops.getHumidityBiomeBonus(this.field_145850_b.func_72959_q().func_76935_a(this.field_145851_c, this.field_145849_e));
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) >= 7) {
            value += 2;
        }
        if (this.waterStorage >= 5) {
            value += 2;
        }
        return (byte)(value += (this.waterStorage + 24) / 25);
    }

    public byte updateNutrients() {
        int value = Crops.getNutrientBiomeBonus(this.field_145850_b.func_72959_q().func_76935_a(this.field_145851_c, this.field_145849_e));
        int i = 2;
        while (i < 5) {
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - i, this.field_145849_e) != Blocks.field_150346_d) break;
            ++value;
            ++i;
        }
        return (byte)(value += (this.nutrientStorage + 19) / 20);
    }

    public byte updateAirQuality() {
        int value = 0;
        int height = (this.field_145848_d - 64) / 15;
        if (height > 4) {
            height = 4;
        }
        if (height < 0) {
            height = 0;
        }
        value += height;
        int fresh = 9;
        int x = this.field_145851_c - 1;
        while (x < this.field_145851_c + 1 && fresh > 0) {
            int z = this.field_145849_e - 1;
            while (z < this.field_145849_e + 1 && fresh > 0) {
                if (this.field_145850_b.func_147439_a(x, this.field_145848_d, z).func_149662_c() || this.field_145850_b.func_147438_o(x, this.field_145848_d, z) instanceof TileEntityCrop) {
                    --fresh;
                }
                ++z;
            }
            ++x;
        }
        value += fresh / 2;
        if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            value += 2;
        }
        return (byte)value;
    }

    public byte updateMultiCulture() {
        LinkedList<CropCard> crops = new LinkedList<CropCard>();
        int x = -1;
        while (x < 1) {
            int z = -1;
            while (z < 1) {
                if (this.field_145850_b.func_147438_o(x + this.field_145851_c, this.field_145848_d, z + this.field_145849_e) instanceof TileEntityCrop) {
                    this.addIfNotPresent(((TileEntityCrop)this.field_145850_b.func_147438_o(x + this.field_145851_c, this.field_145848_d, z + this.field_145849_e)).crop(), crops);
                }
                ++z;
            }
            ++x;
        }
        return (byte)(crops.size() - 1);
    }

    public void addIfNotPresent(CropCard crop, LinkedList<CropCard> crops) {
        int i = 0;
        while (i < crops.size()) {
            if (crop == crops.get(i)) {
                return;
            }
            ++i;
        }
        crops.add(crop);
    }

    public int calcGrowthRate() {
        int have;
        int base = 3 + IC2.random.nextInt(7) + this.statGrowth;
        int need = (this.crop().tier() - 1) * 4 + this.statGrowth + this.statGain + this.statResistance;
        if (need < 0) {
            need = 0;
        }
        if ((have = this.crop().weightInfluences(this, this.getHumidity(), this.getNutrients(), this.getAirQuality()) * 5) >= need) {
            base = base * (100 + (have - need)) / 100;
        } else {
            int neg = (need - have) * 4;
            if (neg > 100 && IC2.random.nextInt(32) > this.statResistance) {
                this.reset();
                base = 0;
            } else if ((base = base * (100 - neg) / 100) < 0) {
                base = 0;
            }
        }
        return base;
    }

    public void calcTrampling() {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (IC2.random.nextInt(100) == 0 && IC2.random.nextInt(40) > this.statResistance) {
            this.reset();
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Blocks.field_150346_d);
        }
    }

    public CropCard crop() {
        return CropCard.getCrop(this.id);
    }

    public IIcon getSprite() {
        if (this.id < 0) {
            if (!this.upgraded) {
                return Ic2Icons.bc_0;
            }
            return Ic2Icons.bc_1;
        }
        return Ic2Icons.bc[this.crop().getSpriteIndex(this)];
    }

    public void onEntityCollision(Entity entity) {
        if (this.id < 0) {
            return;
        }
        if (this.crop().onEntityCollision(this, entity)) {
            this.calcTrampling();
        }
    }

    @Override
    public void reset() {
        this.id = (short)-1;
        this.size = 0;
        this.custumData = new byte[16];
        this.dirty = true;
        this.statGain = 0;
        this.statResistance = 0;
        this.statGrowth = 0;
        this.nutrients = (byte)-1;
        this.airQuality = (byte)-1;
        this.humidity = (byte)-1;
        this.growthPoints = 0;
        this.upgraded = false;
        this.scanLevel = 0;
    }

    @Override
    public void updateState() {
        this.dirty = true;
    }

    public String getScanned() {
        if (this.scanLevel <= 0 || this.id < 0) {
            return null;
        }
        if (this.scanLevel >= 4) {
            return String.valueOf(this.crop().name()) + " - Gr: " + this.statGrowth + " Ga: " + this.statGain + " Re: " + this.statResistance;
        }
        return this.crop().name();
    }

    @Override
    public boolean isBlockBelow(Block block) {
        int i = 1;
        while (i < 4) {
            Block id = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - i, this.field_145849_e);
            if (id.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
                return false;
            }
            if (id == block) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public ItemStack generateSeeds(short plant, byte growth, byte gain, byte resis, byte scan) {
        return ItemCropSeed.generateItemStackFromValues(plant, growth, gain, resis, scan);
    }
}

