/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.api.Direction;
import ic2classic.core.block.wiring.TileEntityCable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

@SideOnly(value=Side.CLIENT)
public class RenderBlockCable
implements ISimpleBlockRenderingHandler {
    private static final Direction[] directions = Direction.values();
    public static int renderId;

    public RenderBlockCable() {
        renderId = RenderingRegistry.getNextAvailableRenderId();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int x, int y, int z, Block block, int modelId, RenderBlocks renderblocks) {
        TileEntity te = iBlockAccess.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return true;
        }
        TileEntityCable cable = (TileEntityCable)te;
        if (cable.foamed > 0) {
            renderblocks.func_147784_q(block, x, y, z);
        } else {
            float th = cable.getCableThickness();
            float sp = (1.0f - th) / 2.0f;
            int connectivity = 0;
            int renderSide = 0;
            int mask = 1;
            Direction[] directionArray = directions;
            int n = directions.length;
            int n2 = 0;
            while (n2 < n) {
                Direction direction = directionArray[n2];
                TileEntity neighbor = direction.applyToTileEntity(cable);
                if (neighbor != null && cable.canInteractWith(neighbor)) {
                    connectivity |= mask;
                    if (neighbor instanceof TileEntityCable && ((TileEntityCable)neighbor).getCableThickness() < th) {
                        renderSide |= mask;
                    }
                }
                mask *= 2;
                ++n2;
            }
            Tessellator tessellator = Tessellator.field_78398_a;
            IIcon texture = block.func_149673_e(iBlockAccess, x, y, z, 0);
            double xD = x;
            double yD = y;
            double zD = z;
            tessellator.func_78380_c(block.func_149677_c(iBlockAccess, x, y, z));
            if (connectivity == 0) {
                block.func_149676_a(sp, sp, sp, sp + th, sp + th, sp + th);
                renderblocks.func_147775_a(block);
                tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                renderblocks.func_147768_a(block, xD, yD, zD, texture);
                tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                renderblocks.func_147806_b(block, xD, yD, zD, texture);
                tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                renderblocks.func_147761_c(block, xD, yD, zD, texture);
                renderblocks.func_147734_d(block, xD, (double)y, zD, texture);
                tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                renderblocks.func_147798_e(block, xD, yD, zD, texture);
                renderblocks.func_147764_f(block, xD, yD, zD, texture);
            } else if (connectivity == 3) {
                block.func_149676_a(0.0f, sp, sp, 1.0f, sp + th, sp + th);
                renderblocks.func_147775_a(block);
                tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                renderblocks.func_147768_a(block, xD, yD, zD, texture);
                tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                renderblocks.func_147806_b(block, xD, yD, zD, texture);
                tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                renderblocks.func_147761_c(block, xD, yD, zD, texture);
                renderblocks.func_147734_d(block, xD, (double)y, zD, texture);
                if ((renderSide & 1) != 0) {
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_147798_e(block, xD, yD, zD, texture);
                }
                if ((renderSide & 2) != 0) {
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_147764_f(block, xD, yD, zD, texture);
                }
            } else if (connectivity == 12) {
                block.func_149676_a(sp, 0.0f, sp, sp + th, 1.0f, sp + th);
                renderblocks.func_147775_a(block);
                tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                renderblocks.func_147761_c(block, xD, yD, zD, texture);
                renderblocks.func_147734_d(block, xD, (double)y, zD, texture);
                tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                renderblocks.func_147798_e(block, xD, yD, zD, texture);
                renderblocks.func_147764_f(block, xD, yD, zD, texture);
                if ((renderSide & 4) != 0) {
                    tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                    renderblocks.func_147768_a(block, xD, yD, zD, texture);
                }
                if ((renderSide & 8) != 0) {
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    renderblocks.func_147806_b(block, xD, yD, zD, texture);
                }
            } else if (connectivity == 48) {
                block.func_149676_a(sp, sp, 0.0f, sp + th, sp + th, 1.0f);
                renderblocks.func_147775_a(block);
                tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                renderblocks.func_147768_a(block, xD, yD, zD, texture);
                tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                renderblocks.func_147806_b(block, xD, yD, zD, texture);
                tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                renderblocks.func_147798_e(block, xD, yD, zD, texture);
                renderblocks.func_147764_f(block, xD, yD, zD, texture);
                if ((renderSide & 0x10) != 0) {
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_147761_c(block, xD, (double)y, zD, texture);
                }
                if ((renderSide & 0x20) != 0) {
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_147734_d(block, xD, yD, zD, texture);
                }
            } else {
                if ((connectivity & 1) == 0) {
                    block.func_149676_a(sp, sp, sp, sp + th, sp + th, sp + th);
                    renderblocks.func_147775_a(block);
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_147798_e(block, xD, yD, zD, texture);
                } else {
                    block.func_149676_a(0.0f, sp, sp, sp, sp + th, sp + th);
                    renderblocks.func_147775_a(block);
                    tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                    renderblocks.func_147768_a(block, xD, yD, zD, texture);
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    renderblocks.func_147806_b(block, xD, yD, zD, texture);
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_147761_c(block, xD, yD, zD, texture);
                    renderblocks.func_147734_d(block, xD, (double)y, zD, texture);
                    if ((renderSide & 1) != 0) {
                        tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                        renderblocks.func_147798_e(block, xD, yD, zD, texture);
                    }
                }
                if ((connectivity & 2) == 0) {
                    block.func_149676_a(sp, sp, sp, sp + th, sp + th, sp + th);
                    renderblocks.func_147775_a(block);
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_147764_f(block, xD, yD, zD, texture);
                } else {
                    block.func_149676_a(sp + th, sp, sp, 1.0f, sp + th, sp + th);
                    renderblocks.func_147775_a(block);
                    tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                    renderblocks.func_147768_a(block, xD, yD, zD, texture);
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    renderblocks.func_147806_b(block, xD, yD, zD, texture);
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_147761_c(block, xD, yD, zD, texture);
                    renderblocks.func_147734_d(block, xD, (double)y, zD, texture);
                    if ((renderSide & 2) != 0) {
                        tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                        renderblocks.func_147764_f(block, xD, yD, zD, texture);
                    }
                }
                if ((connectivity & 4) == 0) {
                    block.func_149676_a(sp, sp, sp, sp + th, sp + th, sp + th);
                    renderblocks.func_147775_a(block);
                    tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                    renderblocks.func_147768_a(block, xD, yD, zD, texture);
                } else {
                    block.func_149676_a(sp, 0.0f, sp, sp + th, sp, sp + th);
                    renderblocks.func_147775_a(block);
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_147761_c(block, xD, yD, zD, texture);
                    renderblocks.func_147734_d(block, xD, (double)y, zD, texture);
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_147798_e(block, xD, yD, zD, texture);
                    renderblocks.func_147764_f(block, xD, yD, zD, texture);
                    if ((renderSide & 4) != 0) {
                        tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                        renderblocks.func_147768_a(block, xD, yD, zD, texture);
                    }
                }
                if ((connectivity & 8) == 0) {
                    block.func_149676_a(sp, sp, sp, sp + th, sp + th, sp + th);
                    renderblocks.func_147775_a(block);
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    renderblocks.func_147806_b(block, xD, yD, zD, texture);
                } else {
                    block.func_149676_a(sp, sp + th, sp, sp + th, 1.0f, sp + th);
                    renderblocks.func_147775_a(block);
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_147761_c(block, xD, yD, zD, texture);
                    renderblocks.func_147734_d(block, xD, (double)y, zD, texture);
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_147798_e(block, xD, yD, zD, texture);
                    renderblocks.func_147764_f(block, xD, yD, zD, texture);
                    if ((renderSide & 8) != 0) {
                        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                        renderblocks.func_147806_b(block, xD, yD, zD, texture);
                    }
                }
                if ((connectivity & 0x10) == 0) {
                    block.func_149676_a(sp, sp, sp, sp + th, sp + th, sp + th);
                    renderblocks.func_147775_a(block);
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_147761_c(block, xD, (double)y, zD, texture);
                } else {
                    block.func_149676_a(sp, sp, 0.0f, sp + th, sp + th, sp);
                    renderblocks.func_147775_a(block);
                    tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                    renderblocks.func_147768_a(block, xD, yD, zD, texture);
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    renderblocks.func_147806_b(block, xD, yD, zD, texture);
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_147798_e(block, xD, yD, zD, texture);
                    renderblocks.func_147764_f(block, xD, yD, zD, texture);
                    if ((renderSide & 0x10) != 0) {
                        tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                        renderblocks.func_147761_c(block, xD, (double)y, zD, texture);
                    }
                }
                if ((connectivity & 0x20) == 0) {
                    block.func_149676_a(sp, sp, sp, sp + th, sp + th, sp + th);
                    renderblocks.func_147775_a(block);
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    renderblocks.func_147734_d(block, xD, yD, zD, texture);
                } else {
                    block.func_149676_a(sp, sp, sp + th, sp + th, sp + th, 1.0f);
                    renderblocks.func_147775_a(block);
                    tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
                    renderblocks.func_147768_a(block, xD, yD, zD, texture);
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    renderblocks.func_147806_b(block, xD, yD, zD, texture);
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    renderblocks.func_147798_e(block, xD, yD, zD, texture);
                    renderblocks.func_147764_f(block, xD, yD, zD, texture);
                    if ((renderSide & 0x20) != 0) {
                        tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                        renderblocks.func_147734_d(block, xD, yD, zD, texture);
                    }
                }
            }
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            renderblocks.func_147775_a(block);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int model) {
        return false;
    }

    public int getRenderId() {
        return renderId;
    }
}

