/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.crop;

import ic2classic.api.CropCard;
import ic2classic.api.TECrop;
import ic2classic.core.block.TileEntityCrop;
import ic2classic.core.block.crop.IC2Crops;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class CropNetherWart
extends CropCard {
    @Override
    public String name() {
        return "Nether Wart";
    }

    @Override
    public String discoveredBy() {
        return "Notch";
    }

    @Override
    public int tier() {
        return 5;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Red", "Nether", "Ingredient", "Soulsand"};
    }

    @Override
    public int getSpriteIndex(TECrop crop) {
        return crop.size + 36;
    }

    @Override
    public boolean canGrow(TECrop crop) {
        return crop.size < 3;
    }

    @Override
    public boolean canBeHarvested(TECrop crop) {
        return crop.size == 3;
    }

    @Override
    public float dropGainChance() {
        return 2.0f;
    }

    @Override
    public ItemStack getGain(TECrop crop) {
        return new ItemStack(Items.field_151075_bm, 1);
    }

    @Override
    public void tick(TECrop crop) {
        TileEntityCrop te = (TileEntityCrop)crop;
        if (te.isBlockBelow(Blocks.field_150425_aM)) {
            if (this.canGrow(te)) {
                TileEntityCrop tmp24_23 = te;
                tmp24_23.growthPoints = (int)((double)tmp24_23.growthPoints + (double)te.calcGrowthRate() * 0.5);
            }
        } else if (te.isBlockBelow(Blocks.field_150433_aE) && crop.func_145831_w().field_73012_v.nextInt(300) == 0) {
            te.id = (short)IC2Crops.cropTerraWart.getId();
        }
    }
}

