/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2classic.api.Direction;
import ic2classic.api.IElectricItem;
import ic2classic.api.energy.event.EnergyTileLoadEvent;
import ic2classic.api.energy.event.EnergyTileUnloadEvent;
import ic2classic.api.energy.tile.IEnergySink;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.machine.tileentity.TileEntityMachine;
import ic2classic.core.item.ElectricItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public abstract class TileEntityElecMachine
extends TileEntityMachine
implements IEnergySink {
    public int energy = 0;
    public int fuelslot;
    public int maxEnergy;
    public int maxInput;
    public int tier = 0;
    public boolean addedToEnergyNet = false;

    public TileEntityElecMachine(int slots, int fuelslot, int maxenergy, int maxinput) {
        super(slots);
        this.fuelslot = fuelslot;
        this.maxEnergy = maxenergy;
        this.maxInput = maxinput;
        this.tier = 1;
    }

    public TileEntityElecMachine(int slots, int fuelslot, int maxenergy, int maxinput, int tier) {
        super(slots);
        this.fuelslot = fuelslot;
        this.maxEnergy = maxenergy;
        this.maxInput = maxinput;
        this.tier = tier;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74762_e("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("energy", this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public boolean provideEnergy() {
        boolean ret = false;
        if (this.inventory[this.fuelslot] == null) {
            return false;
        }
        Item id = this.inventory[this.fuelslot].func_77973_b();
        if (id instanceof IElectricItem) {
            if (!((IElectricItem)id).canProvideEnergy()) {
                return false;
            }
            int transfer = ElectricItem.discharge(this.inventory[this.fuelslot], this.maxEnergy - this.energy, this.tier, false, false);
            this.energy += transfer;
            return ret || transfer > 0;
        }
        if (id == Items.field_151137_ax) {
            this.energy += this.maxEnergy;
            --this.inventory[this.fuelslot].field_77994_a;
            if (this.inventory[this.fuelslot].field_77994_a <= 0) {
                this.inventory[this.fuelslot] = null;
            }
            return true;
        }
        if (id == Ic2Items.suBattery) {
            this.energy += 1000;
            --this.inventory[this.fuelslot].field_77994_a;
            if (this.inventory[this.fuelslot].field_77994_a <= 0) {
                this.inventory[this.fuelslot] = null;
            }
            return true;
        }
        return ret;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public int demandsEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public boolean injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            IC2.explodeMachineAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (this.energy >= this.maxEnergy) {
            return false;
        }
        this.energy += amount;
        return true;
    }

    @Override
    public int getMaxSafeInput() {
        return this.maxInput;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    public boolean isRedstonePowered() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

