/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.machine.tileentity;

import ic2classic.core.ContainerIC2;
import ic2classic.core.IHasGui;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.machine.ContainerElectrolyzer;
import ic2classic.core.block.machine.tileentity.TileEntityMachine;
import ic2classic.core.block.wiring.TileEntityElectricBlock;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityElectrolyzer
extends TileEntityMachine
implements IHasGui {
    public static Random randomizer = new Random();
    public short energy = 0;
    public TileEntityElectricBlock mfe = null;
    public int ticker = randomizer.nextInt(16);

    public TileEntityElectrolyzer() {
        super(2);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", this.energy);
    }

    @Override
    public String func_145825_b() {
        return "Electrolyzer";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        boolean turnActive = false;
        if (this.ticker++ % 16 == 0) {
            this.mfe = this.lookForMFE();
        }
        if (this.mfe == null) {
            return;
        }
        if (this.shouldDrain() && this.canDrain()) {
            needsInvUpdate = this.drain();
            turnActive = true;
        }
        if (this.shouldPower() && (this.canPower() || this.energy > 0)) {
            needsInvUpdate = this.power();
            turnActive = true;
        }
        if (this.getActive() != turnActive) {
            this.setActive(turnActive);
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    public boolean shouldDrain() {
        return this.mfe != null && (double)((float)this.mfe.energy / (float)this.mfe.maxStorage) >= 0.7;
    }

    public boolean shouldPower() {
        return this.mfe != null && (double)((float)this.mfe.energy / (float)this.mfe.maxStorage) <= 0.3;
    }

    public boolean canDrain() {
        return this.inventory[0] != null && this.inventory[0].func_77973_b() == Ic2Items.waterCell && (this.inventory[1] == null || this.inventory[1].func_77973_b() == Ic2Items.electrolyzedWaterCell && this.inventory[1].field_77994_a < this.inventory[1].func_77976_d());
    }

    public boolean canPower() {
        return (this.inventory[0] == null || this.inventory[0].func_77973_b() == Ic2Items.waterCell && this.inventory[0].field_77994_a < this.inventory[0].func_77976_d()) && this.inventory[1] != null && this.inventory[1].func_77973_b() == Ic2Items.electrolyzedWaterCell;
    }

    public boolean drain() {
        this.mfe.energy -= this.processRate();
        this.energy = (short)(this.energy + this.processRate());
        if (this.energy >= 20000) {
            this.energy = (short)(this.energy - 20000);
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
            if (this.inventory[1] == null) {
                this.inventory[1] = new ItemStack(Ic2Items.electrolyzedWaterCell);
            } else {
                ++this.inventory[1].field_77994_a;
            }
            return true;
        }
        return false;
    }

    public boolean power() {
        if (this.energy > 0) {
            int out = this.processRate();
            if (out > this.energy) {
                out = this.energy;
            }
            this.energy = (short)(this.energy - out);
            this.mfe.energy += out;
            return false;
        }
        this.energy = (short)(this.energy + (12000 + 2000 * this.mfe.tier));
        --this.inventory[1].field_77994_a;
        if (this.inventory[1].field_77994_a <= 0) {
            this.inventory[1] = null;
        }
        if (this.inventory[0] == null) {
            this.inventory[0] = new ItemStack(Ic2Items.waterCell);
        } else {
            ++this.inventory[0].field_77994_a;
        }
        return true;
    }

    public int processRate() {
        switch (this.mfe.tier) {
            default: {
                return 2;
            }
            case 2: {
                return 8;
            }
            case 3: 
        }
        return 32;
    }

    public TileEntityElectricBlock lookForMFE() {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityElectricBlock) {
            return (TileEntityElectricBlock)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityElectricBlock) {
            return (TileEntityElectricBlock)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityElectricBlock) {
            return (TileEntityElectricBlock)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityElectricBlock) {
            return (TileEntityElectricBlock)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityElectricBlock) {
            return (TileEntityElectricBlock)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityElectricBlock) {
            return (TileEntityElectricBlock)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        }
        return null;
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / 20000;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectrolyzer(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiElectrolyzer";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int[] func_94128_d(int var1) {
        return new int[]{var1 == 0 ? 1 : 0};
    }
}

