/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.personal;

import cpw.mods.fml.common.eventhandler.Event;
import ic2classic.api.Direction;
import ic2classic.api.energy.event.EnergyTileLoadEvent;
import ic2classic.api.energy.event.EnergyTileSourceEvent;
import ic2classic.api.energy.event.EnergyTileUnloadEvent;
import ic2classic.api.energy.tile.IEnergySink;
import ic2classic.api.energy.tile.IEnergySource;
import ic2classic.api.network.INetworkClientTileEntityEventListener;
import ic2classic.core.ContainerIC2;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.machine.tileentity.TileEntityMachine;
import ic2classic.core.block.personal.ContainerEnergyOMatClosed;
import ic2classic.core.block.personal.ContainerEnergyOMatOpen;
import ic2classic.core.block.personal.IPersonalBlock;
import ic2classic.core.block.personal.TileEntityPersonalChest;
import ic2classic.core.util.StackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityEnergyOMat
extends TileEntityMachine
implements IPersonalBlock,
IHasGui,
ISidedInventory,
IEnergySink,
IEnergySource,
INetworkClientTileEntityEventListener {
    private static final Direction[] directions = Direction.values();
    public int euOffer = 1000;
    public String owner = "null";
    private boolean addedToEnergyNet = false;
    public int paidFor;
    public int euBuffer;
    private int euBufferMax = 10000;
    private int maxOutputRate = 32;

    public TileEntityEnergyOMat() {
        super(3);
    }

    @Override
    public String func_145825_b() {
        return "Energy-O-Mat";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.owner = nbttagcompound.func_74779_i("owner");
        this.euOffer = nbttagcompound.func_74762_e("euOffer");
        this.paidFor = nbttagcompound.func_74762_e("paidFor");
        this.euBuffer = nbttagcompound.func_74762_e("euBuffer");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74778_a("owner", this.owner);
        nbttagcompound.func_74768_a("euOffer", this.euOffer);
        nbttagcompound.func_74768_a("paidFor", this.paidFor);
        nbttagcompound.func_74768_a("euBuffer", this.euBuffer);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return this.canAccess(entityPlayer);
    }

    @Override
    public boolean canAccess(EntityPlayer player) {
        if (this.owner.equals("null")) {
            this.owner = player.func_146103_bH().getId();
            return true;
        }
        return this.owner.equalsIgnoreCase(player.func_146103_bH().getId());
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (IC2.platform.isSimulating()) {
            this.euBufferMax = 10000;
            this.maxOutputRate = 32;
            if (this.inventory[2] != null) {
                if (this.inventory[2].func_77969_a(Ic2Items.energyStorageUpgrade)) {
                    this.euBufferMax = 10000 * (this.inventory[2].field_77994_a + 1);
                } else if (this.inventory[2].func_77969_a(Ic2Items.transformerUpgrade)) {
                    this.maxOutputRate = 32 * (int)Math.pow(4.0, Math.min(4, this.inventory[2].field_77994_a));
                }
            }
            if (this.inventory[1] != null && this.inventory[0] != null && this.inventory[1].func_77969_a(this.inventory[0])) {
                int originalStackSize = this.inventory[1].field_77994_a;
                Direction[] directionArray = directions;
                int n = directions.length;
                int n2 = 0;
                while (n2 < n) {
                    Direction direction = directionArray[n2];
                    TileEntity target = direction.applyToTileEntity(this);
                    if (target instanceof IInventory && (!(target instanceof TileEntityPersonalChest) || ((TileEntityPersonalChest)target).owner.equals(this.owner))) {
                        IInventory targetInventory = (IInventory)target;
                        if (target instanceof TileEntityChest) {
                            targetInventory = Blocks.field_150486_ae.func_149951_m(target.func_145831_w(), target.field_145851_c, target.field_145848_d, target.field_145849_e);
                        }
                        if (StackUtil.putInInventory(targetInventory, this.inventory[1])) break;
                    }
                    ++n2;
                }
                int numPaymentMoved = originalStackSize - this.inventory[1].field_77994_a;
                if (numPaymentMoved > 0) {
                    this.paidFor += this.euOffer / this.inventory[0].field_77994_a * numPaymentMoved;
                    if (this.inventory[1].field_77994_a == 0) {
                        this.inventory[1] = null;
                    }
                    this.func_70296_d();
                }
            }
            if (this.euBuffer > this.euBufferMax) {
                this.euBuffer = this.euBufferMax;
            }
            int min = Math.min(this.maxOutputRate, this.euBuffer);
            EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, min);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.euBuffer -= min - event.amount;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side && this.canAccess(entityPlayer);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(Direction direction) {
        return direction.toSideValue() == this.getFacing();
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return !this.facingMatchesDirection(direction);
    }

    @Override
    public int getMaxEnergyOutput() {
        return 32;
    }

    @Override
    public int demandsEnergy() {
        return Math.min(this.paidFor, this.euBufferMax - this.euBuffer);
    }

    @Override
    public boolean injectEnergy(Direction directionFrom, int amount) {
        if (this.euBufferMax >= this.euBuffer) {
            return false;
        }
        if (this.paidFor <= 0) {
            return false;
        }
        this.paidFor -= amount;
        this.euBuffer += amount;
        return true;
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        if (this.canAccess(entityPlayer)) {
            return new ContainerEnergyOMatOpen(entityPlayer, this);
        }
        return new ContainerEnergyOMatClosed(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        if (this.canAccess(entityPlayer)) {
            return "block.personal.GuiEnergyOMatOpen";
        }
        return "block.personal.GuiEnergyOMatClosed";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void writeDescriptionNBT(NBTTagCompound tag) {
        super.writeDescriptionNBT(tag);
        tag.func_74778_a("owner", this.owner);
    }

    @Override
    public void readDescriptionNBT(NBTTagCompound tag) {
        super.readDescriptionNBT(tag);
        this.owner = tag.func_74779_i("owner");
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (!this.canAccess(player)) {
            return;
        }
        switch (event) {
            case 0: {
                this.attemptSet(-1000);
                break;
            }
            case 1: {
                this.attemptSet(-100);
                break;
            }
            case 2: {
                this.attemptSet(1000);
                break;
            }
            case 3: {
                this.attemptSet(100);
            }
        }
    }

    private void attemptSet(int amount) {
        if (this.euOffer + amount <= 0) {
            amount = 0;
        }
        this.euOffer += amount;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{1};
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }
}

