/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.wiring;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.api.IElectricItem;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Icons;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.BlockContainerCommon;
import ic2classic.core.block.BlockPoleFence;
import ic2classic.core.block.wiring.BlockCable;
import ic2classic.core.block.wiring.TileEntityLuminator;
import ic2classic.core.item.ElectricItem;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLuminator
extends BlockContainerCommon {
    boolean light;

    public BlockLuminator(boolean l) {
        super(Material.field_151592_s);
        this.func_149672_a(Block.field_149778_k);
        this.light = l;
        this.func_149711_c(0.3f);
        this.func_149752_b(0.5f);
        if (!this.light) {
            this.func_149647_a(IC2.tabIC2);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return Ic2Icons.b0_31;
    }

    public int func_149660_a(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        return par5;
    }

    public boolean func_149707_d(World world, int i, int j, int k, int direction) {
        if (!world.func_147439_a(i, j, k).isReplaceable((IBlockAccess)world, i, j, k)) {
            return false;
        }
        switch (direction) {
            case 0: {
                ++j;
                break;
            }
            case 1: {
                --j;
                break;
            }
            case 2: {
                ++k;
                break;
            }
            case 3: {
                --k;
                break;
            }
            case 4: {
                ++i;
                break;
            }
            case 5: {
                --i;
            }
        }
        return BlockLuminator.isSupportingBlock(world, i, j, k);
    }

    public static boolean isSupportingBlock(World world, int i, int j, int k) {
        if (world.func_147439_a(i, j, k).func_149662_c()) {
            return true;
        }
        return BlockLuminator.isSpecialSupporter((IBlockAccess)world, i, j, k);
    }

    public static boolean isSpecialSupporter(IBlockAccess world, int i, int j, int k) {
        Block block = world.func_147439_a(i, j, k);
        if (block == null) {
            return false;
        }
        if (block instanceof BlockFence || block instanceof BlockPoleFence || block instanceof BlockCable) {
            return true;
        }
        return block == Block.func_149634_a((Item)Ic2Items.reinforcedGlass.func_77973_b()) || block == Blocks.field_150359_w;
    }

    public boolean func_149718_j(World world, int i, int j, int k) {
        TileEntity te = world.func_147438_o(i, j, k);
        if (te != null && ((TileEntityLuminator)te).ignoreBlockStay) {
            return true;
        }
        int facing = world.func_72805_g(i, j, k);
        switch (facing) {
            case 0: {
                ++j;
                break;
            }
            case 1: {
                --j;
                break;
            }
            case 2: {
                ++k;
                break;
            }
            case 3: {
                --k;
                break;
            }
            case 4: {
                ++i;
                break;
            }
            case 5: {
                --i;
            }
        }
        return BlockLuminator.isSupportingBlock(world, i, j, k);
    }

    public void func_149695_a(World world, int i, int j, int k, Block l) {
        if (!this.func_149718_j(world, i, j, k)) {
            world.func_147468_f(i, j, k);
        }
        super.func_149695_a(world, i, j, k, l);
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return IC2.platform.getRenderId("luminator");
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        float[] box = BlockLuminator.getBoxOfLuminator((IBlockAccess)world, i, j, k);
        return AxisAlignedBB.func_72330_a((double)(box[0] + (float)i), (double)(box[1] + (float)j), (double)(box[2] + (float)k), (double)(box[3] + (float)i), (double)(box[4] + (float)j), (double)(box[5] + (float)k));
    }

    public AxisAlignedBB func_149633_g(World world, int i, int j, int k) {
        float[] box = BlockLuminator.getBoxOfLuminator((IBlockAccess)world, i, j, k);
        return AxisAlignedBB.func_72330_a((double)(box[0] + (float)i), (double)(box[1] + (float)j), (double)(box[2] + (float)k), (double)(box[3] + (float)i), (double)(box[4] + (float)j), (double)(box[5] + (float)k));
    }

    public static float[] getBoxOfLuminator(IBlockAccess world, int i, int j, int k) {
        int facing = world.func_72805_g(i, j, k);
        float px = 0.0625f;
        switch (facing) {
            case 0: {
                ++j;
                break;
            }
            case 1: {
                --j;
                break;
            }
            case 2: {
                ++k;
                break;
            }
            case 3: {
                --k;
                break;
            }
            case 4: {
                ++i;
                break;
            }
            case 5: {
                --i;
            }
        }
        boolean fullCover = BlockLuminator.isSpecialSupporter(world, i, j, k);
        switch (facing) {
            case 1: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f * px, 1.0f};
            }
            case 2: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f, 15.0f * px, 1.0f, 1.0f, 1.0f};
                }
                return new float[]{6.0f * px, 3.0f * px, 14.0f * px, 1.0f - 6.0f * px, 1.0f - 3.0f * px, 1.0f};
            }
            case 3: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f * px};
                }
                return new float[]{6.0f * px, 3.0f * px, 0.0f, 1.0f - 6.0f * px, 1.0f - 3.0f * px, 2.0f * px};
            }
            case 4: {
                if (fullCover) {
                    return new float[]{15.0f * px, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
                }
                return new float[]{14.0f * px, 3.0f * px, 6.0f * px, 1.0f, 1.0f - 3.0f * px, 1.0f - 6.0f * px};
            }
            case 5: {
                if (fullCover) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f * px, 1.0f, 1.0f};
                }
                return new float[]{0.0f, 3.0f * px, 6.0f * px, 2.0f * px, 1.0f - 3.0f * px, 1.0f - 6.0f * px};
            }
        }
        if (fullCover) {
            return new float[]{0.0f, 15.0f * px, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        return new float[]{4.0f * px, 13.0f * px, 4.0f * px, 1.0f - 4.0f * px, 1.0f, 1.0f - 4.0f * px};
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        ItemStack itemStack = entityplayer.func_71045_bC();
        if (itemStack == null || !(itemStack.func_77973_b() instanceof IElectricItem)) {
            return false;
        }
        itemStack.func_77973_b();
        TileEntityLuminator lumi = (TileEntityLuminator)world.func_147438_o(i, j, k);
        int transfer = lumi.getMaxEnergy() - lumi.energy;
        if (transfer <= 0) {
            return false;
        }
        transfer = ElectricItem.discharge(itemStack, transfer, 2, true, false);
        if (!this.light) {
            world.func_147465_d(i, j, k, Block.func_149634_a((Item)Ic2Items.activeLuminator.func_77973_b()), world.func_72805_g(i, j, k), 3);
            lumi = (TileEntityLuminator)world.func_147438_o(i, j, k);
        }
        lumi.energy += transfer;
        return true;
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        if (this.light && entity instanceof EntityMob) {
            entity.func_70015_d(entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == EnumCreatureAttribute.UNDEAD ? 20 : 10);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityLuminator();
    }

    public String getTextureFile() {
        return "/ic2classic/sprites/block_0.png";
    }

    public void func_149666_a(Item i, CreativeTabs tabs, List itemList) {
        if (!this.light) {
            super.func_149666_a(i, tabs, itemList);
        }
    }
}

