/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item;

import ic2classic.api.IElectricItem;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Icons;
import ic2classic.core.Ic2Items;
import ic2classic.core.item.ElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBattery
extends ElectricItem {
    public ItemBattery(int sprite, int maxCharge, int transferLimit, int tier) {
        super(sprite);
        this.setNoRepair();
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
    }

    @Override
    public boolean canProvideEnergy() {
        return true;
    }

    @Override
    public Item getEmptyItemId() {
        if (this == Ic2Items.chargedReBattery) {
            return Ic2Items.reBattery;
        }
        return super.getEmptyItemId();
    }

    @Override
    public IIcon func_77617_a(int i) {
        if (i <= 1) {
            return Ic2Icons.i0[this.iconIndex + 4];
        }
        if (i <= 8) {
            return Ic2Icons.i0[this.iconIndex + 3];
        }
        if (i <= 14) {
            return Ic2Icons.i0[this.iconIndex + 2];
        }
        if (i <= 20) {
            return Ic2Icons.i0[this.iconIndex + 1];
        }
        return Ic2Icons.i0[this.iconIndex];
    }

    public IIcon getIconFromChargeLevel(float chargeLevel) {
        return this.func_77617_a(1 + (int)Math.round((1.0 - (double)chargeLevel) * (double)(this.func_77612_l() - 2)));
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityplayer) {
        if (IC2.platform.isSimulating() && itemStack.func_77973_b() == Ic2Items.chargedReBattery) {
            boolean transferred = false;
            int i = 0;
            while (i < 9) {
                ItemStack stack = entityplayer.field_71071_by.field_70462_a[i];
                if (stack != null && stack.func_77973_b() instanceof IElectricItem && stack != itemStack) {
                    IElectricItem item = (IElectricItem)stack.func_77973_b();
                    int transfer = ItemBattery.discharge(itemStack, 2 * this.transferLimit, item.getTier(), true, true);
                    transfer = ItemBattery.charge(stack, transfer, this.tier, true, false);
                    ItemBattery.discharge(itemStack, transfer, item.getTier(), true, false);
                    if (transfer == 0) break;
                    transferred = true;
                }
                ++i;
            }
            if (transferred && !IC2.platform.isRendering()) {
                entityplayer.field_71070_bA.func_75142_b();
            }
        }
        return itemStack;
    }
}

