/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.armor;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2classic.core.IC2;
import ic2classic.core.IC2DamageSource;
import ic2classic.core.IItemTickListener;
import ic2classic.core.Ic2Items;
import ic2classic.core.item.armor.ItemArmorUtility;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorHazmat
extends ItemArmorUtility
implements IItemTickListener {
    public ItemArmorHazmat(int spriteIndex, int renderIndex, int type) {
        super(spriteIndex, renderIndex, type);
        this.func_77656_e(64);
        this.func_77637_a(IC2.tabIC2);
        if (this.field_77881_a == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "ic2classic:hazmat";
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (this.field_77881_a == 0 && this.hazmatAbsorbs(source) && ItemArmorHazmat.hasCompleteHazmat(player)) {
            if (source == DamageSource.field_76372_a || source == DamageSource.field_76371_c) {
                player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 60, 1));
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, Integer.MAX_VALUE);
        }
        if (this.field_77881_a == 3 && source == DamageSource.field_76379_h) {
            return new ISpecialArmor.ArmorProperties(10, damage < 8.0 ? 1.0 : 0.875, (armor.func_77958_k() - armor.func_77960_j() + 1) * 2 * 25);
        }
        return new ISpecialArmor.ArmorProperties(0, 1.0, (armor.func_77958_k() - armor.func_77960_j() + 1) / 2 * 25);
    }

    @Override
    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (this.hazmatAbsorbs(source) && ItemArmorHazmat.hasCompleteHazmat(entity)) {
            return;
        }
        int damageTotal = damage * 2;
        if (this.field_77881_a == 3 && source == DamageSource.field_76379_h) {
            damageTotal = (damage + 1) / 2;
        }
        stack.func_77972_a(damageTotal, entity);
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (IC2.platform.isSimulating() && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ItemStack armor = player.field_71071_by.field_70460_b[0];
            if (armor != null && armor.func_77973_b() == this) {
                int fallDamage = (int)event.distance - 3;
                if (fallDamage >= 8) {
                    return;
                }
                int armorDamage = (fallDamage + 1) / 2;
                if (armorDamage <= armor.func_77958_k() - armor.func_77960_j() && armorDamage >= 0) {
                    armor.func_77972_a(armorDamage, (EntityLivingBase)player);
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public boolean isRepairable() {
        return true;
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 1;
    }

    @Override
    public boolean onTick(EntityPlayer player, ItemStack itemStack) {
        if (this.field_77881_a == 0) {
            if (player.func_70027_ad() && ItemArmorHazmat.hasCompleteHazmat((EntityLivingBase)player)) {
                if (this.isInLava(player)) {
                    player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 20, 0, true));
                }
                player.func_70066_B();
            }
            if (player.func_70086_ai() <= 100 && player.field_71071_by.func_146028_b(Ic2Items.airCell)) {
                player.field_71071_by.func_146026_a(Ic2Items.airCell);
                player.field_71071_by.func_70441_a(new ItemStack(Ic2Items.cell));
                player.func_70050_g(player.func_70086_ai() + 150);
                return true;
            }
        }
        return false;
    }

    public boolean isInLava(EntityPlayer player) {
        int var6;
        int var5;
        double var2 = player.field_70163_u + 0.02;
        int var4 = MathHelper.func_76128_c((double)player.field_70165_t);
        Block var7 = player.field_70170_p.func_147439_a(var4, var5 = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)var2)), var6 = MathHelper.func_76128_c((double)player.field_70161_v));
        if (var7.func_149688_o() == Material.field_151587_i || var7.func_149688_o() == Material.field_151581_o) {
            float var8 = BlockLiquid.func_149801_b((int)player.field_70170_p.func_72805_g(var4, var5, var6)) - 0.1111111f;
            float var9 = (float)(var5 + 1) - var8;
            return var2 < (double)var9;
        }
        return false;
    }

    public static boolean hasCompleteHazmat(EntityLivingBase living) {
        if (!(living instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)living;
        ItemStack[] armor = player.field_71071_by.field_70460_b;
        return armor[0] != null && armor[0].func_77973_b() instanceof ItemArmorHazmat && armor[1] != null && armor[1].func_77973_b() instanceof ItemArmorHazmat && armor[2] != null && armor[2].func_77973_b() instanceof ItemArmorHazmat && armor[3] != null && armor[3].func_77973_b() instanceof ItemArmorHazmat;
    }

    public boolean hazmatAbsorbs(DamageSource source) {
        return source == DamageSource.field_76372_a || source == DamageSource.field_76368_d || source == DamageSource.field_76371_c || source == DamageSource.field_76370_b || source == IC2DamageSource.electricity || source == IC2DamageSource.radiation;
    }
}

