/*
 * Decompiled with CFR 0.152.
 */
package makmods.customuumvalues;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.Configuration;

@Mod(modid="CustomUUMValues", name="Custom UUM Values", version="v1.2", dependencies="required-after:IC2@[2.0,)")
public class CustomUUMValues {
    @Mod.Instance(value="CustomUUMValues")
    public static CustomUUMValues instance;
    public static Configuration config;
    public static Logger logger;
    public static String CONFIG_CATEGORY;
    public static final String AMOUNT_EU = "recordedAmountEU";
    public static final String AMOUNT_UU = "recordedAmountUU";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        logger = event.getModLog();
        logger.log(Level.INFO, "Pre-Initialization...");
        config.load();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.log(Level.INFO, "Initialization...");
    }

    public void clearScannerRecipes() {
        Recipes.Scanner.getRecipes().clear();
    }

    public static void addScannerRecipe(ItemStack output, int recordedAmountUU, int recordedAmountEU) {
        if (output == null) {
            return;
        }
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a(AMOUNT_UU, recordedAmountUU);
        metadata.func_74768_a(AMOUNT_EU, recordedAmountEU);
        Recipes.Scanner.addRecipe((IRecipeInput)new RecipeInputItemStack(output), metadata, new ItemStack[0]);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.log(Level.INFO, "Post-Initialization...");
        if (!Loader.isModLoaded((String)"IC2")) {
            throw new RuntimeException("IC2 isn't installed.");
        }
        HashMap immutableScannerCopy = Maps.newHashMap();
        immutableScannerCopy.putAll(Recipes.Scanner.getRecipes());
        logger.info("Clearing old scanner recipes...");
        this.clearScannerRecipes();
        for (Map.Entry r : immutableScannerCopy.entrySet()) {
            try {
                if (((IRecipeInput)r.getKey()).getInputs().size() != 1) {
                    logger.log(Level.SEVERE, "Recipe is invalid, continuing...");
                    continue;
                }
                ItemStack output = (ItemStack)((IRecipeInput)r.getKey()).getInputs().get(0);
                if (output == null) {
                    logger.log(Level.SEVERE, "Recipe is invalid, continuing...");
                    continue;
                }
                NBTTagCompound alreadyExisted = ((RecipeOutput)r.getValue()).metadata;
                int alreadyExistedEU = alreadyExisted.func_74762_e(AMOUNT_EU);
                int alreadyExistedUU = alreadyExisted.func_74762_e(AMOUNT_UU);
                String name = output.func_77977_a().replace("item.", "").replace("tile.", "").replace(".name", "");
                int eu = config.get(CONFIG_CATEGORY, name + "Eu", alreadyExistedEU).getInt();
                int uu = config.get(CONFIG_CATEGORY, name + "Uu", alreadyExistedUU).getInt();
                if (eu <= 0 || uu <= 0) continue;
                logger.info(String.format("Re-adding scanner recipe for %s, EU: %d, UU: %d", name, eu, uu));
                CustomUUMValues.addScannerRecipe(output.func_77946_l(), uu, eu);
            }
            catch (Throwable t) {
                logger.severe("Exception occured! Whoops!");
                t.printStackTrace();
            }
        }
        config.save();
    }

    static {
        CONFIG_CATEGORY = "uumvalues";
    }
}

