/*
 * Decompiled with CFR 0.152.
 */
package advsolar.utils;

import advsolar.common.AdvancedSolarPanel;
import advsolar.utils.MTRecipeManager;
import advsolar.utils.MTRecipeRecord;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MTRecipeConfig {
    public static final String SEPARATOR = "; ";
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static List<String> defaultLines = Lists.newArrayList();
    public static boolean filled = false;
    public static String configVersion = "1.0";

    public static void populateDefaults() {
        if (!filled) {
            defaultLines.add("minecraft:skull-1:1; minecraft:nether_star:1; 250000000");
            defaultLines.add("minecraft:iron_ingot:1; IC2:itemOreIridium:1; 9000000");
            defaultLines.add("minecraft:netherrack:1; minecraft:gunpowder:2; 70000");
            defaultLines.add("minecraft:sand:1; minecraft:gravel:1; 50000");
            defaultLines.add("minecraft:dirt:1; minecraft:clay:1; 50000");
            defaultLines.add("minecraft:coal-1:1; minecraft:coal-0:1; 60000");
            defaultLines.add("minecraft:glowstone_dust:1; AdvancedSolarPanel:asp_crafting_items-9:1; 1000000");
            defaultLines.add("minecraft:glowstone:1; AdvancedSolarPanel:asp_crafting_items-0:1; 9000000");
            defaultLines.add("minecraft:wool-4:1; minecraft:glowstone:1; 500000");
            defaultLines.add("minecraft:wool-11:1; minecraft:lapis_block:1; 500000");
            defaultLines.add("minecraft:wool-14:1; minecraft:redstone_block:1; 500000");
            defaultLines.add("minecraft:dye-4:1; oredict:gemSapphire; 5000000");
            defaultLines.add("minecraft:redstone:1; oredict:gemRuby:1; 5000000");
            defaultLines.add("minecraft:coal:1; IC2:itemPartIndustrialDiamond:1; 9000000");
            defaultLines.add("IC2:itemPartIndustrialDiamond:1; minecraft:diamond:1; 1000000");
            defaultLines.add("oredict:dustTitanium:1; oredict:dustChrome:1; 500000");
            defaultLines.add("oredict:ingotTitanium:1; oredict:ingotChrome:1; 500000");
            defaultLines.add("oredict:gemNetherQuartz:1; oredict:gemCertusQuartz:1; 500000");
            defaultLines.add("oredict:ingotCopper:1; oredict:ingotNickel:1; 300000");
            defaultLines.add("oredict:ingotTin:1; oredict:ingotSilver:1; 500000");
            defaultLines.add("oredict:ingotSilver:1; oredict:ingotGold:1; 500000");
            defaultLines.add("oredict:ingotGold:1; oredict:ingotPlatinum:1; 9000000");
            filled = true;
        }
    }

    public static String formatItemData(MTRecipeManager.RawItemData rawItemData) {
        return String.format("%s:%s", rawItemData.modId, rawItemData.itemName);
    }

    public static void addDefaultRecipe(Object input, int inputStackSize, Object output, int outputStackSize, int energy) {
        String result = "";
        result = result + "# ";
        result = result + (input instanceof ItemStack ? ((ItemStack)input).func_82833_r() : (String)input);
        result = result + " -> ";
        result = result + (output instanceof ItemStack ? ((ItemStack)output).func_82833_r() : (String)output);
        result = result + String.format(" [%d EU]", energy);
        defaultLines.add(result);
        result = "";
        if (input instanceof String) {
            result = result + "oredict:" + (String)input + SEPARATOR;
        } else if (input instanceof ItemStack) {
            result = result + MTRecipeConfig.formatItemData(MTRecipeManager.getItemData((ItemStack)input)) + "-" + ((ItemStack)input).func_77960_j() + ":" + ((ItemStack)input).field_77994_a + SEPARATOR;
        } else {
            throw new RuntimeException("addDefaultRecipe(): input unsupported type: " + input.getClass().getCanonicalName());
        }
        if (output instanceof String) {
            result = result + "oredict:" + (String)output + SEPARATOR;
        } else if (output instanceof ItemStack) {
            result = result + MTRecipeConfig.formatItemData(MTRecipeManager.getItemData((ItemStack)output)) + "-" + ((ItemStack)output).func_77960_j() + ":" + ((ItemStack)output).field_77994_a + SEPARATOR;
        } else {
            throw new RuntimeException("addDefaultRecipe(): output unsupported type: " + output.getClass().getCanonicalName());
        }
        result = result + energy;
        defaultLines.add(result);
    }

    public static void doDebug() {
    }

    public static void writeGuide(BufferedWriter bw) {
        try {
            bw.write("##################################################################################################" + NEW_LINE);
            bw.write("#                        AdvancedSolarPanels Molecular Transformer Recipes                       #" + NEW_LINE);
            bw.write("##################################################################################################" + NEW_LINE);
            bw.write("# Format of recipe: \"inputItem:stackSize;outputItem:outputStackSize;energy\"                      #" + NEW_LINE);
            bw.write("# InputItem (outputItem) format:                                                                 #" + NEW_LINE);
            bw.write("# \"oredict:forgeOreDictName\" or \"minecraft:item_name-meta\" or \"modID:item_name-meta\"             #" + NEW_LINE);
            bw.write("# New line = new recipe.                                                                         #" + NEW_LINE);
            bw.write("# Add \"#\" before line to skip parsing recipe                                                     #" + NEW_LINE);
            bw.write("##################################################################################################" + NEW_LINE);
            bw.write("version=" + configVersion + NEW_LINE);
            bw.write("##################################################################################################" + NEW_LINE);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void fillWithInitials(BufferedWriter bw) {
        MTRecipeConfig.populateDefaults();
        MTRecipeConfig.writeGuide(bw);
        System.out.println(defaultLines.size());
        for (String s : defaultLines) {
            try {
                bw.append(s + "\r\n");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static List<MTRecipeRecord> parse(File f) {
        ArrayList list = Lists.newArrayList();
        try {
            if (!f.exists()) {
                AdvancedSolarPanel.addLog("MT recipes config file not found. Create default recipes.");
                f.createNewFile();
                FileOutputStream fos = new FileOutputStream(f);
                OutputStreamWriter osw = new OutputStreamWriter(fos);
                BufferedWriter bw = new BufferedWriter(osw);
                MTRecipeConfig.fillWithInitials(bw);
                bw.close();
                fos.close();
            }
            AdvancedSolarPanel.addLog("* * * * * * Start parsing MT recipes * * * * * * ");
            FileInputStream fis = new FileInputStream(f);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String line = "";
            int lineNumber = 0;
            while ((line = br.readLine()) != null) {
                String[] spaceSplit;
                ++lineNumber;
                if ((line = line.replace("\r", "").replace("\n", "")).trim().startsWith("#")) continue;
                if (line.indexOf("#") != 0 && line.indexOf("version") != 0) {
                    if (line.indexOf("#") > 0) {
                        line = line.substring(0, line.indexOf("#"));
                        line = line.trim();
                    }
                } else if (line.indexOf("version") == 0) {
                    String tmpString;
                    if (line.indexOf("#") > 0) {
                        line = line.substring(0, line.indexOf("#"));
                        line = line.trim();
                    }
                    if ((tmpString = line.substring(line.indexOf("=") + 1)) == "") continue;
                    configVersion = tmpString;
                    continue;
                }
                if ((spaceSplit = line.trim().split(SEPARATOR.trim())).length != 3) {
                    AdvancedSolarPanel.addLog(String.format("Ignoring line %d, incorrect format.", lineNumber));
                    continue;
                }
                String input = spaceSplit[0].trim();
                String output = spaceSplit[1].trim();
                int energy = -1;
                try {
                    energy = Integer.parseInt(spaceSplit[2].trim());
                }
                catch (Exception e) {
                    AdvancedSolarPanel.addLog(String.format("Ignoring line %d, energy number is incorrect.", lineNumber));
                    continue;
                }
                List<ItemStack> inputStacks = MTRecipeConfig.wrap(input);
                if (inputStacks == null) {
                    AdvancedSolarPanel.addLog(String.format("Ignoring line %d, failed to parse input.", lineNumber));
                    continue;
                }
                List<ItemStack> outputStacks = MTRecipeConfig.wrap(output);
                if (outputStacks == null) {
                    AdvancedSolarPanel.addLog(String.format("Ignoring line %d, failed to parse output.", lineNumber));
                    continue;
                }
                ItemStack outputStack = outputStacks.get(0);
                for (ItemStack is : inputStacks) {
                    MTRecipeRecord recipeToAdd = new MTRecipeRecord();
                    recipeToAdd.inputStack = is.func_77946_l();
                    recipeToAdd.outputStack = outputStack.func_77946_l();
                    recipeToAdd.energyPerOperation = energy;
                    list.add(recipeToAdd);
                }
            }
            br.close();
            fis.close();
            AdvancedSolarPanel.addLog("* * * * * * Finished parsing MT recipes * * * * * * ");
            AdvancedSolarPanel.addLog(String.format("Config loading completed, %d recipes parsed.", list.size()));
            AdvancedSolarPanel.addLog("* * * * * * Loaded recipes list * * * * * * ");
            for (MTRecipeRecord record : list) {
                ItemStack input = record.inputStack;
                ItemStack output = record.outputStack;
                int energy = record.energyPerOperation;
                String result = "";
                result = result + (input instanceof ItemStack ? input.func_82833_r() : (String)input);
                result = result + " -> ";
                result = result + (output instanceof ItemStack ? output.func_82833_r() : (String)output);
                result = result + String.format(" [%d EU]", energy);
                AdvancedSolarPanel.addLog(result);
            }
            AdvancedSolarPanel.addLog("* * * * * * * * * * * * * * * * * * * * *");
        }
        catch (Throwable t) {
            AdvancedSolarPanel.addLog("Fatal error occurred parsing MT recipes config. (" + t.toString() + ")");
        }
        return list;
    }

    public static List<ItemStack> wrap(String s) {
        ArrayList list = Lists.newArrayList();
        String[] split = s.split(":");
        String namespace = split[0];
        int stackSize = 1;
        if (namespace.equalsIgnoreCase("oredict")) {
            if (split.length == 2 || split.length == 3) {
                ArrayList retrOreDict;
                if (split.length == 3) {
                    stackSize = Integer.parseInt(split[2]);
                }
                if ((retrOreDict = OreDictionary.getOres((String)split[1])).size() > 0) {
                    for (int i = 0; i < retrOreDict.size(); ++i) {
                        ItemStack tmpItemStack = ((ItemStack)retrOreDict.get(i)).func_77946_l();
                        list.add(new ItemStack(tmpItemStack.func_77973_b(), stackSize, tmpItemStack.func_77960_j()));
                    }
                }
            }
        } else if ((namespace.equalsIgnoreCase("minecraft") || Loader.isModLoaded((String)namespace)) && split.length == 3) {
            ItemStack is;
            String modId = split[0];
            String itemName = split[1];
            stackSize = Integer.parseInt(split[2]);
            if (stackSize <= 0) {
                stackSize = 1;
            }
            int meta = 0;
            String[] itemArray = null;
            if (itemName.indexOf("-") > 0) {
                itemArray = itemName.split("-");
                itemName = itemArray[0];
                meta = Integer.parseInt(itemArray[1]);
            }
            if ((is = GameRegistry.findItemStack((String)modId, (String)itemName, (int)1)) != null) {
                is.func_77964_b(meta);
                is.field_77994_a = stackSize;
                list.add(is);
            }
        }
        return list.size() != 0 ? list : null;
    }
}

