package fruitmods.api.armourhud;

// by including this interface in one of your items
// you can customise what Armour HUD writes to the screen
// -custom prefixes, postfixes, name and damage (text and colour)
// -disable the damage value or item count display

/**
 * Interface which can customise Armour HUD's display for any particular item.
 * You must return every field here, even those which you don't use
 * Suggested defaults are listed by each entry
 * 
 * The display order is: prefix, name, value, postfix
 * These labels are arbitrary - here's how I use them
 * For stacked items (eg. 42 dirt), I put Integer.toString(stack size) + "x" in the prefix field
 * Name gets ItemStack.getDisplayName() + "" (the empty string is important)
 * Value gets the item's remaining health or charge
 * Postfix isn't used often, but I use it to indicate the hover/active status of IC2 items.
 * 
 * Spaces are not included - you need to add them yourself to the fields.
 * Name and Value have some quirks with respect to colour customisation
 * Name is always white text - it can't be changed
 * Value only lets you change the hue, and only by an indirect method
 * (see the comments on value fraction later on)
 */

public interface IArmourHUDProperties
{
  
  public boolean ArmourHUD_isActive();
    /**
     * Determines whether Armour HUD should highlight this item in the graphical schematic.
     * Used to indicate whether an item is active or not (eg. Gravisuite chestplate).
     * In practice, this will rarely be seen because the graphical schematic sucks...
     * 
     * @return true or false (default: false)
     */


  public String ArmourHUD_prefixString();
    /**
     * The text to be displayed as the custom prefix.
     * 
     * @return Prefix text, my default = "" (empty string)
     */
  
  public float ArmourHUD_prefixHue();
    /**
     * The colour hue of the prefix text.
     * Legal values are between 0 and 360.
     * Sample values: 0 = red, 120 = green, 240 = blue, 360 = violet
     * 
     * @return Prefix text hue (default: 240.0F = blue)
     */
  
  public float ArmourHUD_prefixSaturation();
    /**
     * The colour saturation of the prefix text.
     * Legal values are between 0 and 1.
     * 0 is pure white (or black), 1 is fully saturated colour.
     * 
     * @return Prefix text saturation (default: 0.0F = white, regardless of hue)
     */
    
  
  public float ArmourHUD_prefixLuminosity();
    /**
     * The colour luminosity of the prefix text.
     * Legal values are between 0 and 1.
     * 0 is pure black (regardless of hue or saturation), 1 is full brightness colour.
     * 
     * @return Prefix text luminosity (default: 1.0F = full brightness)
     */
  
  
  
  // name data, names are always white text
  public String ArmourHUD_nameString();
    /**
     * The text to be displayed as the custom name.
     * 
     * @return Name text
     * I use: ItemStack.getDisplayName() + "" (the empty string helps prevent null issues)
     */
    
  
  
  // value data
  public String ArmourHUD_valueString();
    /**
     * The text to be displayed as the custom value.
     * 
     * @return Value text
     * see gearInfoContainer() in ArmourHUD_ticker.java for how I do it
     * there's a *lot* of edge case detection and explicit mod integration there
     */
    
  
  public float ArmourHUD_valueFraction();
    /**
     * The colour hue of the value text.
     * This one needs a little explanation. There's a setting in the config file
     * which provides the "base" hue - this is what full health items have.
     * 
     * When gear gets progressively more damaged, this hue is scaled down accordingly.
     * By default, it starts at blue (240) and gets scaled down through
     * cyan, green, yellow, orange, red and then finally black when it's dead.
     * 
     * This scaling is accomplished by using a fraction determined from the item's
     * health or charge level. That's what you're inputting here and it's only used
     * for the "value" of the items.
     * 
     * 
     * 
     * @return Value text hue scaling, return -1.0F for white.
     */
  
  
  
  // postfix data
  public String ArmourHUD_postfixString();
    /**
     * The text to be displayed as the custom postfix.
     * 
     * @return Postfix text, default = "" (empty string)
     */
  
  
  public float ArmourHUD_postfixHue();
    /**
     * The colour hue of the postfix text.
     * Legal values are between 0 and 360.
     * Sample values: 0 = red, 120 = green, 240 = blue, 360 = violet
     * 
     * @return Postfix text hue (default: 240.0F = blue)
     */
  
  
  public float ArmourHUD_postfixSaturation();
    /**
     * The colour saturation of the postfix text.
     * Legal values are between 0 and 1.
     * 0 is pure white (or black), 1 is fully saturated colour.
     * 
     * @return Prefix text saturation (default: 0.0F = white, regardless of hue)
     */
  
  
  public float ArmourHUD_postfixLuminosity();
    /**
     * The colour luminosity of the postfix text.
     * Legal values are between 0 and 1.
     * 0 is pure black (regardless of hue or saturation), 1 is full brightness colour.
     * 
     * @return Postfix text luminosity (default: 1.0F = full brightness)
     */
  
}
