package fruitmods.armourhud;

import fruitmods.api.armourhud.IArmourHUDProperties;

public class GearInfoContainer
{
  public String prefix;
  public String name;
  public String value;
  public String postfix;
  
  public float prefix_hue;
  public float prefix_saturation;
  public float prefix_luminosity;
  
  public float postfix_hue;
  public float postfix_saturation;
  public float postfix_luminosity;
  
  public float fraction;
  
  public boolean active;
  
  public GearInfoContainer()
  {
    this.prefix = "";
    this.name = "";
    this.value = "";
    this.postfix = "";
    
    this.prefix_hue = 240.0F;
    this.prefix_saturation = 0.0F;
    this.prefix_luminosity = 1.0F;
    
    this.postfix_hue = 240.0F;
    this.postfix_saturation = 0.0F;
    this.postfix_luminosity = 1.0F;
    
    this.fraction = 0.0F;
    
    this.active = false;
  }
  
  public GearInfoContainer(IArmourHUDProperties item)
  {
    this.prefix = item.ArmourHUD_prefixString();
    this.name = item.ArmourHUD_nameString();
    this.value = item.ArmourHUD_valueString();
    this.postfix = item.ArmourHUD_postfixString();
    
    this.prefix_hue = item.ArmourHUD_prefixHue();
    this.prefix_saturation = item.ArmourHUD_prefixSaturation();
    this.prefix_luminosity = item.ArmourHUD_prefixLuminosity();
    
    this.postfix_hue = item.ArmourHUD_postfixHue();
    this.postfix_saturation = item.ArmourHUD_postfixSaturation();
    this.postfix_luminosity = item.ArmourHUD_postfixLuminosity();
    
    this.fraction = item.ArmourHUD_valueFraction();
    
    this.active = item.ArmourHUD_isActive();
  }
  
}
