/*
 * Decompiled with CFR 0.152.
 */
package gravisuite;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.Helpers;
import gravisuite.ServerProxy;
import gravisuite.keyboard.Keyboard;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemGraviChestPlate
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor {
    public static int maxCharge;
    public static int minCharge;
    public static int transferLimit;
    public static int tier;
    public static int dischargeInFlight;
    public static int dischargeIdleMode;
    public static float boostSpeed;
    public static int boostMultiplier;
    private static double hoverModeFallSpeed;

    public ItemGraviChestPlate(ItemArmor.ArmorMaterial armorMaterial, int par3, int par4) {
        super(armorMaterial, par3, par4);
        maxCharge = 30000000;
        transferLimit = 60000;
        tier = 4;
        minCharge = 10000;
        dischargeInFlight = 278;
        dischargeIdleMode = 1;
        boostSpeed = 0.2f;
        boostMultiplier = 3;
        this.func_77637_a(GraviSuite.ic2Tab);
        this.func_77656_e(27);
    }

    public static int switchWorkMode(EntityPlayer player, ItemStack itemstack) {
        if (ItemGraviChestPlate.readWorkMode(itemstack)) {
            ItemGraviChestPlate.saveWorkMode(itemstack, false);
            ServerProxy.sendPlayerMessage(player, "\u00a7e" + Helpers.formatMessage("message.graviChestPlate.levitationMode") + " " + "\u00a7c" + Helpers.formatMessage("message.text.disabled"));
        } else {
            ItemGraviChestPlate.saveWorkMode(itemstack, true);
            ServerProxy.sendPlayerMessage(player, "\u00a7e" + Helpers.formatMessage("message.graviChestPlate.levitationMode") + " " + "\u00a7a" + Helpers.formatMessage("message.text.enabled"));
        }
        return 0;
    }

    public static int switchFlyState(EntityPlayer player, ItemStack itemstack) {
        if (ItemGraviChestPlate.readFlyStatus(itemstack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
            }
            ItemGraviChestPlate.saveFlyStatus(itemstack, false);
            ServerProxy.sendPlayerMessage(player, "\u00a7c" + Helpers.formatMessage("message.graviChestPlate.gravitationEngine") + " " + Helpers.formatMessage("message.text.disabled"));
        } else {
            int currCharge = ItemGraviChestPlate.getCharge(itemstack);
            if (currCharge >= minCharge || player.field_71075_bZ.field_75098_d) {
                ServerProxy.sendPlayerMessage(player, "\u00a7a" + Helpers.formatMessage("message.graviChestPlate.gravitationEngine") + " " + Helpers.formatMessage("message.text.enabled"));
                player.field_71075_bZ.field_75101_c = true;
                player.field_71075_bZ.field_75100_b = true;
                ItemGraviChestPlate.saveFlyStatus(itemstack, true);
            } else {
                ServerProxy.sendPlayerMessage(player, Helpers.formatMessage("message.graviChestPlate.lowEnergy"));
            }
        }
        return 0;
    }

    public void onArmorTick(World worldObj, EntityPlayer player, ItemStack itemStack) {
        if (GraviSuite.proxy.checkLastUndressed(player)) {
            GraviSuite.proxy.SetLastUndressed(player, false);
        }
        if (ItemGraviChestPlate.readFlyStatus(itemStack)) {
            if (!GraviSuite.proxy.checkFlyActiveByMod(player)) {
                GraviSuite.proxy.SetFlyActiveByMod(player, true);
            }
            if (!player.field_71075_bZ.field_75101_c) {
                player.field_71075_bZ.field_75101_c = true;
                if (!player.field_70122_E) {
                    player.field_71075_bZ.field_75100_b = true;
                }
            }
            if (ItemGraviChestPlate.readWorkMode(itemStack)) {
                if ((Keyboard.isJumpKeyDown(player) || player.field_70181_x < -hoverModeFallSpeed && !player.field_70122_E) && !player.field_71075_bZ.field_75100_b) {
                    player.field_71075_bZ.field_75100_b = true;
                }
            }
            NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemStack);
            int currCharge = ItemGraviChestPlate.getCharge(itemStack);
            if (!player.field_71075_bZ.field_75098_d) {
                if (currCharge < dischargeInFlight) {
                    ServerProxy.sendPlayerMessage(player, "\u00a7c" + Helpers.formatMessage("message.graviChestPlate.shutdown"));
                    ItemGraviChestPlate.switchFlyState(player, itemStack);
                } else if (!player.field_70122_E) {
                    ElectricItem.manager.discharge(itemStack, dischargeInFlight, 4, false, false);
                } else {
                    ElectricItem.manager.discharge(itemStack, dischargeIdleMode, 4, false, false);
                }
            }
            player.field_70143_R = 0.0f;
            if (!player.field_70122_E && player.field_71075_bZ.field_75100_b && Keyboard.isBoostKeyDown(player)) {
                this.boostMode(player, itemStack);
                if (currCharge > dischargeInFlight * boostMultiplier || player.field_71075_bZ.field_75098_d) {
                    if (Keyboard.isJumpKeyDown(player)) {
                        player.field_70181_x += (double)(boostSpeed + 0.1f);
                    }
                    if (Keyboard.isSneakKeyDown(player)) {
                        player.field_70181_x -= (double)(boostSpeed + 0.1f);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        ElectricItem.manager.discharge(itemStack, dischargeInFlight * boostMultiplier, 3, true, false);
                    }
                } else {
                    ServerProxy.sendPlayerMessage(player, Helpers.formatMessage("message.graviChestPlate.noEnergyToBoost"));
                }
            }
        } else if (GraviSuite.proxy.checkFlyActiveByMod(player)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
            }
            if (GraviSuite.isSimulating()) {
                GraviSuite.proxy.SetFlyActiveByMod(player, false);
            }
        }
        if (player.func_70027_ad()) {
            player.func_70066_B();
        }
    }

    public boolean boostMode(EntityPlayer player, ItemStack itemstack) {
        int currCharge;
        if (ItemGraviChestPlate.readFlyStatus(itemstack) && !player.field_70122_E && player.field_71075_bZ.field_75100_b && !player.func_70090_H() && ((currCharge = ItemGraviChestPlate.getCharge(itemstack)) > dischargeInFlight * boostMultiplier || player.field_71075_bZ.field_75098_d)) {
            player.func_70060_a(player.field_70702_br, player.field_70701_bs, boostSpeed);
            if (!player.field_71075_bZ.field_75098_d) {
                ElectricItem.manager.discharge(itemstack, dischargeInFlight * boostMultiplier, 3, true, false);
            }
        }
        return true;
    }

    public static boolean firstLoadServer(EntityPlayer player, ItemStack itemstack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        String gravitationEngine = ItemGraviChestPlate.readFlyStatus(itemStack) ? EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.on") : EnumChatFormatting.RED + Helpers.formatMessage("message.text.off");
        String leviatitonModeStatus = ItemGraviChestPlate.readWorkMode(itemStack) ? EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.on") : EnumChatFormatting.RED + Helpers.formatMessage("message.text.off");
        list.add(EnumChatFormatting.AQUA + Helpers.formatMessage("message.graviChestPlate.gravitationEngine") + ": " + gravitationEngine);
        list.add(EnumChatFormatting.AQUA + Helpers.formatMessage("message.graviChestPlate.levitationMode") + ": " + leviatitonModeStatus);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = energyPerDamage > 0 ? 25 * ElectricItem.manager.getCharge(armor) / energyPerDamage : 0;
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public static int getCharge(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        int k = nbttagcompound.func_74762_e("charge");
        return k;
    }

    public static void setCharge(ItemStack itemstack, int newCharge) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74768_a("charge", newCharge);
        System.out.println(newCharge);
    }

    public int getEnergyPerDamage() {
        return 2000;
    }

    public double getDamageAbsorptionRatio() {
        return 1.1;
    }

    private double getBaseAbsorptionRatio() {
        return 0.4;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("gravisuite:itemGraviChestPlate");
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "gravisuite:textures/armor/armor_graviChestPlate.png";
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public int getMaxCharge(ItemStack itemStack) {
        return maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return tier;
    }

    public int getTransferLimit(ItemStack itemStack) {
        return transferLimit;
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, damage * this.getEnergyPerDamage(), Integer.MAX_VALUE, true, false);
    }

    public static boolean readWorkMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        return nbttagcompound.func_74767_n("isLevitationActive");
    }

    public static boolean saveWorkMode(ItemStack itemstack, boolean workMode) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74757_a("isLevitationActive", workMode);
        return true;
    }

    public static boolean readFlyStatus(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        return nbttagcompound.func_74767_n("isFlyActive");
    }

    public static boolean saveFlyStatus(ItemStack itemstack, boolean flyMode) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74757_a("isFlyActive", flyMode);
        return true;
    }

    public static boolean readActiveByModStatus(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        return nbttagcompound.func_74767_n("isFlyActiveByMod");
    }

    public static boolean saveActiveByModStatus(ItemStack itemstack, boolean activeByMod) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74757_a("isFlyActiveByMod", activeByMod);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.epic;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }
}

