/*
 * Decompiled with CFR 0.152.
 */
package gravisuite;

import buildcraft.api.tools.IToolWrench;
import com.eloraam.redpower.core.IRotatable;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.Helpers;
import gravisuite.ServerProxy;
import gravisuite.audio.AudioManagerClient;
import gravisuite.audio.PositionSpec;
import gravisuite.keyboard.Keyboard;
import gravisuite.keyboard.KeyboardClient;
import gravisuite.redpower.coreLib;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IWrenchable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLever;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.UseHoeEvent;

public class ItemGraviTool
extends ItemTool
implements IElectricItem,
IToolWrench {
    private int maxCharge;
    private int tier;
    private float effPower;
    private boolean firstuse;
    private boolean lastUse;
    public Set mineableBlocks = new HashSet();
    public static int hoeTextureIndex = 0;
    public static int treeTapTextureIndex = 1;
    public static int wrenchTextureIndex = 2;
    public static int screwDriverTextureIndex = 3;
    private int energyPerHoe;
    private int energyPerTreeTap;
    private int energyPerSwitchSide;
    private int energyPerWrenchStandartOperation;
    private int energyPerWrenchFineOperation;
    private int privateToolMode;
    private int transferLimit;
    public static List<IIcon> itemsIconsList;
    public static List<String> textureList;
    public static IIcon[] iconsList;
    private final Set<Class<? extends Block>> shiftRotations = new HashSet<Class<? extends Block>>();

    protected ItemGraviTool(Item.ToolMaterial toolMaterial) {
        super(0.0f, toolMaterial, new HashSet());
        this.func_77656_e(27);
        this.maxCharge = 300000;
        this.tier = 2;
        this.field_77864_a = 16.0f;
        this.energyPerHoe = 50;
        this.energyPerTreeTap = 50;
        this.transferLimit = 10000;
        this.energyPerSwitchSide = 50;
        this.energyPerWrenchStandartOperation = 500;
        this.energyPerWrenchFineOperation = 10000;
        this.firstuse = true;
        this.func_77637_a(GraviSuite.ic2Tab);
        itemsIconsList = new ArrayList<IIcon>();
        textureList = new ArrayList<String>();
        this.addTexturesPath();
        this.shiftRotations.add(BlockLever.class);
        this.shiftRotations.add(BlockButton.class);
        this.shiftRotations.add(BlockChest.class);
    }

    public void addTexturesPath() {
        textureList.add("textures/items/itemGraviToolHoe.png");
        textureList.add("textures/items/itemGraviToolTreeTap.png");
        textureList.add("textures/items/itemGraviToolWrench.png");
        textureList.add("textures/items/itemGraviToolScrewdriver.png");
    }

    public boolean canDischarge(ItemStack var1, int var2) {
        return ElectricItem.manager.discharge(var1, var2, Integer.MAX_VALUE, true, true) == var2;
    }

    public void init() {
        this.mineableBlocks.add(Blocks.field_150346_d);
        this.mineableBlocks.add(Blocks.field_150349_c);
        this.mineableBlocks.add(Blocks.field_150391_bh);
    }

    public void dischargeItem(ItemStack itemstack, EntityPlayer player, int value) {
        ElectricItem.manager.use(itemstack, value, (EntityLivingBase)player);
    }

    public static void setToolName(ItemStack itemStack) {
        Integer toolMode = ItemGraviTool.readToolMode(itemStack);
        if (toolMode == 1) {
            itemStack.func_151001_c(Helpers.formatMessage("item.graviTool.name") + " (" + Helpers.formatMessage("graviTool.snap.Hoe") + ")");
        }
        if (toolMode == 2) {
            itemStack.func_151001_c(Helpers.formatMessage("item.graviTool.name") + " (" + Helpers.formatMessage("graviTool.snap.TreeTap") + ")");
        }
        if (toolMode == 3) {
            itemStack.func_151001_c(Helpers.formatMessage("item.graviTool.name") + " (" + Helpers.formatMessage("graviTool.snap.Wrench") + ")");
        }
        if (toolMode == 4) {
            itemStack.func_151001_c(Helpers.formatMessage("item.graviTool.name") + " (" + Helpers.formatMessage("graviTool.snap.Screwdriver") + ")");
        }
    }

    private boolean isShiftRotation(Class<? extends Block> cls) {
        for (Class<? extends Block> shift : this.shiftRotations) {
            if (!shift.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (GraviSuite.isSimulating() && Keyboard.isModeKeyDown(player)) {
            Integer toolMode = ItemGraviTool.readToolMode(itemStack);
            if ((toolMode = Integer.valueOf(toolMode + 1)) > 4) {
                toolMode = 1;
            }
            ItemGraviTool.saveToolMode(itemStack, toolMode);
            ItemGraviTool.setToolName(itemStack);
            if (toolMode == 1) {
                ServerProxy.sendPlayerMessage(player, "\u00a72" + Helpers.formatMessage("graviTool.snap.Hoe") + " " + "\u00a7a" + Helpers.formatMessage("message.text.activated"));
            } else if (toolMode == 2) {
                ServerProxy.sendPlayerMessage(player, "\u00a76" + Helpers.formatMessage("graviTool.snap.TreeTap") + " " + "\u00a7a" + Helpers.formatMessage("message.text.activated"));
            } else if (toolMode == 3) {
                ServerProxy.sendPlayerMessage(player, "\u00a7b" + Helpers.formatMessage("graviTool.snap.Wrench") + " " + "\u00a7a" + Helpers.formatMessage("message.text.activated"));
            } else if (toolMode == 4) {
                ServerProxy.sendPlayerMessage(player, "\u00a7d" + Helpers.formatMessage("graviTool.snap.Screwdriver") + " " + "\u00a7a" + Helpers.formatMessage("message.text.activated"));
            }
        }
        if (!GraviSuite.isSimulating() && KeyboardClient.isModeKeyPress(player)) {
            AudioManagerClient.playSound(player, PositionSpec.Hand, "toolChange");
        }
        return itemStack;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side, float a, float b, float c) {
        ItemGraviTool.setToolName(itemstack);
        Integer toolMode = ItemGraviTool.readToolMode(itemstack);
        if (toolMode == 3) {
            this.lastUse = this.onWrenchUse(itemstack, entityplayer, world, i, j, k, side, a, b, c);
            return this.lastUse;
        }
        if (toolMode == 4) {
            this.lastUse = this.onScrewdriverUse(itemstack, entityplayer, world, i, j, k, side, a, b, c);
            return this.lastUse;
        }
        return false;
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side, float a, float b, float c) {
        Integer toolMode = ItemGraviTool.readToolMode(itemstack);
        if (toolMode == 1) {
            return this.onHoeUse(itemstack, entityplayer, world, i, j, k, side, a, b, c);
        }
        if (toolMode == 2) {
            return this.onTreeTapUse(itemstack, entityplayer, world, i, j, k, side, a, b, c);
        }
        if (toolMode != 3 || toolMode == 4) {
            // empty if block
        }
        return false;
    }

    public boolean onHoeUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side, float a, float b, float c) {
        if (!entityplayer.func_82247_a(i, j, k, side, itemstack)) {
            return false;
        }
        if (!this.canDischarge(itemstack, this.energyPerHoe)) {
            ServerProxy.sendPlayerMessage(entityplayer, Helpers.formatMessage("message.text.noenergy"));
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(entityplayer, itemstack, world, i, j, k);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            this.dischargeItem(itemstack, entityplayer, this.energyPerHoe);
            return true;
        }
        Block block = world.func_147439_a(i, j, k);
        if (side != 0 && world.func_147439_a(i, j + 1, k).isAir((IBlockAccess)world, i, j + 1, k) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
            Block block1 = Blocks.field_150458_ak;
            world.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), block1.field_149762_H.func_150498_e(), (block1.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block1.field_149762_H.func_150494_d() * 0.8f);
            if (!GraviSuite.isSimulating()) {
                return true;
            }
            this.dischargeItem(itemstack, entityplayer, this.energyPerHoe);
            world.func_147449_b(i, j, k, block1);
            return true;
        }
        return false;
    }

    public boolean onTreeTapUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side, float a, float b, float c) {
        Block block = world.func_147439_a(i, j, k);
        if (Helpers.equals(block, IC2Items.getItem((String)"blockBarrel"))) {
            try {
                Method barrelTreeTap = world.func_147438_o(i, j, k).getClass().getMethod("useTreetapOn", EntityPlayer.class, Integer.TYPE);
                return (Boolean)barrelTreeTap.invoke((Object)null, entityplayer, side);
            }
            catch (Throwable error) {
                // empty catch block
            }
        }
        if (Helpers.equals(block, IC2Items.getItem((String)"rubberWood"))) {
            this.attemptExtract(itemstack, entityplayer, world, i, j, k, side, null);
            return true;
        }
        return false;
    }

    public boolean onWrenchUse(ItemStack itemstack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!this.canDischarge(itemstack, this.energyPerSwitchSide)) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        int metaData = world.func_72805_g(x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        try {
            Method terraMethod;
            if (tileEntity.getClass().getName() == "TileEntityTerra" && ((Boolean)(terraMethod = tileEntity.getClass().getMethod("ejectBlueprint", new Class[0])).invoke((Object)null, new Object[0])).booleanValue()) {
                if (GraviSuite.isSimulating()) {
                    this.dischargeItem(itemstack, entityPlayer, this.energyPerSwitchSide);
                }
                if (!GraviSuite.isSimulating()) {
                    AudioManagerClient.playSound(entityPlayer, PositionSpec.Hand, "wrench");
                }
                return GraviSuite.isSimulating();
            }
        }
        catch (Throwable var8) {
            // empty catch block
        }
        if (tileEntity instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)tileEntity;
            if (Keyboard.isAltKeyDown(entityPlayer)) {
                side = entityPlayer.func_70093_af() ? (wrenchable.getFacing() + 5) % 6 : (wrenchable.getFacing() + 1) % 6;
            } else if (entityPlayer.func_70093_af()) {
                side += side % 2 * -2 + 1;
            }
            if (wrenchable.wrenchCanSetFacing(entityPlayer, side)) {
                if (GraviSuite.isSimulating()) {
                    wrenchable.setFacing((short)side);
                    this.dischargeItem(itemstack, entityPlayer, this.energyPerSwitchSide);
                }
                if (!GraviSuite.isSimulating()) {
                    AudioManagerClient.playSound(entityPlayer, PositionSpec.Hand, "wrench");
                }
                return GraviSuite.isSimulating();
            }
            if (this.canDischarge(itemstack, this.energyPerWrenchStandartOperation) && wrenchable.wrenchCanRemove(entityPlayer)) {
                if (GraviSuite.isSimulating()) {
                    if (GraviSuite.logWrench) {
                        String blockName = tileEntity.getClass().getName().replace("TileEntity", "");
                        MinecraftServer.func_71276_C();
                    }
                    boolean dropOriginalBlock = false;
                    if (wrenchable.getWrenchDropRate() < 1.0f && this.overrideWrenchSuccessRate(itemstack)) {
                        if (!this.canDischarge(itemstack, this.energyPerWrenchFineOperation)) {
                            ServerProxy.sendPlayerMessage(entityPlayer, Helpers.formatMessage("message.text.noenergy"));
                            return true;
                        }
                        dropOriginalBlock = true;
                        this.dischargeItem(itemstack, entityPlayer, this.energyPerWrenchFineOperation);
                    } else {
                        dropOriginalBlock = world.field_73012_v.nextFloat() <= wrenchable.getWrenchDropRate();
                        this.dischargeItem(itemstack, entityPlayer, this.energyPerWrenchStandartOperation);
                    }
                    ArrayList drops = block.getDrops(world, x, y, z, metaData, 0);
                    if (dropOriginalBlock) {
                        if (drops.isEmpty()) {
                            drops.add(wrenchable.getWrenchDrop(entityPlayer));
                        } else {
                            drops.set(0, wrenchable.getWrenchDrop(entityPlayer));
                        }
                    }
                    for (ItemStack itemStack : drops) {
                        ItemGraviTool.dropAsEntity(world, x, y, z, itemStack);
                    }
                    world.func_147468_f(x, y, z);
                }
                if (!GraviSuite.isSimulating()) {
                    AudioManagerClient.playSound(entityPlayer, PositionSpec.Hand, "wrench");
                }
            }
        }
        if (entityPlayer.func_70093_af() != this.isShiftRotation(block.getClass())) {
            return false;
        }
        if (this.canDischarge(itemstack, this.energyPerWrenchStandartOperation)) {
            if (block.rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
                if (GraviSuite.isSimulating()) {
                    entityPlayer.func_71038_i();
                    this.dischargeItem(itemstack, entityPlayer, this.energyPerWrenchStandartOperation);
                } else {
                    AudioManagerClient.playSound(entityPlayer, PositionSpec.Hand, "wrench");
                }
                return true;
            }
        } else {
            ServerProxy.sendPlayerMessage(entityPlayer, Helpers.formatMessage("message.text.noenergy"));
        }
        return false;
    }

    public boolean overrideWrenchSuccessRate(ItemStack var1) {
        return true;
    }

    public static void dropAsEntity(World var0, int var1, int var2, int var3, ItemStack var4) {
        if (var4 != null) {
            double var5 = 0.7;
            double var7 = (double)var0.field_73012_v.nextFloat() * var5 + (1.0 - var5) * 0.5;
            double var9 = (double)var0.field_73012_v.nextFloat() * var5 + (1.0 - var5) * 0.5;
            double var11 = (double)var0.field_73012_v.nextFloat() * var5 + (1.0 - var5) * 0.5;
            EntityItem var13 = new EntityItem(var0, (double)var1 + var7, (double)var2 + var9, (double)var3 + var11, var4.func_77946_l());
            var13.field_145804_b = 10;
            var0.func_72838_d((Entity)var13);
        }
    }

    public void ejectHarz(World world, int x, int y, int z, int side, int quantity) {
        double ejectX = (double)x + 0.5;
        double ejectY = (double)y + 0.5;
        double ejectZ = (double)z + 0.5;
        if (side == 2) {
            ejectZ -= 0.3;
        } else if (side == 5) {
            ejectX += 0.3;
        } else if (side == 3) {
            ejectZ += 0.3;
        } else if (side == 4) {
            ejectX -= 0.3;
        }
        for (int i = 0; i < quantity; ++i) {
            EntityItem entityitem = new EntityItem(world, ejectX, ejectY, ejectZ, IC2Items.getItem((String)"resin").func_77946_l());
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public boolean attemptExtract(ItemStack treeTapItem, EntityPlayer entityplayer, World world, int x, int y, int z, int side, List<ItemStack> stacks) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 2 || meta % 6 != side) {
            return false;
        }
        if (meta < 6) {
            if (!this.canDischarge(treeTapItem, this.energyPerTreeTap)) {
                ServerProxy.sendPlayerMessage(entityplayer, Helpers.formatMessage("message.text.noenergy"));
                return false;
            }
            if (GraviSuite.isSimulating()) {
                world.func_72921_c(x, y, z, meta + 6, 3);
                if (stacks != null) {
                    stacks.add(ItemGraviTool.copyWithSize(IC2Items.getItem((String)"resin"), world.field_73012_v.nextInt(3) + 1));
                } else {
                    this.ejectHarz(world, x, y, z, side, world.field_73012_v.nextInt(3) + 1);
                }
                Block woodBlock = ItemGraviTool.getBlock(IC2Items.getItem((String)"rubberWood"));
                world.func_147464_a(x, y, z, woodBlock, woodBlock.func_149738_a(world));
                this.dischargeItem(treeTapItem, entityplayer, this.energyPerTreeTap);
            }
            if (!GraviSuite.isSimulating()) {
                AudioManagerClient.playSound(entityplayer, PositionSpec.Hand, "Treetap");
            }
            return true;
        }
        if (world.field_73012_v.nextInt(5) == 0 && GraviSuite.isSimulating()) {
            world.func_72921_c(x, y, z, 1, 3);
        }
        if (world.field_73012_v.nextInt(5) == 0) {
            if (!this.canDischarge(treeTapItem, this.energyPerTreeTap)) {
                ServerProxy.sendPlayerMessage(entityplayer, Helpers.formatMessage("message.text.noenergy"));
                return false;
            }
            if (GraviSuite.isSimulating()) {
                this.ejectHarz(world, x, y, z, side, 1);
                if (stacks != null) {
                    stacks.add(ItemGraviTool.copyWithSize(IC2Items.getItem((String)"resin"), 1));
                } else {
                    this.ejectHarz(world, x, y, z, side, 1);
                }
                this.dischargeItem(treeTapItem, entityplayer, this.energyPerTreeTap);
            }
            if (!GraviSuite.isSimulating()) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public boolean onScrewdriverUse(ItemStack var1, EntityPlayer var2, World var3, int var4, int var5, int var6, int var7, float var8, float var9, float var10) {
        boolean var11 = false;
        if (var2 != null && var2.func_70093_af()) {
            var11 = true;
        }
        Block block = var3.func_147439_a(var4, var5, var6);
        int var13 = var3.func_72805_g(var4, var5, var6);
        if (block != Blocks.field_150413_aR && block != Blocks.field_150416_aS) {
            if (block == Blocks.field_150367_z) {
                if (!this.canDischarge(var1, this.energyPerWrenchStandartOperation)) {
                    if (GraviSuite.isSimulating()) {
                        ServerProxy.sendPlayerMessage(var2, Helpers.formatMessage("message.text.noenergy"));
                    }
                    return false;
                }
                var13 = var13 & 3 ^ var13 >> 2;
                var13 += 2;
                if (!GraviSuite.isSimulating()) {
                    // empty if block
                }
                if (GraviSuite.isSimulating()) {
                    this.dischargeItem(var1, var2, this.energyPerWrenchStandartOperation);
                }
                return GraviSuite.isSimulating();
            }
            if (block != Blocks.field_150331_J && block != Blocks.field_150320_F) {
                TileEntity iRotatableTileEntity = var3.func_147438_o(var4, var5, var6);
                if (iRotatableTileEntity instanceof IRotatable) {
                    if (!this.canDischarge(var1, this.energyPerWrenchStandartOperation)) {
                        if (GraviSuite.isSimulating()) {
                            ServerProxy.sendPlayerMessage(var2, Helpers.formatMessage("message.text.noenergy"));
                        }
                        return false;
                    }
                    MovingObjectPosition var15 = coreLib.retraceBlock(var3, var2, var4, var5, var6);
                    if (var15 == null) {
                        return false;
                    }
                    int var16 = ((IRotatable)iRotatableTileEntity).getPartMaxRotation(var15.subHit, var11);
                    if (var16 == 0) {
                        return false;
                    }
                    int var17 = ((IRotatable)iRotatableTileEntity).getPartRotation(var15.subHit, var11);
                    if (++var17 > var16) {
                        var17 = 0;
                    }
                    if (!GraviSuite.isSimulating()) {
                        AudioManagerClient.playSound(var2, PositionSpec.Hand, "wrench");
                    }
                    if (GraviSuite.isSimulating()) {
                        this.dischargeItem(var1, var2, this.energyPerWrenchStandartOperation);
                        ((IRotatable)iRotatableTileEntity).setPartRotation(var15.subHit, var11, var17);
                    }
                    return GraviSuite.isSimulating();
                }
                return false;
            }
            ++var13;
            if (!this.canDischarge(var1, this.energyPerWrenchStandartOperation)) {
                if (GraviSuite.isSimulating()) {
                    ServerProxy.sendPlayerMessage(var2, Helpers.formatMessage("message.text.noenergy"));
                }
                return false;
            }
            if (var13 > 5) {
                var13 = 0;
            }
            if (!GraviSuite.isSimulating()) {
                AudioManagerClient.playSound(var2, PositionSpec.Hand, "wrench");
            }
            if (GraviSuite.isSimulating()) {
                this.dischargeItem(var1, var2, this.energyPerWrenchStandartOperation);
                var3.func_72921_c(var4, var5, var6, var13, 7);
            }
            return GraviSuite.isSimulating();
        }
        if (!this.canDischarge(var1, this.energyPerWrenchStandartOperation)) {
            if (GraviSuite.isSimulating()) {
                ServerProxy.sendPlayerMessage(var2, Helpers.formatMessage("message.text.noenergy"));
            }
            return false;
        }
        if (!GraviSuite.isSimulating()) {
            AudioManagerClient.playSound(var2, PositionSpec.Hand, "wrench");
        }
        if (GraviSuite.isSimulating()) {
            this.dischargeItem(var1, var2, this.energyPerWrenchStandartOperation);
            var3.func_72921_c(var4, var5, var6, var13 & 0xC | var13 + 1 & 3, 7);
        }
        return GraviSuite.isSimulating();
    }

    public static Block getBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    public static ItemStack copyWithSize(ItemStack itemStack, int newSize) {
        ItemStack ret = itemStack.func_77946_l();
        ret.field_77994_a = newSize;
        return ret;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public int getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public int getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        return false;
    }

    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int xPos, int yPos, int zPos, EntityLivingBase entityliving) {
        return true;
    }

    public void damage(ItemStack var1, int var2, EntityPlayer var3) {
        ElectricItem.manager.use(var1, var2, (EntityLivingBase)var3);
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.uncommon;
    }

    public static Integer readToolMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        Integer toolMode = nbttagcompound.func_74762_e("toolMode");
        if (toolMode <= 0 || toolMode > 4) {
            toolMode = 1;
        }
        return toolMode;
    }

    public static Integer readTextureIndex(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        Integer textureIndex = nbttagcompound.func_74762_e("textureIndex");
        if (textureIndex <= 0) {
            textureIndex = hoeTextureIndex;
        }
        return textureIndex;
    }

    public static boolean saveToolMode(ItemStack itemstack, Integer toolMode) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74768_a("toolMode", toolMode.intValue());
        if (toolMode == 1) {
            nbttagcompound.func_74768_a("textureIndex", hoeTextureIndex);
        }
        if (toolMode == 2) {
            nbttagcompound.func_74768_a("textureIndex", treeTapTextureIndex);
        }
        if (toolMode == 3) {
            nbttagcompound.func_74768_a("textureIndex", wrenchTextureIndex);
        }
        if (toolMode == 4) {
            nbttagcompound.func_74768_a("textureIndex", screwDriverTextureIndex);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @Override
    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        Integer toolMode = ItemGraviTool.readToolMode(itemstack);
        if (toolMode == 3) {
            if (this.canDischarge(itemstack, this.energyPerWrenchStandartOperation)) {
                return true;
            }
            if (GraviSuite.isSimulating()) {
                ServerProxy.sendPlayerMessage(player, Helpers.formatMessage("message.text.noenergy"));
            }
            return false;
        }
        return false;
    }

    @Override
    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        if (GraviSuite.isSimulating()) {
            ItemStack itemstack = player.field_71071_by.func_70448_g();
            Integer toolMode = ItemGraviTool.readToolMode(itemstack);
            this.dischargeItem(itemstack, player, this.energyPerWrenchStandartOperation);
        } else {
            AudioManagerClient.playSound(player, PositionSpec.Hand, "wrench");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        ItemGraviTool.iconsList[0] = iconRegister.func_94245_a("gravisuite:itemGraviToolHoe");
        ItemGraviTool.iconsList[1] = iconRegister.func_94245_a("gravisuite:itemGraviToolTreeTap");
        ItemGraviTool.iconsList[2] = iconRegister.func_94245_a("gravisuite:itemGraviToolWrench");
        ItemGraviTool.iconsList[3] = iconRegister.func_94245_a("gravisuite:itemGraviToolScrewdriver");
        this.field_77791_bV = iconsList[0];
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int pass) {
        Integer myIndex = ItemGraviTool.readTextureIndex(itemStack);
        return iconsList[myIndex];
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    static {
        iconsList = new IIcon[4];
    }
}

