/*
 * Decompiled with CFR 0.152.
 */
package gravisuite;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.Helpers;
import gravisuite.ItemGraviTool;
import gravisuite.ServerProxy;
import gravisuite.keyboard.Keyboard;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemVajra
extends ItemTool
implements IElectricItem {
    private int maxCharge;
    private int tier;
    private float effPower;
    private int energyPerOperation;
    private int transferLimit;
    private int toolMode;

    protected ItemVajra(Item.ToolMaterial toolMaterial) {
        super(0.0f, toolMaterial, new HashSet());
        this.func_77656_e(27);
        this.maxCharge = 3000000;
        this.tier = 2;
        this.transferLimit = 60000;
        this.field_77864_a = this.effPower = 20000.0f;
        this.energyPerOperation = 3333;
        this.func_77637_a(GraviSuite.ic2Tab);
        this.toolMode = 0;
    }

    public static Integer readToolMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        Integer toolMode = nbttagcompound.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > 1) {
            toolMode = 0;
        }
        return toolMode;
    }

    public void saveToolMode(ItemStack itemstack, Integer toolMode) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74768_a("toolMode", toolMode.intValue());
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (Keyboard.isModeKeyDown(player)) {
            if (!GraviSuite.disableVajraAccurate) {
                Integer toolMode = ItemVajra.readToolMode(itemStack);
                if ((toolMode = Integer.valueOf(toolMode + 1)) > 1) {
                    toolMode = 0;
                }
                this.saveToolMode(itemStack, toolMode);
                if (toolMode == 0) {
                    ServerProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("message.vajra.silkTouchMode") + ": " + EnumChatFormatting.RED + Helpers.formatMessage("message.text.disabled"));
                }
                if (toolMode == 1) {
                    ServerProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("message.vajra.silkTouchMode") + ": " + EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.enabled"));
                }
            } else {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.RED + Helpers.formatMessage("message.vajra.silkTouchDisabled"));
            }
        }
        return itemStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side, float a, float b, float c) {
        block14: {
            Integer toolMode = ItemVajra.readToolMode(itemstack);
            if (!GraviSuite.disableVajraAccurate && toolMode == 1) {
                block15: {
                    int metaData = world.func_72805_g(i, j, k);
                    Block block = world.func_147439_a(i, j, k);
                    if (block == Blocks.field_150357_h || block == Blocks.field_150474_ac || !block.canHarvestBlock(entityplayer, metaData) || block.func_149650_a(metaData, world.field_73012_v, 1) == null) break block14;
                    if (!ElectricItem.manager.canUse(itemstack, this.energyPerOperation)) break block15;
                    if (GraviSuite.isSimulating()) {
                        Boolean dropFlag = false;
                        if (block.canSilkHarvest(world, entityplayer, i, j, k, metaData)) {
                            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                            ItemStack stack = this.createStackedBlock(block, metaData);
                            if (stack != null) {
                                items.add(stack);
                            }
                            ForgeEventFactory.fireBlockHarvesting(items, (World)world, (Block)block, (int)i, (int)j, (int)k, (int)metaData, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)entityplayer);
                            for (ItemStack is : items) {
                                ItemGraviTool.dropAsEntity(world, i, j, k, is);
                            }
                            dropFlag = true;
                        } else {
                            int count = block.quantityDropped(metaData, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack), world.field_73012_v);
                            if (count > 0) {
                                int exp = block.getExpDrop((IBlockAccess)world, metaData, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
                                block.func_149657_c(world, i, j, k, exp);
                                block.func_149636_a(world, entityplayer, i, j, k, metaData);
                                block.func_149681_a(world, i, j, k, metaData, entityplayer);
                                float blockHardness = block.func_149712_f(world, i, j, k);
                                if (blockHardness > 0.0f) {
                                    this.func_150894_a(itemstack, world, block, i, j, k, (EntityLivingBase)entityplayer);
                                }
                                world.func_147479_m(i, j, k);
                                dropFlag = true;
                            }
                        }
                        if (dropFlag.booleanValue()) {
                            world.func_147468_f(i, j, k);
                            world.func_147479_m(i, j, k);
                            world.func_72926_e(2001, i, j, k, Block.func_149682_b((Block)block) + (metaData << 12));
                            ElectricItem.manager.use(itemstack, this.energyPerOperation, (EntityLivingBase)entityplayer);
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                try {
                    boolean bl = false;
                    return bl;
                }
                catch (Exception e) {
                    GraviSuite.addLog("Vajra: Error in destroy function (" + e.getLocalizedMessage() + ")");
                }
            }
        }
        return false;
    }

    protected ItemStack createStackedBlock(Block block, int meta) {
        int j = 0;
        Item item = Item.func_150898_a((Block)block);
        if (item != null && item.func_77614_k()) {
            j = meta;
        }
        return new ItemStack(item, 1, j);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public int getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public int getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return block != Blocks.field_150357_h;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return this.field_77862_b.func_77996_d();
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        if (!ElectricItem.manager.canUse(tool, this.energyPerOperation)) {
            return 1.0f;
        }
        if (this.canHarvestBlock(block, tool)) {
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        if (ElectricItem.manager.use(itemstack, this.energyPerOperation * 2, attacker)) {
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 25.0f);
        } else {
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 1.0f);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("gravisuite:itemVajra");
    }

    public float getStrVsBlock(ItemStack itemstack, Block par2Block) {
        if (ElectricItem.manager.canUse(itemstack, this.energyPerOperation)) {
            return this.effPower;
        }
        return 0.5f;
    }

    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int xPos, int yPos, int zPos, EntityLivingBase entityliving) {
        if ((double)block.func_149712_f(world, xPos, yPos, zPos) != 0.0) {
            if (entityliving != null) {
                ElectricItem.manager.use(itemstack, this.energyPerOperation, entityliving);
            } else {
                ElectricItem.manager.discharge(itemstack, this.energyPerOperation, this.tier, true, false);
            }
        }
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        Integer toolMode = ItemVajra.readToolMode(par1ItemStack);
        if (toolMode == 0) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.vajra.silkTouchMode") + ": " + EnumChatFormatting.RED + Helpers.formatMessage("message.text.disabled"));
        }
        if (toolMode == 1) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.vajra.silkTouchMode") + ": " + EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.enabled"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }
}

