/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.asm;

import codechicken.lib.asm.ASMBlock;
import codechicken.lib.asm.ASMHelper;
import codechicken.lib.asm.ASMInit;
import codechicken.lib.asm.ASMReader;
import codechicken.lib.asm.ClassHeirachyManager;
import codechicken.lib.asm.InsnComparator;
import codechicken.lib.asm.InsnListSection;
import codechicken.lib.asm.ModularASMTransformer;
import codechicken.lib.asm.ObfMapping;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class NEITransformer
implements IClassTransformer {
    private ModularASMTransformer transformer = new ModularASMTransformer();
    private Map<String, ASMBlock> asmblocks = ASMReader.loadResource((String)"/assets/nei/asm/blocks.asm");
    private ObfMapping c_GuiContainer = new ObfMapping("net/minecraft/client/gui/inventory/GuiContainer").toClassloading();

    public NEITransformer() {
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodWriter(1, new ObfMapping("net/minecraft/block/BlockMobSpawner", "func_149689_a", "(Lnet/minecraft/world/World;IIILnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;)V"), this.asmblocks.get("spawnerPlaced")));
        if (FMLLaunchHandler.side().isClient()) {
            this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodReplacer(new ObfMapping("net/minecraft/tileentity/MobSpawnerBaseLogic", "func_98281_h", "()Lnet/minecraft/entity/Entity;"), this.asmblocks.get("d_spawnerWorld"), this.asmblocks.get("spawnerWorld")));
        }
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(new ObfMapping("net/minecraft/nbt/NBTTagCompound", "toString", "()Ljava/lang/String;"), this.asmblocks.get("n_commaFix"), this.asmblocks.get("commaFix"), true));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(new ObfMapping("net/minecraft/nbt/NBTTagList", "toString", "()Ljava/lang/String;"), this.asmblocks.get("n_commaFix"), this.asmblocks.get("commaFix"), true));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodTransformer(new ObfMapping("net/minecraft/inventory/ContainerWorkbench", "func_82846_b", "(Lnet/minecraft/entity/player/EntityPlayer;I)Lnet/minecraft/item/ItemStack;")){

            public void transform(MethodNode mv) {
                ASMHelper.logger.debug("NEI: Applying workbench fix");
                InsnListSection key = (InsnListSection)InsnComparator.findN((InsnList)mv.instructions, (InsnListSection)((ASMBlock)((NEITransformer)NEITransformer.this).asmblocks.get((Object)"n_workbenchFix")).list).get(0);
                key.insertBefore(((ASMBlock)NEITransformer.this.asmblocks.get("workbenchFix")).rawListCopy());
            }
        });
        String GuiContainer2 = "net/minecraft/client/gui/inventory/GuiContainer";
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.FieldWriter(1, new ObfMapping(GuiContainer2, "manager", "Lcodechicken/nei/guihook/GuiContainerManager;")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodWriter(9, new ObfMapping("codechicken/nei/guihook/GuiContainerManager", "getManager", "(Lnet/minecraft/client/gui/inventory/GuiContainer;)Lcodechicken/nei/guihook/GuiContainerManager;"), this.asmblocks.get("m_getManager")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodWriter(1, new ObfMapping(GuiContainer2, "func_146280_a", "(Lnet/minecraft/client/Minecraft;II)V"), this.asmblocks.get("m_setWorldAndResolution")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodWriter(1, new ObfMapping(GuiContainer2, "func_146282_l", "()V"), this.asmblocks.get("m_handleKeyboardInput")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodWriter(1, new ObfMapping(GuiContainer2, "func_146282_l", "()V"), this.asmblocks.get("m_handleKeyboardInput")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodWriter(1, new ObfMapping(GuiContainer2, "func_146282_l", "()V"), this.asmblocks.get("m_handleKeyboardInput")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodWriter(1, new ObfMapping(GuiContainer2, "func_146274_d", "()V"), this.asmblocks.get("m_handleMouseInput")));
        this.addProtectedForwarder(new ObfMapping(GuiContainer2, "func_73869_a", "(CI)V"), new ObfMapping("codechicken/nei/guihook/GuiContainerManager", "callKeyTyped", "(Lnet/minecraft/client/gui/inventory/GuiContainer;CI)V"));
        this.addProtectedForwarder(new ObfMapping(GuiContainer2, "func_146984_a", "(Lnet/minecraft/inventory/Slot;III)V"), new ObfMapping("codechicken/nei/guihook/DefaultSlotClickHandler", "callHandleMouseClick", "(Lnet/minecraft/client/gui/inventory/GuiContainer;Lnet/minecraft/inventory/Slot;III)V"));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(new ObfMapping(GuiContainer2, "func_73863_a", "(IIF)V"), this.asmblocks.get("preDraw"), true));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(new ObfMapping(GuiContainer2, "func_73863_a", "(IIF)V"), this.asmblocks.get("n_objectUnderMouse"), this.asmblocks.get("objectUnderMouse"), false));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(new ObfMapping(GuiContainer2, "func_73863_a", "(IIF)V"), this.asmblocks.get("n_renderObjects"), this.asmblocks.get("renderObjects"), false));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodReplacer(new ObfMapping(GuiContainer2, "func_73863_a", "(IIF)V"), this.asmblocks.get("d_renderToolTip"), this.asmblocks.get("renderTooltips")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodReplacer(new ObfMapping(GuiContainer2, "func_146982_a", "(Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V"), this.asmblocks.get("d_zLevel"), this.asmblocks.get("zLevel")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodReplacer(new ObfMapping(GuiContainer2, "func_146977_a", "(Lnet/minecraft/inventory/Slot;)V"), this.asmblocks.get("d_drawSlot"), this.asmblocks.get("drawSlot")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(new ObfMapping(GuiContainer2, "func_73864_a", "(III)V"), this.asmblocks.get("mouseClicked"), true));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodReplacer(new ObfMapping(GuiContainer2, "func_73864_a", "(III)V"), this.asmblocks.get("d_handleMouseClick"), this.asmblocks.get("handleMouseClick")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodReplacer(new ObfMapping(GuiContainer2, "func_146273_a", "(IIIJ)V"), this.asmblocks.get("d_handleMouseClick"), this.asmblocks.get("handleMouseClick")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodReplacer(new ObfMapping(GuiContainer2, "func_146286_b", "(III)V"), this.asmblocks.get("d_handleMouseClick"), this.asmblocks.get("handleMouseClick")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodReplacer(new ObfMapping(GuiContainer2, "func_73869_a", "(CI)V"), this.asmblocks.get("d_handleMouseClick"), this.asmblocks.get("handleMouseClick")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodReplacer(new ObfMapping(GuiContainer2, "func_146983_a", "(I)Z"), this.asmblocks.get("d_handleMouseClick"), this.asmblocks.get("handleMouseClick")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodWriter(1, new ObfMapping(GuiContainer2, "managerHandleMouseClick", "(Lnet/minecraft/inventory/Slot;III)V"), this.asmblocks.get("m_managerHandleMouseClick")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(new ObfMapping(GuiContainer2, "func_146273_a", "(IIIJ)V"), this.asmblocks.get("n_mouseDragged"), this.asmblocks.get("mouseDragged"), false));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(new ObfMapping(GuiContainer2, "func_146286_b", "(III)V"), this.asmblocks.get("overrideMouseUp"), true));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodTransformer(new ObfMapping(GuiContainer2, "func_146286_b", "(III)V")){

            public void transform(MethodNode mv) {
                ASMHelper.logger.debug("NEI: Injecting mouseUp call");
                ASMBlock gotoBlock = (ASMBlock)NEITransformer.this.asmblocks.get("n_mouseUpGoto");
                ASMBlock needleBlock = (ASMBlock)NEITransformer.this.asmblocks.get("n_mouseUp");
                ASMBlock injectionBlock = (ASMBlock)NEITransformer.this.asmblocks.get("mouseUp");
                gotoBlock.mergeLabels(injectionBlock);
                InsnComparator.findOnce((InsnList)mv.instructions, (InsnListSection)gotoBlock.list).replace(gotoBlock.list.list);
                InsnListSection needle = InsnComparator.findOnce((InsnList)mv.instructions, (InsnListSection)needleBlock.list);
                injectionBlock.mergeLabels(needleBlock.applyLabels(needle));
                needle.insertBefore(injectionBlock.list.list);
            }
        });
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodReplacer(new ObfMapping(GuiContainer2, "func_146984_a", "(Lnet/minecraft/inventory/Slot;III)V"), this.asmblocks.get("d_handleSlotClick"), this.asmblocks.get("handleSlotClick")));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(new ObfMapping(GuiContainer2, "func_73869_a", "(CI)V"), this.asmblocks.get("lastKeyTyped"), true));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(new ObfMapping(GuiContainer2, "func_73876_c", "()V"), this.asmblocks.get("n_updateScreen"), this.asmblocks.get("updateScreen"), false));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(new ObfMapping("net/minecraft/client/gui/inventory/GuiContainerCreative", "func_147049_a", "(Lnet/minecraft/creativetab/CreativeTabs;II)Z"), this.asmblocks.get("handleTabClick"), true));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(new ObfMapping("net/minecraft/client/gui/inventory/GuiContainerCreative", "func_147052_b", "(Lnet/minecraft/creativetab/CreativeTabs;II)Z"), this.asmblocks.get("renderTabTooltip"), true));
        String[] buttons = new String[]{"CancelButton", "ConfirmButton", "PowerButton"};
        String[] this_fields = new String[]{"field_146146_o", "field_146147_o", "field_146150_o"};
        for (int i = 0; i < 3; ++i) {
            ObfMapping m = new ObfMapping("net/minecraft/client/gui/inventory/GuiBeacon$" + buttons[i], "func_146111_b", "(II)V");
            InsnListSection l = this.asmblocks.get((Object)"beaconButtonObscured").list.copy();
            FieldInsnNode this_ref = (FieldInsnNode)l.get(1);
            this_ref.owner = m.toClassloading().s_owner;
            if (ObfMapping.obfuscated) {
                this_ref.name = ObfMapping.obfMapper.mapFieldName(null, this_fields[i], null);
            }
            this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodInjector(m, l.list, true));
        }
    }

    private void addProtectedForwarder(ObfMapping called, ObfMapping caller) {
        InsnList forward1 = new InsnList();
        InsnList forward2 = new InsnList();
        ObfMapping publicCall = new ObfMapping(called.s_owner, "public_" + called.s_name, called.s_desc);
        Type[] args = Type.getArgumentTypes((String)caller.s_desc);
        for (int i = 0; i < args.length; ++i) {
            forward1.add((AbstractInsnNode)new VarInsnNode(args[i].getOpcode(21), i));
            forward2.add((AbstractInsnNode)new VarInsnNode(args[i].getOpcode(21), i));
        }
        forward1.add(publicCall.toInsn(182));
        forward2.add(called.toClassloading().toInsn(182));
        forward1.add((AbstractInsnNode)new InsnNode(Type.getReturnType((String)called.s_desc).getOpcode(172)));
        forward2.add((AbstractInsnNode)new InsnNode(Type.getReturnType((String)called.s_desc).getOpcode(172)));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodWriter(9, caller, forward1));
        this.transformer.add((ModularASMTransformer.ClassNodeTransformer)new ModularASMTransformer.MethodWriter(1, publicCall, forward2));
    }

    public byte[] transformSubclasses(String name, byte[] bytes) {
        if (ClassHeirachyManager.classExtends((String)name, (String)this.c_GuiContainer.javaClass())) {
            ClassNode cnode = ASMHelper.createClassNode((byte[])bytes);
            ObfMapping methodmap = new ObfMapping(cnode.superName, "func_73876_c", "()V").toClassloading();
            InsnListSection supercall = new InsnListSection();
            supercall.add((AbstractInsnNode)new VarInsnNode(25, 0));
            supercall.add(methodmap.toInsn(183));
            boolean changed = false;
            for (MethodNode mv : cnode.methods) {
                if (!methodmap.matches(mv) || InsnComparator.matches((InsnListSection)new InsnListSection(mv.instructions), (InsnListSection)supercall, (Set)InsnComparator.getControlFlowLabels((InsnList)mv.instructions)) != null) continue;
                mv.instructions.insert(supercall.list);
                ASMHelper.logger.debug("Inserted super call into " + methodmap);
                changed = true;
            }
            if (changed) {
                bytes = ASMHelper.createBytes((ClassNode)cnode, (int)3);
            }
        }
        return bytes;
    }

    public byte[] transform(String name, String tname, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            if (FMLLaunchHandler.side().isClient()) {
                bytes = this.transformSubclasses(name, bytes);
            }
            bytes = this.transformer.transform(name, bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    static {
        ASMInit.init();
    }
}

