/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.nei.ClientHandler;
import codechicken.nei.ServerHandler;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.asm.NEICorePlugin;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.util.EnumChatFormatting;

public class NEIModContainer
extends DummyModContainer {
    public static LinkedList<IConfigureNEI> plugins = new LinkedList();

    public NEIModContainer() {
        super(MetadataCollection.from((InputStream)MetadataCollection.class.getResourceAsStream("/neimod.info"), (String)"NotEnoughItems").getMetadataForId("NotEnoughItems", null));
        this.getMetadata();
    }

    public Set<ArtifactVersion> getRequirements() {
        HashSet<ArtifactVersion> deps = new HashSet<ArtifactVersion>();
        deps.add(VersionParser.parseVersionReference((String)"CodeChickenCore@1.0.2,)"));
        return deps;
    }

    public List<ArtifactVersion> getDependencies() {
        return new LinkedList<ArtifactVersion>(this.getRequirements());
    }

    public ModMetadata getMetadata() {
        ModMetadata meta = super.getMetadata();
        meta.description = "Recipe Viewer, Inventory Manager, Item Spawner, Cheats and more.\n" + EnumChatFormatting.WHITE + "\n";
        if (plugins.size() == 0) {
            meta.description = meta.description + EnumChatFormatting.RED + "No installed plugins.";
        } else {
            meta.description = meta.description + EnumChatFormatting.GREEN + "Installed plugins: ";
            for (int i = 0; i < plugins.size(); ++i) {
                if (i > 0) {
                    meta.description = meta.description + ", ";
                }
                IConfigureNEI plugin = plugins.get(i);
                meta.description = meta.description + plugin.getName() + " " + plugin.getVersion();
            }
            meta.description = meta.description + ".";
        }
        return meta;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        if (CommonUtils.isClient()) {
            ClientHandler.preInit();
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        if (CommonUtils.isClient()) {
            ClientHandler.load();
        }
        ServerHandler.load();
    }

    public VersionRange acceptableMinecraftVersionRange() {
        return VersionParser.parseRange((String)"[1.7.10]");
    }

    public File getSource() {
        return NEICorePlugin.location;
    }

    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }
}

