/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import dan200.QCraft;
import dan200.qcraft.shared.BlockQBlock;
import dan200.qcraft.shared.EntanglementRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityQBlock
extends TileEntity {
    public static int FUZZ_TIME = 9;
    public static Random s_random = new Random();
    public static EntanglementRegistry<TileEntityQBlock> QBlockRegistry = new EntanglementRegistry();
    public static EntanglementRegistry<TileEntityQBlock> ClientQBlockRegistry = new EntanglementRegistry();
    private int m_entanglementFrequency = -1;
    private int[] m_sideBlockTypes = new int[6];
    private long m_timeLastUpdated;
    private boolean m_currentlyObserved;
    private int m_currentDisplayedSide;
    private int m_currentlyForcedSide;
    private boolean[] m_forceObserved = new boolean[6];
    public int m_timeSinceLastChange;
    private boolean m_goggles;
    private boolean m_wet;

    public static EntanglementRegistry<TileEntityQBlock> getEntanglementRegistry(World world) {
        if (!world.field_72995_K) {
            return QBlockRegistry;
        }
        return ClientQBlockRegistry;
    }

    public TileEntityQBlock() {
        for (int i = 0; i < 6; ++i) {
            this.m_sideBlockTypes[i] = 0;
            this.m_forceObserved[i] = false;
        }
        this.m_currentlyObserved = false;
        this.m_currentlyForcedSide = -1;
        this.m_currentDisplayedSide = -1;
        this.m_timeLastUpdated = -99L;
        this.m_timeSinceLastChange = FUZZ_TIME;
        this.m_goggles = false;
        this.m_wet = false;
    }

    public EntanglementRegistry<TileEntityQBlock> getEntanglementRegistry() {
        return TileEntityQBlock.getEntanglementRegistry(this.field_145850_b);
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.m_entanglementFrequency >= 0) {
            this.getEntanglementRegistry().register(this.m_entanglementFrequency, this);
        }
    }

    public void func_145843_s() {
        if (this.m_entanglementFrequency >= 0) {
            this.getEntanglementRegistry().unregister(this.m_entanglementFrequency, this);
        }
        super.func_145843_s();
    }

    public void setTypes(int[] types) {
        this.m_sideBlockTypes = types;
    }

    public int[] getTypes() {
        return this.m_sideBlockTypes;
    }

    public void setEntanglementFrequency(int frequency) {
        if (frequency != this.m_entanglementFrequency) {
            if (this.m_entanglementFrequency >= 0) {
                this.getEntanglementRegistry().unregister(this.m_entanglementFrequency, this);
            }
            this.m_entanglementFrequency = frequency;
            if (this.m_entanglementFrequency >= 0) {
                this.getEntanglementRegistry().register(this.m_entanglementFrequency, this);
            }
        }
    }

    public int getEntanglementFrequency() {
        return this.m_entanglementFrequency;
    }

    public int getSubType() {
        return QCraft.Blocks.qBlock.getSubType((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void blockUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)QCraft.Blocks.qBlock, QCraft.Blocks.qBlock.func_149738_a(this.field_145850_b));
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)QCraft.Blocks.qBlock);
    }

    public boolean isForceObserved(int side) {
        return this.m_forceObserved[side];
    }

    public void setForceObserved(int side, boolean enable) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.m_forceObserved[side] = enable;
    }

    private void setDisplayedSide(boolean observed, boolean forced, int side) {
        this.m_currentlyObserved = observed;
        int n = this.m_currentlyForcedSide = forced ? side : -1;
        if (this.m_currentDisplayedSide != side) {
            int oldSide = this.m_currentDisplayedSide;
            int oldType = this.getObservedType();
            int newSide = this.m_currentDisplayedSide = side;
            int newType = this.getObservedType();
            if (newType != oldType || oldSide < 0 != newSide < 0) {
                this.m_timeSinceLastChange = 0;
                this.blockUpdate();
            }
        }
    }

    public int getObservedType() {
        if (this.m_currentDisplayedSide < 0) {
            return this.m_sideBlockTypes[1];
        }
        return this.m_sideBlockTypes[this.m_currentDisplayedSide];
    }

    public BlockQBlock.Appearance getAppearance() {
        if (this.m_goggles) {
            return BlockQBlock.Appearance.Fuzz;
        }
        if (this.m_currentDisplayedSide < 0 || this.m_timeSinceLastChange < FUZZ_TIME) {
            return BlockQBlock.Appearance.Swirl;
        }
        int type = this.m_sideBlockTypes[this.m_currentDisplayedSide];
        if (type == 0 && this.m_wet) {
            return BlockQBlock.Appearance.Fuzz;
        }
        return BlockQBlock.Appearance.Block;
    }

    private boolean checkRayClear(Vec3 playerPos, Vec3 blockPos) {
        MovingObjectPosition position = this.field_145850_b.func_72933_a(playerPos, blockPos);
        if (position == null) {
            return true;
        }
        return position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && position.field_72311_b == this.field_145851_c && position.field_72312_c == this.field_145848_d && position.field_72309_d == this.field_145849_e;
    }

    private int[] collectVotes() {
        int[] votes = new int[6];
        double centerX = (double)this.field_145851_c + 0.5;
        double centerY = (double)this.field_145848_d + 0.5;
        double centerZ = (double)this.field_145849_e + 0.5;
        List players = this.field_145850_b.field_73010_i;
        for (int i = 0; i < players.size(); ++i) {
            boolean flip;
            float f8;
            double fz;
            float f6;
            double fy;
            float f5;
            double z;
            double y;
            double x;
            double distance;
            ItemStack headGear;
            EntityPlayer player = (EntityPlayer)players.get(i);
            if (player == null || QCraft.isPlayerWearingGoggles(player) || (headGear = player.field_71071_by.func_70440_f(3)) != null && headGear.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK) || !((distance = Math.sqrt((x = player.field_70165_t - centerX) * x + (y = player.field_70163_u + 1.62 - (double)player.field_70129_M - centerY) * y + (z = player.field_70161_v - centerZ) * z)) < 96.0)) continue;
            double dx = x / distance;
            double dy = y / distance;
            double dz = z / distance;
            float pitch = player.field_70125_A;
            float yaw = player.field_70177_z;
            float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180))));
            double fx = f7;
            double dot = fx * dx + (fy = (double)(f6 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180))))) * dy + (fz = (double)(f8 = f3 * f5)) * dz;
            if (!(dot < -0.4)) continue;
            if (QCraft.enableQBlockOcclusionTesting) {
                Vec3 playerPos = Vec3.func_72443_a((double)(centerX + x), (double)(centerY + y), (double)(centerZ + z));
                boolean lineOfSightFound = false;
                for (int side = 0; side < 6; ++side) {
                    Vec3 sideNormal = Vec3.func_72443_a((double)(0.49 * (double)Facing.field_71586_b[side]), (double)(0.49 * (double)Facing.field_71587_c[side]), (double)(0.49 * (double)Facing.field_71585_d[side]));
                    Vec3 blockPos = Vec3.func_72443_a((double)(centerX + sideNormal.field_72450_a), (double)(centerY + sideNormal.field_72448_b), (double)(centerZ + sideNormal.field_72449_c));
                    Vec3 playerPosLocal = playerPos.func_72441_c(-blockPos.field_72450_a, -blockPos.field_72448_b, -blockPos.field_72449_c);
                    Vec3 playerPos2 = playerPos.func_72441_c(0.0, 0.0, 0.0);
                    if (!this.checkRayClear(playerPos2, blockPos)) continue;
                    lineOfSightFound = true;
                    break;
                }
                if (!lineOfSightFound) continue;
            }
            int majoraxis = -1;
            double majorweight = 0.0;
            if (-dy >= majorweight) {
                majoraxis = 0;
                majorweight = -dy;
            }
            if (dy >= majorweight) {
                majoraxis = 1;
                majorweight = dy;
            }
            if (-dz >= majorweight) {
                majoraxis = 2;
                majorweight = -dz;
            }
            if (dz >= majorweight) {
                majoraxis = 3;
                majorweight = dz;
            }
            if (-dx >= majorweight) {
                majoraxis = 4;
                majorweight = -dx;
            }
            if (dx >= majorweight) {
                majoraxis = 5;
                majorweight = dx;
            }
            if (majoraxis < 0) continue;
            if (this.getSubType() == 1 && (flip = s_random.nextBoolean())) {
                majoraxis = Facing.field_71588_a[majoraxis];
            }
            int n = majoraxis;
            votes[n] = votes[n] + 1;
        }
        return votes;
    }

    private static int[] addVotes(int[] a, int[] b) {
        int[] c = new int[6];
        for (int i = 0; i < 6; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    private static int tallyVotes(int[] votes) {
        int winner = 0;
        int winnerVotes = 0;
        for (int i = 0; i < 6; ++i) {
            int vote = votes[i];
            if (vote <= winnerVotes) continue;
            winner = i;
            winnerVotes = vote;
        }
        if (winnerVotes > 0) {
            return winner;
        }
        return -1;
    }

    private int getObservationResult(long currentTime) {
        List<TileEntityQBlock> twins;
        int[] votes = new int[6];
        if (this.m_entanglementFrequency >= 0 && (twins = this.getEntanglementRegistry().getEntangledObjects(this.m_entanglementFrequency)) != null) {
            for (TileEntityQBlock twin : twins) {
                if (twin == this) continue;
                if (twin.m_currentlyObserved && twin.m_timeLastUpdated == currentTime) {
                    if (twin.m_currentlyForcedSide >= 0) {
                        return twin.m_currentlyForcedSide + 6;
                    }
                    return twin.m_currentDisplayedSide;
                }
                if (twin.m_currentlyForcedSide >= 0 && twin.m_forceObserved[this.m_currentlyForcedSide]) {
                    return twin.m_currentlyForcedSide + 6;
                }
                for (int i = 0; i < 6; ++i) {
                    if (!twin.m_forceObserved[i]) continue;
                    return i + 6;
                }
                votes = TileEntityQBlock.addVotes(votes, twin.collectVotes());
            }
        }
        if (this.m_currentlyForcedSide >= 0 && this.m_forceObserved[this.m_currentlyForcedSide]) {
            return this.m_currentlyForcedSide + 6;
        }
        for (int i = 0; i < 6; ++i) {
            if (!this.m_forceObserved[i]) continue;
            return i + 6;
        }
        votes = TileEntityQBlock.addVotes(votes, this.collectVotes());
        return TileEntityQBlock.tallyVotes(votes);
    }

    private void redetermineObservedSide() {
        long currentTime = this.field_145850_b.func_72912_H().func_82573_f();
        int winner = this.getObservationResult(currentTime);
        if (winner >= 6) {
            this.setDisplayedSide(true, true, winner -= 6);
        } else if (winner >= 0) {
            if (this.m_currentlyForcedSide >= 0 || !this.m_currentlyObserved) {
                this.setDisplayedSide(true, false, winner);
            }
        } else if (this.m_currentlyObserved) {
            if (this.m_currentlyForcedSide >= 0) {
                this.setDisplayedSide(false, false, -1);
            } else {
                this.setDisplayedSide(false, false, this.m_currentDisplayedSide);
            }
        }
        this.m_timeLastUpdated = currentTime;
    }

    private boolean isTouchingLiquid() {
        for (int i = 1; i < 6; ++i) {
            int x = this.field_145851_c + Facing.field_71586_b[i];
            int y = this.field_145848_d + Facing.field_71587_c[i];
            int z = this.field_145849_e + Facing.field_71585_d[i];
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (block == null || !(block instanceof BlockLiquid)) continue;
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.redetermineObservedSide();
        }
        ++this.m_timeSinceLastChange;
        boolean goggles = this.field_145850_b.field_72995_K && QCraft.isLocalPlayerWearingQuantumGoggles();
        boolean wet = this.isTouchingLiquid();
        if (this.m_goggles != goggles || this.m_wet != wet || this.m_timeSinceLastChange == FUZZ_TIME) {
            this.m_wet = wet;
            this.m_goggles = goggles;
            this.blockUpdate();
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.m_currentlyObserved = nbttagcompound.func_74767_n("o");
        this.m_currentDisplayedSide = nbttagcompound.func_74762_e("d");
        this.m_entanglementFrequency = nbttagcompound.func_74764_b("f") ? nbttagcompound.func_74762_e("f") : -1;
        this.m_currentlyForcedSide = nbttagcompound.func_74764_b("c") ? nbttagcompound.func_74762_e("c") : -1;
        for (int i = 0; i < 6; ++i) {
            this.m_sideBlockTypes[i] = nbttagcompound.func_74762_e("s" + i);
            this.m_forceObserved[i] = nbttagcompound.func_74767_n("c" + i);
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("o", this.m_currentlyObserved);
        nbttagcompound.func_74768_a("d", this.m_currentDisplayedSide);
        nbttagcompound.func_74768_a("f", this.m_entanglementFrequency);
        nbttagcompound.func_74768_a("c", this.m_currentlyForcedSide);
        for (int i = 0; i < 6; ++i) {
            nbttagcompound.func_74768_a("s" + i, this.m_sideBlockTypes[i]);
            nbttagcompound.func_74757_a("c" + i, this.m_forceObserved[i]);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        switch (packet.func_148853_f()) {
            case 0: {
                int oldSide = this.m_currentDisplayedSide;
                int oldType = this.getObservedType();
                NBTTagCompound nbttagcompound = packet.func_148857_g();
                this.func_145839_a(nbttagcompound);
                int newType = this.getObservedType();
                if (newType == oldType && oldSide >= 0) break;
                this.m_timeSinceLastChange = 0;
                this.blockUpdate();
                break;
            }
        }
    }
}

