/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public class EntanglementRegistry<T> {
    private int m_nextUnusedFrequency = 1;
    private Map<Integer, List<T>> m_entanglements = new HashMap<Integer, List<T>>();

    public void reset() {
        this.m_nextUnusedFrequency = 1;
        this.m_entanglements.clear();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.m_nextUnusedFrequency = nbt.func_74762_e("nextUnusedFrequency");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("nextUnusedFrequency", this.m_nextUnusedFrequency);
    }

    public int getUnusedFrequency() {
        int freq = this.m_nextUnusedFrequency++;
        return freq;
    }

    public void register(int frequency, T entangledObject) {
        if (!this.m_entanglements.containsKey(frequency)) {
            this.m_entanglements.put(frequency, new ArrayList());
            if (frequency >= this.m_nextUnusedFrequency) {
                this.m_nextUnusedFrequency = frequency + 1;
            }
        }
        this.m_entanglements.get(frequency).add(entangledObject);
    }

    public void unregister(int frequency, T entangledObject) {
        if (this.m_entanglements.containsKey(frequency)) {
            this.m_entanglements.get(frequency).remove(entangledObject);
        }
    }

    public List<T> getEntangledObjects(int frequency) {
        return this.m_entanglements.get(frequency);
    }
}

