/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.client;

import dan200.QCraft;
import dan200.qcraft.shared.ContainerQuantumComputer;
import dan200.qcraft.shared.TileEntityQuantumComputer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiQuantumComputer
extends GuiContainer {
    private static final ResourceLocation background = new ResourceLocation("qcraft", "textures/gui/computer.png");
    private static final int BUTTON_ENERGIZE = 1;
    private static final int BUTTON_CYCLE_SERVERS = 2;
    private static final int BUTTON_ADD_SERVER = 3;
    private static final int BUTTON_REMOVE_SERVER = 4;
    private static final int BUTTON_CONFIRM_ADD_SERVER = 5;
    private ContainerQuantumComputer m_container;
    private TileEntityQuantumComputer m_computer;
    private boolean m_addingServer;
    private boolean m_newServerAddressFieldNeedsFocus;
    private GuiButton m_energizeButton;
    private GuiButton m_energizeButton2;
    private GuiTextField m_localPortalIDField;
    private GuiButton m_changeServerButton;
    private GuiButton m_addServerButton;
    private GuiButton m_removeServerButton;
    private GuiButton m_confirmAddServerButton;
    private GuiTextField m_destinationPortalIDField;
    private GuiTextField m_newServerAddressField;

    public GuiQuantumComputer(InventoryPlayer inventoryplayer, TileEntityQuantumComputer computer) {
        this(inventoryplayer, computer, new ContainerQuantumComputer(inventoryplayer, computer));
    }

    protected GuiQuantumComputer(InventoryPlayer inventoryplayer, TileEntityQuantumComputer computer, ContainerQuantumComputer container) {
        super((Container)container);
        this.m_container = container;
        this.m_computer = computer;
        this.m_addingServer = false;
        this.m_newServerAddressFieldNeedsFocus = false;
        this.field_146999_f = 196;
        this.field_147000_g = 36;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.m_energizeButton = new GuiButton(1, x + 8, y + 8, this.field_146999_f - 16, 20, "");
        this.m_energizeButton2 = new GuiButton(1, x + 8, y + 8 + 8 + 20 + 6 + 20 + 6, this.field_146999_f - 16, 20, "");
        this.m_localPortalIDField = new GuiTextField(this.field_146289_q, x + 9, y - 20, this.field_146999_f - 18, 20);
        this.m_localPortalIDField.func_146195_b(false);
        this.m_localPortalIDField.func_146203_f(32);
        this.m_localPortalIDField.func_146180_a(this.encodeOptionalText(this.m_computer.getPortalID()));
        this.m_destinationPortalIDField = new GuiTextField(this.field_146289_q, x + 9, y + 8 + 8, this.field_146999_f - 18, 20);
        this.m_destinationPortalIDField.func_146195_b(false);
        this.m_destinationPortalIDField.func_146203_f(32);
        this.m_destinationPortalIDField.func_146180_a(this.encodeOptionalText(this.m_computer.getRemotePortalID()));
        this.m_changeServerButton = new GuiButton(2, x + 8, y + 8 + 8 + 20 + 6, this.field_146999_f - 16 - 16 - 3 - 16 - 3, 20, "");
        this.m_addServerButton = new GuiButton(3, x + this.field_146999_f - 8 - 16 - 3 - 16, y + 8 + 8 + 20 + 6, 16, 20, "+");
        this.m_removeServerButton = new GuiButton(4, x + this.field_146999_f - 8 - 16, y + 8 + 8 + 20 + 6, 16, 20, "-");
        this.m_confirmAddServerButton = new GuiButton(5, x + this.field_146999_f - 8 - 35, y + 8 + 8 + 20 + 6, 35, 20, I18n.func_135052_a((String)"gui.qcraft:computer.ok", (Object[])new Object[0]));
        this.m_newServerAddressField = new GuiTextField(this.field_146289_q, x + 9, y + 8 + 8 + 20 + 7, this.field_146999_f - 18 - 35 - 3, 18);
        this.m_newServerAddressField.func_146195_b(false);
        this.m_newServerAddressField.func_146203_f(64);
        this.m_newServerAddressField.func_146180_a(this.encodeOptionalText(this.m_computer.getRemoteServerAddress()));
        this.updateStatus();
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void updateStatus() {
        boolean isTeleporter = this.m_container.isTeleporterPresent();
        boolean canEnergize = this.m_container.canEnergize();
        boolean canEdit = isTeleporter && this.m_container.canEdit();
        boolean canEditIP = canEdit && this.m_container.canEditServerAddress();
        String errorMsg = this.m_container.getErrorMessage();
        if (errorMsg != null) {
            this.m_energizeButton.field_146124_l = false;
            this.m_energizeButton.field_146126_j = I18n.func_135052_a((String)errorMsg, (Object[])new Object[0]);
        } else {
            this.m_energizeButton.field_146124_l = canEnergize && !this.m_addingServer;
            this.m_energizeButton.field_146126_j = !this.m_container.isTeleporterEnergized() ? I18n.func_135052_a((String)"gui.qcraft:computer.energize", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.qcraft:computer.deenergize", (Object[])new Object[0]);
        }
        this.m_energizeButton2.field_146124_l = this.m_energizeButton.field_146124_l;
        this.m_energizeButton2.field_146126_j = this.m_energizeButton.field_146126_j;
        if (isTeleporter) {
            if (this.field_146292_n.contains(this.m_energizeButton)) {
                this.field_146292_n.remove(this.m_energizeButton);
            }
            if (!this.field_146292_n.contains(this.m_energizeButton2)) {
                this.field_146292_n.add(this.m_energizeButton2);
            }
            if (this.m_addingServer) {
                if (this.field_146292_n.contains(this.m_changeServerButton)) {
                    this.field_146292_n.remove(this.m_changeServerButton);
                }
                if (this.field_146292_n.contains(this.m_addServerButton)) {
                    this.field_146292_n.remove(this.m_addServerButton);
                }
                if (this.field_146292_n.contains(this.m_removeServerButton)) {
                    this.field_146292_n.remove(this.m_removeServerButton);
                }
                if (!this.field_146292_n.contains(this.m_confirmAddServerButton)) {
                    this.field_146292_n.add(this.m_confirmAddServerButton);
                }
            } else {
                if (!this.field_146292_n.contains(this.m_changeServerButton)) {
                    this.field_146292_n.add(this.m_changeServerButton);
                }
                if (!this.field_146292_n.contains(this.m_addServerButton)) {
                    this.field_146292_n.add(this.m_addServerButton);
                }
                if (!this.field_146292_n.contains(this.m_removeServerButton)) {
                    this.field_146292_n.add(this.m_removeServerButton);
                }
                if (this.field_146292_n.contains(this.m_confirmAddServerButton)) {
                    this.field_146292_n.remove(this.m_confirmAddServerButton);
                }
            }
        } else {
            if (!this.field_146292_n.contains(this.m_energizeButton)) {
                this.field_146292_n.add(this.m_energizeButton);
            }
            if (this.field_146292_n.contains(this.m_energizeButton2)) {
                this.field_146292_n.remove(this.m_energizeButton2);
            }
            if (this.field_146292_n.contains(this.m_changeServerButton)) {
                this.field_146292_n.remove(this.m_changeServerButton);
            }
            if (this.field_146292_n.contains(this.m_addServerButton)) {
                this.field_146292_n.remove(this.m_addServerButton);
            }
            if (this.field_146292_n.contains(this.m_removeServerButton)) {
                this.field_146292_n.remove(this.m_removeServerButton);
            }
            if (this.field_146292_n.contains(this.m_confirmAddServerButton)) {
                this.field_146292_n.remove(this.m_confirmAddServerButton);
            }
        }
        this.m_localPortalIDField.func_146189_e(isTeleporter);
        this.m_localPortalIDField.func_146184_c(canEdit);
        if (!this.m_localPortalIDField.func_146206_l()) {
            this.m_localPortalIDField.func_146180_a(this.encodeOptionalText(this.m_computer.getPortalID()));
        }
        this.m_changeServerButton.field_146124_l = canEdit && !this.m_addingServer;
        String remoteServerName = this.m_computer.getRemoteServerName();
        if (remoteServerName != null) {
            int lengthLimit = 20;
            this.m_changeServerButton.field_146126_j = remoteServerName.length() <= lengthLimit ? I18n.func_135052_a((String)"gui.qcraft:computer.remote_server", (Object[])new Object[]{remoteServerName}) : I18n.func_135052_a((String)"gui.qcraft:computer.remote_server", (Object[])new Object[]{remoteServerName.substring(0, lengthLimit - 2) + "..."});
        } else {
            this.m_changeServerButton.field_146126_j = I18n.func_135052_a((String)"gui.qcraft:computer.local_server", (Object[])new Object[0]);
        }
        this.m_addServerButton.field_146124_l = canEditIP && !this.m_addingServer;
        this.m_removeServerButton.field_146124_l = canEditIP && !this.m_addingServer && this.m_computer.getRemoteServerAddress() != null;
        this.m_confirmAddServerButton.field_146124_l = isTeleporter && this.m_addingServer;
        this.m_destinationPortalIDField.func_146189_e(isTeleporter);
        this.m_destinationPortalIDField.func_146184_c(canEdit);
        if (!this.m_destinationPortalIDField.func_146206_l()) {
            this.m_destinationPortalIDField.func_146180_a(this.encodeOptionalText(this.m_computer.getRemotePortalID()));
        }
        this.m_newServerAddressField.func_146189_e(isTeleporter && this.m_addingServer);
        this.m_newServerAddressField.func_146184_c(isTeleporter && this.m_addingServer);
        if (this.m_newServerAddressFieldNeedsFocus) {
            this.m_localPortalIDField.func_146195_b(false);
            this.m_destinationPortalIDField.func_146195_b(false);
            this.m_newServerAddressField.func_146195_b(true);
            this.m_newServerAddressFieldNeedsFocus = false;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.m_localPortalIDField.func_146178_a();
        this.m_destinationPortalIDField.func_146178_a();
        this.m_newServerAddressField.func_146178_a();
        this.updateStatus();
    }

    private String encodeOptionalText(String id) {
        if (id == null) {
            return "";
        }
        return id;
    }

    private String decodeOptionalText(String text) {
        if ((text = text.trim()).isEmpty()) {
            return null;
        }
        return text;
    }

    private void updateRemotePortalID() {
        QCraft.requestSetRemotePortalID(this.m_computer, this.decodeOptionalText(this.m_destinationPortalIDField.func_146179_b()));
    }

    private void updatePortalID() {
        QCraft.requestSetPortalID(this.m_computer, this.decodeOptionalText(this.m_localPortalIDField.func_146179_b()));
    }

    public void func_73869_a(char c, int k) {
        if (k == 1) {
            if (this.m_addingServer) {
                this.m_addingServer = false;
                this.updateStatus();
            } else {
                super.func_73869_a(c, k);
            }
        } else if (this.m_localPortalIDField.func_146206_l()) {
            this.m_localPortalIDField.func_146201_a(c, k);
            this.updatePortalID();
        } else if (this.m_destinationPortalIDField.func_146206_l()) {
            this.m_destinationPortalIDField.func_146201_a(c, k);
            this.updateRemotePortalID();
        } else if (this.m_newServerAddressField.func_146206_l()) {
            this.m_newServerAddressField.func_146201_a(c, k);
        } else {
            super.func_73869_a(c, k);
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.m_localPortalIDField.func_146192_a(par1, par2, par3);
        this.m_destinationPortalIDField.func_146192_a(par1, par2, par3);
        this.m_newServerAddressField.func_146192_a(par1, par2, par3);
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 1: {
                QCraft.requestEnergize(this.m_computer);
                break;
            }
            case 2: {
                if (!this.m_container.canEdit()) break;
                QCraft.requestCycleServerAddress(this.m_computer);
                break;
            }
            case 3: {
                if (!this.m_container.canEditServerAddress() || this.m_addingServer) break;
                this.m_newServerAddressField.func_146180_a("");
                this.m_addingServer = true;
                this.m_newServerAddressFieldNeedsFocus = true;
                break;
            }
            case 4: {
                if (!this.m_container.canEditServerAddress() || this.m_addingServer) break;
                QCraft.requestRemoveServerAddress(this.m_computer);
                break;
            }
            case 5: {
                if (!this.m_addingServer) break;
                String name = null;
                String address = null;
                String both = this.decodeOptionalText(this.m_newServerAddressField.func_146179_b());
                if (both != null) {
                    int pipeIndex = both.indexOf("|");
                    if (pipeIndex >= 0) {
                        address = this.decodeOptionalText(both.substring(0, pipeIndex));
                        name = this.decodeOptionalText(both.substring(pipeIndex + 1));
                        if (name == null) {
                            name = address;
                        }
                        if (address == null) {
                            name = null;
                        }
                    } else {
                        name = both;
                        address = both;
                    }
                }
                QCraft.requestSetNewServerAddress(this.m_computer, name, address);
                this.m_addingServer = false;
            }
        }
    }

    public void func_73863_a(int i, int j, float f) {
        super.func_73863_a(i, j, f);
        this.m_localPortalIDField.func_146194_f();
        this.m_destinationPortalIDField.func_146194_f();
        this.m_newServerAddressField.func_146194_f();
    }

    protected void func_146979_b(int i, int j) {
        super.func_146979_b(i, j);
        if (this.m_container.isTeleporterPresent()) {
            String text = I18n.func_135052_a((String)"gui.qcraft:computer.local_portal", (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(text, 9, -31, 0x404040);
            String text2 = I18n.func_135052_a((String)"gui.qcraft:computer.remote_portal", (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(text2, 9, 5, 0x404040);
        }
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(background);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (!this.m_container.isTeleporterPresent()) {
            this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        } else {
            this.func_73729_b(x, y - 20 - 3 - 8 - 8, 0, 36, this.field_146999_f, 135);
        }
    }
}

