/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import dan200.QCraft;
import dan200.qcraft.client.EntityQuantumDustFX;
import dan200.qcraft.client.GuiItemTransfer;
import dan200.qcraft.client.GuiQuantumComputer;
import dan200.qcraft.client.GuiTravelStandby;
import dan200.qcraft.shared.BlockQBlock;
import dan200.qcraft.shared.BlockQuantumLogic;
import dan200.qcraft.shared.ItemQBlock;
import dan200.qcraft.shared.ItemQuantumGoggles;
import dan200.qcraft.shared.LostLuggage;
import dan200.qcraft.shared.QCraftProxyCommon;
import dan200.qcraft.shared.TileEntityQuantumComputer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class QCraftProxyClient
extends QCraftProxyCommon {
    private static final ResourceLocation QUANTUM_GOGGLE_HUD = new ResourceLocation("qcraft", "textures/gui/goggles.png");
    private static final ResourceLocation AO_GOGGLE_HUD = new ResourceLocation("qcraft", "textures/gui/ao_goggles.png");
    private long m_tickCount = 0L;
    private RenderBlocks m_renderBlocks;

    @Override
    public void load() {
        int gateID;
        ItemQuantumGoggles.s_renderIndex = RenderingRegistry.addNewArmourRendererPrefix((String)"qcraft:goggles");
        super.load();
        QCraft.Blocks.quantumLogic.blockRenderID = gateID = RenderingRegistry.getNextAvailableRenderId();
        this.m_renderBlocks = new RenderBlocks();
        QCraft.Blocks.qBlock.blockRenderID = RenderingRegistry.getNextAvailableRenderId();
        this.registerForgeHandlers();
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public Object getQuantumComputerGUI(InventoryPlayer inventory, TileEntityQuantumComputer computer) {
        return new GuiQuantumComputer(inventory, computer);
    }

    @Override
    public void showItemTransferGUI(EntityPlayer entityPlayer, TileEntityQuantumComputer computer) {
        if (Minecraft.func_71410_x().field_71462_r == null) {
            FMLClientHandler.instance().displayGuiScreen(entityPlayer, (GuiScreen)new GuiItemTransfer(computer));
        }
    }

    @Override
    public void travelToServer(LostLuggage.Address address) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71441_e.func_72882_A();
        minecraft.func_71403_a((WorldClient)null);
        minecraft.func_147108_a((GuiScreen)new GuiTravelStandby(address));
    }

    @Override
    public void spawnQuantumDustFX(World world, double x, double y, double z) {
        Minecraft mc = Minecraft.func_71410_x();
        double dx = mc.field_71451_h.field_70165_t - x;
        double dy = mc.field_71451_h.field_70163_u - y;
        double dz = mc.field_71451_h.field_70161_v - z;
        if (dx * dx + dy * dy + dz * dz < 256.0) {
            EntityQuantumDustFX fx = new EntityQuantumDustFX(world, x, y, z, 1.0f);
            mc.field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public EntityPlayer getLocalPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean isLocalPlayerWearingGoggles() {
        EntityPlayer player = this.getLocalPlayer();
        if (player != null) {
            return this.isPlayerWearingGoggles(player);
        }
        return false;
    }

    @Override
    public boolean isLocalPlayerWearingQuantumGoggles() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            return this.isPlayerWearingQuantumGoggles((EntityPlayer)player);
        }
        return false;
    }

    private void registerForgeHandlers() {
        ForgeHandlers handlers = new ForgeHandlers();
        MinecraftForge.EVENT_BUS.register((Object)handlers);
        FMLCommonHandler.instance().bus().register((Object)handlers);
        QuantumLogicBlockRenderingHandler logicHandler = new QuantumLogicBlockRenderingHandler();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)logicHandler);
        QBlockRenderingHandler qBlockHandler = new QBlockRenderingHandler();
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)QCraft.Blocks.qBlock), (IItemRenderer)qBlockHandler);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)qBlockHandler);
    }

    private void renderInventoryQBlock(RenderBlocks renderblocks, BlockQBlock block, ItemStack item) {
        int[] types = ItemQBlock.getTypes(item);
        int type = this.cycleType(types);
        if (type < 0) {
            this.renderInventoryQBlock(renderblocks, block, 0, BlockQBlock.Appearance.Fuzz);
        } else {
            this.renderInventoryQBlock(renderblocks, block, type, BlockQBlock.Appearance.Block);
        }
    }

    private int cycleType(int[] types) {
        int type = -99;
        int cycle = (int)(this.m_tickCount % 120L);
        int subcycle = cycle % 20;
        if (subcycle > 5) {
            type = types[cycle / 20];
        }
        return type;
    }

    private void bindColor(int c) {
        float r = (float)(c >> 16 & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
    }

    private void renderInventoryQBlock(RenderBlocks renderblocks, BlockQBlock block, int type, BlockQBlock.Appearance appearance) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        this.bindColor(block.getColorForType(0, type));
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderblocks.func_147768_a((Block)block, 0.0, 0.0, 0.0, block.getIconForType(0, type, appearance));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        this.bindColor(block.getColorForType(1, type));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderblocks.func_147806_b((Block)block, 0.0, 0.0, 0.0, block.getIconForType(1, type, appearance));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        this.bindColor(block.getColorForType(2, type));
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderblocks.func_147761_c((Block)block, 0.0, 0.0, 0.0, block.getIconForType(2, type, appearance));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        this.bindColor(block.getColorForType(3, type));
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderblocks.func_147734_d((Block)block, 0.0, 0.0, 0.0, block.getIconForType(3, type, appearance));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        this.bindColor(block.getColorForType(4, type));
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderblocks.func_147798_e((Block)block, 0.0, 0.0, 0.0, block.getIconForType(4, type, appearance));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        this.bindColor(block.getColorForType(5, type));
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderblocks.func_147764_f((Block)block, 0.0, 0.0, 0.0, block.getIconForType(5, type, appearance));
        tessellator.func_78381_a();
    }

    @Override
    public void renderQuantumGogglesOverlay(float width, float height) {
        this.renderOverlay(QUANTUM_GOGGLE_HUD, width, height);
    }

    @Override
    public void renderAOGogglesOverlay(float width, float height) {
        this.renderOverlay(AO_GOGGLE_HUD, width, height);
    }

    private void renderOverlay(ResourceLocation texture, float width, float height) {
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        mc.field_71446_o.func_110577_a(texture);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)height, -90.0, 0.0, 1.0);
        tessellator.func_78374_a((double)width, (double)height, -90.0, 1.0, 1.0);
        tessellator.func_78374_a((double)width, 0.0, -90.0, 1.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private class QBlockRenderingHandler
    implements IItemRenderer,
    ISimpleBlockRenderingHandler {
        public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
            switch (type) {
                case ENTITY: 
                case EQUIPPED: 
                case EQUIPPED_FIRST_PERSON: 
                case INVENTORY: {
                    return true;
                }
            }
            return false;
        }

        public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
            switch (helper) {
                case ENTITY_ROTATION: 
                case ENTITY_BOBBING: 
                case EQUIPPED_BLOCK: 
                case BLOCK_3D: 
                case INVENTORY_BLOCK: {
                    return true;
                }
            }
            return false;
        }

        public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object[] data) {
            switch (type) {
                case ENTITY: 
                case INVENTORY: {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                    QCraft.Blocks.qBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    QCraftProxyClient.this.m_renderBlocks.func_147775_a((Block)QCraft.Blocks.qBlock);
                    QCraftProxyClient.this.renderInventoryQBlock(QCraftProxyClient.this.m_renderBlocks, QCraft.Blocks.qBlock, item);
                    GL11.glPopMatrix();
                    break;
                }
                case EQUIPPED: 
                case EQUIPPED_FIRST_PERSON: {
                    GL11.glPushMatrix();
                    QCraft.Blocks.qBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    QCraftProxyClient.this.m_renderBlocks.func_147775_a((Block)QCraft.Blocks.qBlock);
                    QCraftProxyClient.this.renderInventoryQBlock(QCraftProxyClient.this.m_renderBlocks, QCraft.Blocks.qBlock, item);
                    GL11.glPopMatrix();
                    break;
                }
            }
        }

        public boolean shouldRender3DInInventory(int modelID) {
            return true;
        }

        public int getRenderId() {
            return QCraft.Blocks.qBlock.blockRenderID;
        }

        public boolean renderWorldBlock(IBlockAccess world, int i, int j, int k, Block block, int modelID, RenderBlocks renderblocks) {
            if (modelID == this.getRenderId() && block == QCraft.Blocks.qBlock) {
                BlockQBlock.s_forceGrass = QCraft.Blocks.qBlock.getImpostorBlock(world, i, j, k) == Blocks.field_150349_c;
                QCraft.Blocks.qBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                renderblocks.func_147775_a((Block)QCraft.Blocks.qBlock);
                renderblocks.func_147784_q((Block)QCraft.Blocks.qBlock, i, j, k);
                BlockQBlock.s_forceGrass = false;
                return true;
            }
            return false;
        }

        public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderblocks) {
        }
    }

    private class QuantumLogicBlockRenderingHandler
    implements ISimpleBlockRenderingHandler {
        public boolean shouldRender3DInInventory(int modelID) {
            return false;
        }

        public int getRenderId() {
            return QCraft.Blocks.quantumLogic.blockRenderID;
        }

        public boolean renderWorldBlock(IBlockAccess world, int i, int j, int k, Block block, int modelID, RenderBlocks renderblocks) {
            if (modelID == QCraft.Blocks.quantumLogic.blockRenderID) {
                int metadata = world.func_72805_g(i, j, k);
                int direction = BlockDirectional.func_149895_l((int)metadata);
                int subType = ((BlockQuantumLogic)block).getSubType(metadata);
                switch (direction) {
                    case 0: {
                        renderblocks.field_147867_u = 0;
                        break;
                    }
                    case 1: {
                        renderblocks.field_147867_u = 1;
                        break;
                    }
                    case 2: {
                        renderblocks.field_147867_u = 3;
                        break;
                    }
                    case 3: {
                        renderblocks.field_147867_u = 2;
                    }
                }
                renderblocks.func_147775_a(block);
                renderblocks.func_147784_q(block, i, j, k);
                renderblocks.field_147867_u = 0;
                return true;
            }
            return false;
        }

        public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderblocks) {
        }
    }

    public class ForgeHandlers {
        @SubscribeEvent
        public void handleTick(TickEvent.ClientTickEvent clientTickEvent) {
            if (clientTickEvent.phase == TickEvent.Phase.START) {
                QCraftProxyClient.this.m_tickCount++;
            }
            if (QCraft.travelNextTick != null) {
                QCraftProxyClient.this.travelToServer(QCraft.travelNextTick);
                QCraft.travelNextTick = null;
            }
        }
    }
}

