/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import dan200.QCraft;
import dan200.qcraft.shared.IQuantumObservable;
import dan200.qcraft.shared.ItemQBlock;
import dan200.qcraft.shared.TileEntityQBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCompressedPowered;
import net.minecraft.block.BlockSand;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockQBlock
extends BlockSand
implements ITileEntityProvider,
IQuantumObservable {
    public int blockRenderID;
    private static IIcon s_transparentIcon;
    private static IIcon s_swirlIcon;
    private static IIcon s_fuzzIcon;
    private static ItemStack[] s_impostorBlocks;
    public static boolean s_forceGrass;

    public static ItemStack[] getImpostorBlockList() {
        if (s_impostorBlocks == null) {
            s_impostorBlocks = new ItemStack[]{null, new ItemStack(Blocks.field_150348_b, 1, 0), new ItemStack((Block)Blocks.field_150349_c, 1, 0), new ItemStack(Blocks.field_150346_d, 1, 0), new ItemStack(Blocks.field_150357_h, 1, 0), new ItemStack((Block)Blocks.field_150354_m, 1, 0), new ItemStack(Blocks.field_150351_n, 1, 0), new ItemStack(Blocks.field_150352_o, 1, 0), new ItemStack(Blocks.field_150366_p, 1, 0), new ItemStack(Blocks.field_150365_q, 1, 0), new ItemStack(Blocks.field_150364_r, 1, 0), new ItemStack(Blocks.field_150369_x, 1, 0), new ItemStack(Blocks.field_150322_A, 1, 0), new ItemStack(Blocks.field_150482_ag, 1, 0), new ItemStack(Blocks.field_150450_ax, 1, 0), new ItemStack(Blocks.field_150412_bA, 1, 0), new ItemStack(Blocks.field_150432_aD, 1, 0), new ItemStack(Blocks.field_150435_aG, 1, 0), new ItemStack(Blocks.field_150423_aK, 1, 0), new ItemStack(Blocks.field_150440_ba, 1, 0), new ItemStack((Block)Blocks.field_150391_bh, 1, 0), new ItemStack(Blocks.field_150343_Z, 1, 0), new ItemStack(Blocks.field_150347_e, 1, 0), new ItemStack(Blocks.field_150344_f, 1, 0), new ItemStack(Blocks.field_150342_X, 1, 0), new ItemStack(Blocks.field_150341_Y, 1, 0), new ItemStack(Blocks.field_150424_aL, 1, 0), new ItemStack(Blocks.field_150425_aM, 1, 0), new ItemStack(Blocks.field_150426_aN, 1, 0), new ItemStack(Blocks.field_150377_bs, 1, 0), new ItemStack(Blocks.field_150339_S, 1, 0), new ItemStack(Blocks.field_150340_R, 1, 0), new ItemStack(Blocks.field_150484_ah, 1, 0), new ItemStack(Blocks.field_150368_y, 1, 0), new ItemStack(Blocks.field_150325_L, 1, 0), new ItemStack(Blocks.field_150359_w, 1, 0), new ItemStack(Blocks.field_150325_L, 1, 1), new ItemStack(Blocks.field_150325_L, 1, 2), new ItemStack(Blocks.field_150325_L, 1, 3), new ItemStack(Blocks.field_150325_L, 1, 4), new ItemStack(Blocks.field_150325_L, 1, 5), new ItemStack(Blocks.field_150325_L, 1, 6), new ItemStack(Blocks.field_150325_L, 1, 7), new ItemStack(Blocks.field_150325_L, 1, 8), new ItemStack(Blocks.field_150325_L, 1, 9), new ItemStack(Blocks.field_150325_L, 1, 10), new ItemStack(Blocks.field_150325_L, 1, 11), new ItemStack(Blocks.field_150325_L, 1, 12), new ItemStack(Blocks.field_150325_L, 1, 13), new ItemStack(Blocks.field_150325_L, 1, 14), new ItemStack(Blocks.field_150325_L, 1, 15), new ItemStack(Blocks.field_150364_r, 1, 1), new ItemStack(Blocks.field_150364_r, 1, 2), new ItemStack(Blocks.field_150364_r, 1, 3), new ItemStack(Blocks.field_150344_f, 1, 1), new ItemStack(Blocks.field_150344_f, 1, 2), new ItemStack(Blocks.field_150344_f, 1, 3), new ItemStack(Blocks.field_150322_A, 1, 1), new ItemStack(Blocks.field_150322_A, 1, 2), new ItemStack(Blocks.field_150417_aV, 1, 0), new ItemStack(Blocks.field_150417_aV, 1, 1), new ItemStack(Blocks.field_150417_aV, 1, 2), new ItemStack(Blocks.field_150417_aV, 1, 3), new ItemStack(Blocks.field_150385_bj, 1, 0), new ItemStack(Blocks.field_150336_V, 1, 0), new ItemStack(Blocks.field_150451_bX, 1, 0), new ItemStack(Blocks.field_150449_bY, 1, 0), new ItemStack(Blocks.field_150371_ca, 1, 0), new ItemStack(Blocks.field_150371_ca, 1, 1), new ItemStack(Blocks.field_150371_ca, 1, 2), new ItemStack(Blocks.field_150406_ce, 1, 0), new ItemStack(Blocks.field_150406_ce, 1, 1), new ItemStack(Blocks.field_150406_ce, 1, 2), new ItemStack(Blocks.field_150406_ce, 1, 3), new ItemStack(Blocks.field_150406_ce, 1, 4), new ItemStack(Blocks.field_150406_ce, 1, 5), new ItemStack(Blocks.field_150406_ce, 1, 6), new ItemStack(Blocks.field_150406_ce, 1, 7), new ItemStack(Blocks.field_150406_ce, 1, 8), new ItemStack(Blocks.field_150406_ce, 1, 9), new ItemStack(Blocks.field_150406_ce, 1, 10), new ItemStack(Blocks.field_150406_ce, 1, 11), new ItemStack(Blocks.field_150406_ce, 1, 12), new ItemStack(Blocks.field_150406_ce, 1, 13), new ItemStack(Blocks.field_150406_ce, 1, 14), new ItemStack(Blocks.field_150406_ce, 1, 15), new ItemStack(Blocks.field_150407_cf, 1, 0), new ItemStack(Blocks.field_150405_ch, 1, 0), new ItemStack(Blocks.field_150402_ci, 1, 0), new ItemStack(Blocks.field_150363_s, 1, 0), new ItemStack(Blocks.field_150363_s, 1, 1), new ItemStack(Blocks.field_150346_d, 1, 2), new ItemStack(Blocks.field_150344_f, 1, 4), new ItemStack(Blocks.field_150344_f, 1, 5), new ItemStack((Block)Blocks.field_150354_m, 1, 1), new ItemStack(Blocks.field_150403_cj, 1, 0), new ItemStack((Block)Blocks.field_150399_cn, 1, 0), new ItemStack((Block)Blocks.field_150399_cn, 1, 1), new ItemStack((Block)Blocks.field_150399_cn, 1, 2), new ItemStack((Block)Blocks.field_150399_cn, 1, 3), new ItemStack((Block)Blocks.field_150399_cn, 1, 4), new ItemStack((Block)Blocks.field_150399_cn, 1, 5), new ItemStack((Block)Blocks.field_150399_cn, 1, 6), new ItemStack((Block)Blocks.field_150399_cn, 1, 7), new ItemStack((Block)Blocks.field_150399_cn, 1, 8), new ItemStack((Block)Blocks.field_150399_cn, 1, 9), new ItemStack((Block)Blocks.field_150399_cn, 1, 10), new ItemStack((Block)Blocks.field_150399_cn, 1, 11), new ItemStack((Block)Blocks.field_150399_cn, 1, 12), new ItemStack((Block)Blocks.field_150399_cn, 1, 13), new ItemStack((Block)Blocks.field_150399_cn, 1, 14), new ItemStack((Block)Blocks.field_150399_cn, 1, 15)};
        }
        return s_impostorBlocks;
    }

    public BlockQBlock() {
        this.func_149647_a(QCraft.getCreativeTab());
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149663_c("qcraft:qblock");
    }

    public boolean func_149710_n() {
        return true;
    }

    public int getSubType(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public boolean isObserved(World world, int x, int y, int z, int side) {
        TileEntityQBlock qBlock;
        TileEntity entity = world.func_147438_o(x, y, z);
        return entity != null && entity instanceof TileEntityQBlock && (qBlock = (TileEntityQBlock)entity).isForceObserved(side);
    }

    @Override
    public void observe(World world, int x, int y, int z, int side) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null && entity instanceof TileEntityQBlock) {
            TileEntityQBlock qBlock = (TileEntityQBlock)entity;
            qBlock.setForceObserved(side, true);
        }
    }

    @Override
    public void reset(World world, int x, int y, int z, int side) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null && entity instanceof TileEntityQBlock) {
            TileEntityQBlock qBlock = (TileEntityQBlock)entity;
            qBlock.setForceObserved(side, false);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return true;
    }

    public int func_149645_b() {
        return this.blockRenderID;
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        Block block = this.getImpostorBlock(world, x, y, z);
        return block != null && !(block instanceof BlockCompressedPowered) && block != Blocks.field_150432_aD && block != Blocks.field_150403_cj && block != Blocks.field_150359_w && block != Blocks.field_150399_cn;
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        Block block = this.getImpostorBlock(world, x, y, z);
        if (block == Blocks.field_150349_c) {
            return block.func_149720_d(world, x, y, z);
        }
        return 0xFFFFFF;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB bigBox, List list, Entity entity) {
        AxisAlignedBB aabb;
        EntityPlayer player;
        boolean solid = false;
        int type = this.getImpostorType((IBlockAccess)world, x, y, z);
        if (type > 0) {
            solid = true;
        } else if (entity instanceof EntityPlayer && QCraft.isPlayerWearingQuantumGoggles(player = (EntityPlayer)entity)) {
            solid = true;
        }
        if (solid && (aabb = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0))) != null && aabb.func_72326_a(bigBox)) {
            list.add(aabb);
        }
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        Appearance appearance = this.getAppearance(world, x, y, z);
        int type = this.getImpostorType(world, x, y, z);
        if (appearance != Appearance.Block || type > 0) {
            super.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            super.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        Block block = this.getImpostorBlock((IBlockAccess)world, x, y, z);
        if (block != null) {
            return block.func_149712_f(world, x, y, z);
        }
        return 0.0f;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        Block block = this.getImpostorBlock((IBlockAccess)world, x, y, z);
        if (block != null) {
            return block.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
        }
        return 0.0f;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        Block block = this.getImpostorBlock(world, x, y, z);
        return block != null;
    }

    public boolean isAir(IBlockAccess world, int x, int y, int z) {
        Block block = this.getImpostorBlock(world, x, y, z);
        return block == null;
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        Block block = this.getImpostorBlock(world, x, y, z);
        if (block != null) {
            return block.canSustainLeaves(world, x, y, z);
        }
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        Block block = this.getImpostorBlock(world, x, y, z);
        return block == null;
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        Block block = this.getImpostorBlock(world, x, y, z);
        if (block != null) {
            return block.isWood(world, x, y, z);
        }
        return true;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        Block block = this.getImpostorBlock(world, x, y, z);
        if (block != null) {
            return block.getFlammability(world, x, y, z, face);
        }
        return 0;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        Block block = this.getImpostorBlock(world, x, y, z);
        if (block != null) {
            return block.isFlammable(world, x, y, z, face);
        }
        return false;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        Block block = this.getImpostorBlock(world, x, y, z);
        if (block != null) {
            return block.getFireSpreadSpeed(world, x, y, z, face);
        }
        return 0;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        Block block = this.getImpostorBlock((IBlockAccess)world, x, y, z);
        if (block != null) {
            return block.isFireSource(world, x, y, z, side);
        }
        return false;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        Block block = this.getImpostorBlock(world, x, y, z);
        if (block != null) {
            return block.getLightOpacity(world, x, y, z);
        }
        return 0;
    }

    public boolean isBeaconBase(IBlockAccess world, int x, int y, int z, int beaconX, int beaconY, int beaconZ) {
        Block block = this.getImpostorBlock(world, x, y, z);
        if (block != null) {
            return block.isBeaconBase(world, x, y, z, beaconX, beaconY, beaconZ);
        }
        return false;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        Block block = this.getImpostorBlock((IBlockAccess)world, x, y, z);
        if (block != null) {
            return block.getDrops(world, x, y, z, this.getImpostorDamage((IBlockAccess)world, x, y, z), fortune);
        }
        return new ArrayList<ItemStack>();
    }

    public void func_149690_a(World world, int i, int j, int k, int l, float f, int unknown) {
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (world.field_72995_K) {
            return false;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            if (EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
                TileEntity entity = world.func_147438_o(x, y, z);
                if (entity != null && entity instanceof TileEntityQBlock) {
                    TileEntityQBlock qblock = (TileEntityQBlock)entity;
                    ItemStack item = ItemQBlock.create(qblock.getSubType(), qblock.getTypes(), qblock.getEntanglementFrequency(), 1);
                    this.func_149642_a(world, x, y, z, item);
                }
            } else {
                int metadata;
                Block block = this.getImpostorBlock((IBlockAccess)world, x, y, z);
                if (block != null && block.canHarvestBlock(player, metadata = this.getImpostorDamage((IBlockAccess)world, x, y, z))) {
                    int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
                    ArrayList<ItemStack> items = this.getDrops(world, x, y, z, metadata, fortune);
                    for (ItemStack item : items) {
                        this.func_149642_a(world, x, y, z, item);
                    }
                }
            }
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null && entity instanceof TileEntityQBlock) {
            TileEntityQBlock qblock = (TileEntityQBlock)entity;
            return ItemQBlock.create(qblock.getSubType(), qblock.getTypes(), qblock.getEntanglementFrequency(), 1);
        }
        return null;
    }

    public boolean canHarvestBlock(EntityPlayer player, int metadata) {
        return true;
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int metadata) {
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int subType;
        int metadata = subType = stack.func_77960_j();
        world.func_72921_c(x, y, z, metadata, 3);
    }

    public void func_149674_a(World world, int x, int y, int z, Random r) {
        Block block = this.getImpostorBlock((IBlockAccess)world, x, y, z);
        if (block != null && block instanceof BlockSand) {
            super.func_149674_a(world, x, y, z, r);
        }
    }

    protected void func_149829_a(EntityFallingBlock entityFallingSand) {
        World world = entityFallingSand.field_70170_p;
        int x = (int)(entityFallingSand.field_70165_t - 0.5);
        int y = (int)(entityFallingSand.field_70163_u - 0.5);
        int z = (int)(entityFallingSand.field_70161_v - 0.5);
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null && entity instanceof TileEntityQBlock) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            entity.func_145841_b(nbttagcompound);
            entityFallingSand.field_145810_d = nbttagcompound;
        }
        entityFallingSand.field_145813_c = false;
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        Block block = this.getImpostorBlock(world, x, y, z);
        return block != null && block instanceof BlockCompressedPowered;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        Block block = this.getImpostorBlock(world, x, y, z);
        if (block != null && block instanceof BlockCompressedPowered) {
            return 15;
        }
        return 0;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        Block block = this.getImpostorBlock(world, x, y, z);
        if (block != null) {
            return block.func_149750_m();
        }
        return 0;
    }

    public int getColorForType(int side, int type) {
        if (type == 2) {
            return side == 1 ? Blocks.field_150349_c.func_149741_i(0) : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public IIcon getIconForType(int side, int type, Appearance appearance) {
        ItemStack item;
        if (appearance == Appearance.Swirl) {
            return s_swirlIcon;
        }
        if (appearance == Appearance.Fuzz) {
            return s_fuzzIcon;
        }
        ItemStack[] blockList = BlockQBlock.getImpostorBlockList();
        if (type >= 0 && type < blockList.length && (item = blockList[type]) != null) {
            Block block = ((ItemBlock)item.func_77973_b()).field_150939_a;
            int damage = item.func_77960_j();
            return block.func_149691_a(side, damage);
        }
        return s_transparentIcon;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int type = this.getImpostorType(world, x, y, z);
        Appearance appearance = this.getAppearance(world, x, y, z);
        return this.getIconForType(side, type, appearance);
    }

    public IIcon func_149691_a(int side, int damage) {
        if (s_forceGrass) {
            return Blocks.field_150349_c.func_149691_a(side, damage);
        }
        return s_swirlIcon;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        s_transparentIcon = iconRegister.func_94245_a("qcraft:transparent");
        s_swirlIcon = iconRegister.func_94245_a("qcraft:qblock_swirl");
        s_fuzzIcon = iconRegister.func_94245_a("qcraft:qblock_fuzz");
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityQBlock();
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return this.func_149915_a(world, metadata);
    }

    private Appearance getAppearance(IBlockAccess world, int x, int y, int z) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null && entity instanceof TileEntityQBlock) {
            TileEntityQBlock quantum = (TileEntityQBlock)entity;
            return quantum.getAppearance();
        }
        return Appearance.Fuzz;
    }

    private int getImpostorType(IBlockAccess world, int x, int y, int z) {
        TileEntity entity;
        int type = 0;
        if (y >= 0 && (entity = world.func_147438_o(x, y, z)) != null && entity instanceof TileEntityQBlock) {
            TileEntityQBlock quantum = (TileEntityQBlock)entity;
            type = quantum.getObservedType();
        }
        return type;
    }

    public Block getImpostorBlock(IBlockAccess world, int x, int y, int z) {
        ItemStack item;
        ItemStack[] blockList;
        int type = this.getImpostorType(world, x, y, z);
        if (type < (blockList = BlockQBlock.getImpostorBlockList()).length && (item = blockList[type]) != null) {
            return Block.func_149634_a((Item)item.func_77973_b());
        }
        return null;
    }

    private int getImpostorDamage(IBlockAccess world, int x, int y, int z) {
        ItemStack item;
        ItemStack[] blockList;
        int type = this.getImpostorType(world, x, y, z);
        if (type < (blockList = BlockQBlock.getImpostorBlockList()).length && (item = blockList[type]) != null) {
            return item.func_77960_j();
        }
        return 0;
    }

    static {
        s_forceGrass = false;
    }

    public static class SubType {
        public static final int Standard = 0;
        public static final int FiftyFifty = 1;
        public static final int Count = 2;
    }

    public static enum Appearance {
        Block,
        Fuzz,
        Swirl;

    }
}

