/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import dan200.qcraft.shared.QCraftProxyCommon;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class LostLuggage {
    public static final long MAX_LUGGAGE_AGE_HOURS = 24L;
    public static final LostLuggage Instance = new LostLuggage();
    private Set<Luggage> m_luggage = new HashSet<Luggage>();

    public void reset() {
        this.m_luggage.clear();
    }

    public void load() {
        File location = new File("./qcraft/luggage.bin");
        NBTTagCompound nbt = QCraftProxyCommon.loadNBTFromPath(location);
        if (nbt != null) {
            this.readFromNBT(nbt);
        } else {
            this.reset();
        }
    }

    public void save() {
        File location = new File("./qcraft/luggage.bin");
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        QCraftProxyCommon.saveNBTToPath(location, nbt);
    }

    private void readFromNBT(NBTTagCompound nbt) {
        this.m_luggage.clear();
        NBTTagList luggageList = nbt.func_150295_c("luggage", 10);
        for (int i = 0; i < luggageList.func_74745_c(); ++i) {
            NBTTagCompound luggageTag = luggageList.func_150305_b(i);
            Luggage luggage = new Luggage();
            luggage.m_timeStamp = luggageTag.func_74763_f("timeStamp");
            if (luggageTag.func_74764_b("originIP") && luggageTag.func_74764_b("originPort")) {
                luggage.m_origin = new Address(luggageTag.func_74779_i("originIP") + ":" + luggageTag.func_74762_e("originPort"));
            } else if (luggageTag.func_74764_b("originAddress")) {
                luggage.m_origin = new Address(luggageTag.func_74779_i("originAddress"));
            }
            if (luggageTag.func_74764_b("destinationIP") && luggageTag.func_74764_b("destinationPort")) {
                luggage.m_destination = new Address(luggageTag.func_74779_i("destinationIP") + ":" + luggageTag.func_74762_e("destinationPort"));
            } else if (luggageTag.func_74764_b("destinationAddress")) {
                luggage.m_destination = new Address(luggageTag.func_74779_i("destinationAddress"));
            }
            luggage.m_luggage = luggageTag.func_74770_j("luggage");
            this.m_luggage.add(luggage);
        }
    }

    private void writeToNBT(NBTTagCompound nbt) {
        NBTTagList luggageList = new NBTTagList();
        for (Luggage luggage : this.m_luggage) {
            NBTTagCompound luggageTag = new NBTTagCompound();
            luggageTag.func_74772_a("timeStamp", luggage.m_timeStamp);
            if (luggage.m_origin != null) {
                luggageTag.func_74778_a("originAddress", luggage.m_origin.getAddress());
            }
            if (luggage.m_destination != null) {
                luggageTag.func_74778_a("destinationAddress", luggage.m_destination.getAddress());
            }
            luggageTag.func_74773_a("luggage", luggage.m_luggage);
            luggageList.func_74742_a((NBTBase)luggageTag);
        }
        nbt.func_74782_a("luggage", (NBTBase)luggageList);
    }

    public void storeLuggage(Address origin, Address destination, byte[] luggageData) {
        Luggage luggage = new Luggage();
        luggage.m_timeStamp = System.currentTimeMillis();
        luggage.m_origin = origin;
        luggage.m_destination = destination;
        luggage.m_luggage = luggageData;
        this.m_luggage.add(luggage);
    }

    public void removeOldLuggage() {
        long timeNow = System.currentTimeMillis();
        Iterator<Luggage> it = this.m_luggage.iterator();
        while (it.hasNext()) {
            Luggage luggage = it.next();
            long ageMillis = timeNow - luggage.m_timeStamp;
            if (ageMillis < 86400000L) continue;
            it.remove();
        }
    }

    public Collection<LuggageMatch> getMatchingLuggage(Address server) {
        ArrayList<LuggageMatch> luggages = new ArrayList<LuggageMatch>();
        for (Luggage luggage : this.m_luggage) {
            if (server.equals(luggage.m_destination)) {
                luggages.add(new LuggageMatch(true, luggage.m_luggage, luggage.m_timeStamp));
                continue;
            }
            if (!server.equals(luggage.m_origin)) continue;
            luggages.add(new LuggageMatch(false, luggage.m_luggage, luggage.m_timeStamp));
        }
        return luggages;
    }

    public void removeLuggage(byte[] luggageData) {
        Iterator<Luggage> it = this.m_luggage.iterator();
        while (it.hasNext()) {
            Luggage luggage = it.next();
            if (!Arrays.equals(luggageData, luggage.m_luggage)) continue;
            it.remove();
        }
    }

    public static class LuggageMatch {
        public boolean m_matchedDestination;
        public byte[] m_luggage;
        public long m_timeStamp;

        public LuggageMatch(boolean matchedDestination, byte[] luggage, long timeStamp) {
            this.m_matchedDestination = matchedDestination;
            this.m_luggage = luggage;
            this.m_timeStamp = timeStamp;
        }
    }

    private static class Luggage {
        public long m_timeStamp;
        public Address m_origin;
        public Address m_destination;
        public byte[] m_luggage;

        private Luggage() {
        }
    }

    public static class Address {
        private final String m_address;

        public Address(String address) {
            this.m_address = address;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o != null && o instanceof Address) {
                Address other = (Address)o;
                return other.m_address.equals(this.m_address);
            }
            return false;
        }

        public String getAddress() {
            return this.m_address;
        }
    }
}

