/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import dan200.QCraft;
import dan200.qcraft.shared.IQuantumObservable;
import dan200.qcraft.shared.QuantumUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockQuantumLogic
extends BlockDirectional {
    public int blockRenderID;
    private IIcon[] m_icons;

    public int getSubType(int metadata) {
        return metadata >> 2 & 3;
    }

    protected BlockQuantumLogic() {
        super(Material.field_151594_q);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149663_c("qcraft:automatic_observer");
        this.func_149647_a(QCraft.getCreativeTab());
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return this.blockRenderID;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        if (World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
            return super.func_149742_c(world, x, y, z);
        }
        return false;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
            return super.func_149718_j(world, x, y, z);
        }
        return false;
    }

    public IIcon func_149673_e(IBlockAccess world, int i, int j, int k, int side) {
        int metadata = world.func_72805_g(i, j, k);
        int damage = this.getSubType(metadata);
        return this.func_149691_a(side, damage);
    }

    public IIcon func_149691_a(int side, int damage) {
        int subType = damage;
        if (side == 1 && damage >= 0 && damage < this.m_icons.length) {
            return this.m_icons[damage];
        }
        return Blocks.field_150334_T.func_149733_h(side);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        int direction = Direction.field_71580_e[BlockQuantumLogic.func_149895_l((int)metadata)];
        return side == direction;
    }

    public boolean func_149744_f() {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int metadata = world.func_72805_g(x, y, z);
        if (!this.func_149718_j(world, x, y, z)) {
            if (!world.field_72995_K) {
                this.func_149697_b(world, x, y, z, metadata, 0);
                world.func_147468_f(x, y, z);
            }
        } else {
            this.updateOutput(world, x, y, z);
        }
    }

    private void updateOutput(World world, int x, int y, int z) {
        int newSubType;
        if (world.field_72995_K) {
            return;
        }
        int metadata = world.func_72805_g(x, y, z);
        int direction = BlockQuantumLogic.func_149895_l((int)metadata);
        int subType = this.getSubType(metadata);
        int n = newSubType = this.evaluateInput(world, x, y, z) ? 1 : 0;
        if (newSubType != subType) {
            this.setDirectionAndSubType(world, x, y, z, direction, newSubType);
            subType = newSubType;
            world.func_147471_g(x, y, z);
            world.func_147459_d(x, y, z, (Block)this);
        }
        int facing = Facing.field_71588_a[Direction.field_71582_c[direction]];
        this.observe(world, x, y, z, facing, subType == 1);
    }

    private void setDirectionAndSubType(World world, int x, int y, int z, int direction, int subType) {
        int metadata = (direction & 3) + ((subType & 3) << 2);
        world.func_72921_c(x, y, z, metadata, 3);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int direction = ((MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) + 2) % 4;
        int subType = stack.func_77960_j();
        this.setDirectionAndSubType(world, x, y, z, direction, subType);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.updateOutput(world, x, y, z);
    }

    public void func_149664_b(World par1World, int par2, int par3, int par4, int par5) {
        super.func_149664_b(par1World, par2, par3, par4, par5);
    }

    public void func_149734_b(World world, int i, int j, int k, Random r) {
        if (!world.field_72995_K) {
            return;
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.m_icons = new IIcon[2];
        this.m_icons[0] = iconRegister.func_94245_a("qcraft:automatic_observer");
        this.m_icons[1] = iconRegister.func_94245_a("qcraft:automatic_observer_on");
    }

    private boolean evaluateInput(World world, int i, int j, int k) {
        int metadata = world.func_72805_g(i, j, k);
        int direction = Facing.field_71588_a[Direction.field_71582_c[BlockQuantumLogic.func_149895_l((int)metadata)]];
        int backDir = Facing.field_71588_a[direction];
        return this.getRedstoneSignal(world, i, j, k, backDir);
    }

    private boolean getRedstoneSignal(World world, int i, int j, int k, int dir) {
        int side = Facing.field_71588_a[dir];
        return QuantumUtil.getRedstoneSignal(world, i += Facing.field_71586_b[dir], j += Facing.field_71587_c[dir], k += Facing.field_71585_d[dir], side);
    }

    private void observe(World world, int i, int j, int k, int dir, boolean observe) {
        int side;
        IQuantumObservable observable;
        Block block = world.func_147439_a(i += Facing.field_71586_b[dir], j += Facing.field_71587_c[dir], k += Facing.field_71585_d[dir]);
        if (block != null && block instanceof IQuantumObservable && (observable = (IQuantumObservable)block).isObserved(world, i, j, k, side = Facing.field_71588_a[dir]) != observe) {
            if (observe) {
                observable.observe(world, i, j, k, side);
            } else {
                observable.reset(world, i, j, k, side);
            }
        }
    }

    public class SubType {
        public static final int ObserverOff = 0;
        public static final int ObserverOn = 1;
        public static final int Count = 2;
    }
}

