/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import dan200.QCraft;
import dan200.qcraft.shared.TileEntityQBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemQBlock
extends ItemBlock {
    public ItemQBlock(Block block) {
        super(block);
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77655_b("qcraft:odb");
        this.func_77637_a(QCraft.getCreativeTab());
    }

    public static ItemStack create(int subType, int[] types, int entanglementFrequency, int quantity) {
        ItemStack result = new ItemStack((Block)QCraft.Blocks.qBlock, quantity, subType);
        ItemQBlock.setTypes(result, types);
        ItemQBlock.setEntanglementFrequency(result, entanglementFrequency);
        return result;
    }

    public static int getSubType(ItemStack stack) {
        return stack.func_77960_j();
    }

    public static void setTypes(ItemStack stack, int[] types) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        for (int i = 0; i < types.length; ++i) {
            nbt.func_74768_a("s" + i, types[i]);
        }
    }

    public static int[] getTypes(ItemStack stack) {
        int[] types = new int[6];
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            for (int i = 0; i < types.length; ++i) {
                types[i] = nbt.func_74764_b("s" + i) ? nbt.func_74762_e("s" + i) : 0;
            }
        }
        return types;
    }

    public static boolean compareTypes(int[] left, int[] right) {
        for (int i = 0; i < 6; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    public static void setEntanglementFrequency(ItemStack stack, int entanglementFrequency) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (entanglementFrequency < 0) {
            if (nbt.func_74764_b("e")) {
                nbt.func_82580_o("e");
            }
            if (nbt.func_74764_b("R")) {
                nbt.func_82580_o("R");
            }
        } else if (entanglementFrequency == 0) {
            nbt.func_74768_a("e", entanglementFrequency);
            nbt.func_74768_a("R", TileEntityQBlock.s_random.nextInt(0xFFFFFF));
        } else {
            nbt.func_74768_a("e", entanglementFrequency);
            if (nbt.func_74764_b("R")) {
                nbt.func_82580_o("R");
            }
        }
    }

    public static int getEntanglementFrequency(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("e")) {
            return nbt.func_74762_e("e");
        }
        return -1;
    }

    public void func_150895_a(Item itemID, CreativeTabs tabs, List list) {
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (ItemQBlock.getEntanglementFrequency(stack) == 0 && !world.field_72995_K) {
            ItemQBlock.setEntanglementFrequency(stack, TileEntityQBlock.getEntanglementRegistry(world).getUnusedFrequency());
            player.field_71071_by.func_70296_d();
            if (player.field_71070_bA != null) {
                player.field_71070_bA.func_75142_b();
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            TileEntity entity = world.func_147438_o(x, y, z);
            if (entity != null && entity instanceof TileEntityQBlock) {
                TileEntityQBlock quantum = (TileEntityQBlock)entity;
                quantum.setTypes(ItemQBlock.getTypes(stack));
                quantum.setEntanglementFrequency(ItemQBlock.getEntanglementFrequency(stack));
            }
            return true;
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        boolean entangled = ItemQBlock.getEntanglementFrequency(stack) >= 0;
        switch (ItemQBlock.getSubType(stack)) {
            default: {
                return entangled ? "tile.qcraft:odb_entangled" : "tile.qcraft:odb";
            }
            case 1: 
        }
        return entangled ? "tile.qcraft:qb_entangled" : "tile.qcraft:qb";
    }

    public static String formatFrequency(int frequency) {
        String result = Integer.toHexString(frequency).toUpperCase();
        if (result.length() == 1) {
            return "0" + result;
        }
        return result;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        int frequency = ItemQBlock.getEntanglementFrequency(stack);
        if (frequency > 0) {
            list.add("Group: " + ItemQBlock.formatFrequency(frequency));
        }
    }
}

