/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;

public class QCraftPacket
implements IMessage {
    public static final byte EnergizeComputer = 1;
    public static final byte SetComputerRemotePortalID = 2;
    public static final byte SetComputerPortalID = 3;
    public static final byte GoToServer = 4;
    public static final byte RequestLuggage = 5;
    public static final byte UnpackLuggage = 6;
    public static final byte CycleServerAddress = 7;
    public static final byte SetNewServerAddress = 8;
    public static final byte RemoveServerAddress = 9;
    public static final byte QueryGoToServer = 10;
    public static final byte ConfirmGoToServer = 11;
    public static final byte DiscardLuggage = 12;
    public byte packetType = 0;
    public String[] dataString = null;
    public int[] dataInt = null;
    public byte[][] dataByte = null;

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte((int)this.packetType);
        if (this.dataString != null) {
            buffer.writeByte(this.dataString.length);
        } else {
            buffer.writeByte(0);
        }
        if (this.dataInt != null) {
            buffer.writeByte(this.dataInt.length);
        } else {
            buffer.writeByte(0);
        }
        if (this.dataByte != null) {
            buffer.writeInt(this.dataByte.length);
        } else {
            buffer.writeInt(0);
        }
        if (this.dataString != null) {
            for (String s : this.dataString) {
                if (s != null) {
                    try {
                        byte[] b = s.getBytes("UTF-8");
                        buffer.writeBoolean(true);
                        buffer.writeInt(b.length);
                        buffer.writeBytes(b);
                    }
                    catch (UnsupportedEncodingException e) {
                        buffer.writeBoolean(false);
                    }
                    continue;
                }
                buffer.writeBoolean(false);
            }
        }
        if (this.dataInt != null) {
            for (int i : this.dataInt) {
                buffer.writeInt(i);
            }
        }
        if (this.dataByte != null) {
            for (byte[] bytes : this.dataByte) {
                if (bytes != null) {
                    buffer.writeInt(bytes.length);
                    buffer.writeBytes(bytes);
                    continue;
                }
                buffer.writeInt(0);
            }
        }
    }

    public void fromBytes(ByteBuf buffer) {
        int k;
        this.packetType = buffer.readByte();
        int nString = buffer.readByte();
        int nInt = buffer.readByte();
        int nByte = buffer.readInt();
        if (nString == 0) {
            this.dataString = null;
        } else {
            this.dataString = new String[nString];
            for (k = 0; k < nString; ++k) {
                if (!buffer.readBoolean()) continue;
                int len = buffer.readInt();
                byte[] b = new byte[len];
                buffer.readBytes(b);
                try {
                    this.dataString[k] = new String(b, "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    this.dataString[k] = null;
                }
            }
        }
        if (nInt == 0) {
            this.dataInt = null;
        } else {
            this.dataInt = new int[nInt];
            for (k = 0; k < nInt; ++k) {
                this.dataInt[k] = buffer.readInt();
            }
        }
        if (nByte == 0) {
            this.dataByte = null;
        } else {
            this.dataByte = new byte[nByte][];
            for (k = 0; k < nByte; ++k) {
                int length = buffer.readInt();
                if (length <= 0) continue;
                this.dataByte[k] = new byte[length];
                buffer.getBytes(buffer.readerIndex(), this.dataByte[k]);
            }
        }
    }
}

