/*
 * Decompiled with CFR 0.152.
 */
package dan200.qcraft.shared;

import dan200.qcraft.shared.TileEntityQuantumComputer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class PortalRegistry {
    public static final PortalRegistry PortalRegistry = new PortalRegistry();
    public static final PortalRegistry ClientPortalRegistry = new PortalRegistry();
    private List<Server> m_servers = new ArrayList<Server>();
    private Map<String, TileEntityQuantumComputer.PortalLocation> m_portals = new HashMap<String, TileEntityQuantumComputer.PortalLocation>();

    public static PortalRegistry getPortalRegistry(World world) {
        if (!world.field_72995_K) {
            return PortalRegistry;
        }
        return ClientPortalRegistry;
    }

    public void reset() {
        this.m_servers.clear();
        this.m_portals.clear();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        int i;
        if (nbt.func_74764_b("servers")) {
            NBTTagList servers = nbt.func_150295_c("servers", 10);
            for (i = 0; i < servers.func_74745_c(); ++i) {
                NBTTagCompound server = servers.func_150305_b(i);
                this.m_servers.add(new Server(server.func_74779_i("name"), server.func_74779_i("address")));
            }
        }
        NBTTagList portals = nbt.func_150295_c("portals", 10);
        for (i = 0; i < portals.func_74745_c(); ++i) {
            NBTTagCompound portal = portals.func_150305_b(i);
            this.m_portals.put(portal.func_74779_i("id"), TileEntityQuantumComputer.PortalLocation.decode(portal));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList servers = new NBTTagList();
        for (Server entry : this.m_servers) {
            NBTTagCompound server = new NBTTagCompound();
            server.func_74778_a("name", entry.m_name);
            server.func_74778_a("address", entry.m_address);
            servers.func_74742_a((NBTBase)server);
        }
        nbt.func_74782_a("servers", (NBTBase)servers);
        NBTTagList portals = new NBTTagList();
        for (Map.Entry<String, TileEntityQuantumComputer.PortalLocation> entry : this.m_portals.entrySet()) {
            NBTTagCompound portal = entry.getValue().encode();
            portal.func_74778_a("id", entry.getKey());
            portals.func_74742_a((NBTBase)portal);
        }
        nbt.func_74782_a("portals", (NBTBase)portals);
    }

    public String getUnusedID() {
        int id = 1;
        while (this.m_portals.containsKey("Gate " + id)) {
            ++id;
        }
        return "Gate " + id;
    }

    public boolean register(String id, TileEntityQuantumComputer.PortalLocation portal) {
        if (!this.m_portals.containsKey(id)) {
            this.m_portals.put(id, portal);
            return true;
        }
        return false;
    }

    public void unregister(String id) {
        if (this.m_portals.containsKey(id)) {
            this.m_portals.remove(id);
        }
    }

    public TileEntityQuantumComputer.PortalLocation getPortal(String id) {
        return this.m_portals.get(id);
    }

    public void registerServer(String name, String address) {
        for (int i = 0; i < this.m_servers.size(); ++i) {
            if (!this.m_servers.get((int)i).m_address.equals(address)) continue;
            this.m_servers.get((int)i).m_name = name;
            return;
        }
        this.m_servers.add(new Server(name, address));
    }

    public void unregisterServer(String address) {
        for (int i = 0; i < this.m_servers.size(); ++i) {
            if (!this.m_servers.get((int)i).m_address.equals(address)) continue;
            this.m_servers.remove(i);
            break;
        }
    }

    public String getServerAddressAfter(String address) {
        if (address == null) {
            return this.m_servers.size() >= 0 ? this.m_servers.get((int)0).m_address : null;
        }
        for (int i = 0; i < this.m_servers.size(); ++i) {
            if (!this.m_servers.get((int)i).m_address.equals(address)) continue;
            int indexAfter = i + 1;
            if (indexAfter >= this.m_servers.size()) {
                return null;
            }
            return this.m_servers.get((int)indexAfter).m_address;
        }
        return null;
    }

    public String getServerName(String address) {
        if (address != null) {
            for (int i = 0; i < this.m_servers.size(); ++i) {
                if (!this.m_servers.get((int)i).m_address.equals(address)) continue;
                return this.m_servers.get((int)i).m_name;
            }
        }
        return address;
    }

    private static class Server {
        public String m_name;
        public String m_address;

        public Server(String name, String address) {
            this.m_name = name;
            this.m_address = address;
        }
    }
}

