/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa;

import com.google.common.base.CaseFormat;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import org.pfaa.chemica.ChemicaItems;
import org.pfaa.geologica.Geologica;
import org.pfaa.geologica.fluid.ColoredBucketItem;

public class RegistrationUtils {
    public static void registerDeclaredBlocks(Class catalogClass, Class blockClass, Class<? extends ItemBlock> itemClass) {
        Field[] fields;
        for (Field field : fields = catalogClass.getFields()) {
            try {
                Object value = field.get(null);
                if (!(value instanceof Block) || !blockClass.isAssignableFrom(value.getClass())) continue;
                Block block = (Block)value;
                String name = RegistrationUtils.fieldNameToUnlocalizedName(field.getName());
                block.func_149663_c(name);
                String prefix = Loader.instance().activeModContainer().getModId().replaceFirst("PFAA", "");
                block.func_149658_d(prefix + ":" + name);
                GameRegistry.registerBlock((Block)block, itemClass, (String)name);
            }
            catch (Exception e) {
                Geologica.log.fatal("Failed to register field '" + field.getName() + "' as block");
                throw new LoaderException((Throwable)e);
            }
        }
    }

    public static void registerDeclaredItems(Class catalogClass) {
        Field[] fields;
        for (Field field : fields = catalogClass.getFields()) {
            try {
                Item item = (Item)field.get(null);
                String name = RegistrationUtils.fieldNameToUnlocalizedName(field.getName());
                item.func_77655_b(name);
                GameRegistry.registerItem((Item)item, (String)name);
            }
            catch (Exception e) {
                Geologica.log.fatal("Failed to register field '" + field.getName() + "' as item");
                throw new LoaderException((Throwable)e);
            }
        }
    }

    private static String fieldNameToUnlocalizedName(String name) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name.replaceAll("__", "."));
    }

    public static void registerContainersForDeclaredFluidBlocks(Class catalogClass) {
        Field[] fields;
        for (Field field : fields = catalogClass.getFields()) {
            try {
                BlockFluidBase block;
                Object value = field.get(null);
                if (!(value instanceof BlockFluidBase) || (block = (BlockFluidBase)value).getFluid().isGaseous()) continue;
                RegistrationUtils.registerBucketForFluid(block);
                RegistrationUtils.registerFlaskForFluid(block.getFluid());
            }
            catch (Exception e) {
                Geologica.log.fatal("Failed to register bucket for fluid block '" + field.getName());
                throw new LoaderException((Throwable)e);
            }
        }
    }

    private static void registerBucketForFluid(BlockFluidBase block) {
        String name = RegistrationUtils.fieldNameToUnlocalizedName(block.getFluid().getName()) + "Bucket";
        ColoredBucketItem item = new ColoredBucketItem((Block)block);
        item.func_77655_b(name);
        GameRegistry.registerItem((Item)item, (String)name);
        FluidContainerRegistry.registerFluidContainer((Fluid)block.getFluid(), (ItemStack)new ItemStack((Item)item), (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
    }

    private static void registerFlaskForFluid(Fluid fluid) {
        FluidContainerRegistry.registerFluidContainer((Fluid)fluid, (ItemStack)new ItemStack((Item)ChemicaItems.FILLED_GLASS_BOTTLE, 1, fluid.getID()), (ItemStack)FluidContainerRegistry.EMPTY_BOTTLE);
    }
}

