/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.pfaa.block.CompositeBlockAccessors;
import org.pfaa.geologica.Geologica;

public abstract class CompositeBlock
extends Block
implements CompositeBlockAccessors {
    private IIcon[] underlayIcons;
    private IIcon[] oreOverlayIcons;
    private boolean overlayEnabled;
    private boolean defaultRendererEnabled;

    public CompositeBlock(Material material) {
        super(material);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this.overlayEnabled) {
            return this.getOverlayIcon(side, meta);
        }
        return this.getUnderlayIcon(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getUnderlayIcon(int side, int meta) {
        return this.underlayIcons[this.func_149692_a(meta)];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayIcon(int side, int meta) {
        return this.oreOverlayIcons[this.func_149692_a(meta)];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (this.overlayEnabled) {
            return this.getOverlayIcon(world, x, y, z, side);
        }
        return this.getUnderlayIcon(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getUnderlayIcon(IBlockAccess world, int x, int y, int z, int side) {
        return this.getUnderlayIcon(side, world.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getOverlayIcon(IBlockAccess world, int x, int y, int z, int side) {
        return this.getOverlayIcon(side, world.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < this.getMetaCount(); ++i) {
            list.add(new ItemStack(item, 1, this.func_149692_a(i)));
        }
    }

    public float getBlockResistance() {
        return this.field_149781_w / 3.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister registry) {
        int i;
        this.underlayIcons = new IIcon[this.getMetaCount()];
        for (i = 0; i < this.getMetaCount(); ++i) {
            this.underlayIcons[i] = this.registerUnderlayIcon(registry, i);
        }
        this.oreOverlayIcons = new IIcon[this.getMetaCount()];
        if (this.useMultipassRendering()) {
            for (i = 0; i < this.getMetaCount(); ++i) {
                this.oreOverlayIcons[i] = this.registerOverlayIcon(registry, i);
            }
        }
    }

    protected IIcon registerMetaIcon(IIconRegister registry, int i) {
        return registry.func_94245_a(this.func_149641_N() + "_" + this.getBlockNameSuffix(i));
    }

    protected IIcon registerUnderlayIcon(IIconRegister registry, int i) {
        return this.registerMetaIcon(registry, i);
    }

    protected IIcon registerOverlayIcon(IIconRegister registry, int i) {
        return this.registerMetaIcon(registry, i);
    }

    public boolean useMultipassRendering() {
        return false;
    }

    public int func_149645_b() {
        if (this.defaultRendererEnabled) {
            return super.func_149645_b();
        }
        return Geologica.registrant.getCompositeBlockRendererId();
    }

    @Override
    public boolean enableOverlay() {
        if (this.useMultipassRendering()) {
            this.overlayEnabled = true;
        }
        return this.overlayEnabled;
    }

    @Override
    public void disableOverlay() {
        this.overlayEnabled = false;
    }

    @Override
    public void enableDefaultRenderer() {
        this.defaultRendererEnabled = true;
    }

    @Override
    public void disableDefaultRenderer() {
        this.defaultRendererEnabled = false;
    }
}

