/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.model;

import java.awt.Color;
import org.pfaa.chemica.model.Chemical;
import org.pfaa.chemica.model.ChemicalConditionProperties;
import org.pfaa.chemica.model.ChemicalPhaseProperties;
import org.pfaa.chemica.model.CompoundDictionary;
import org.pfaa.chemica.model.Condition;
import org.pfaa.chemica.model.Element;
import org.pfaa.chemica.model.Formula;
import org.pfaa.chemica.model.Fusion;
import org.pfaa.chemica.model.Hazard;
import org.pfaa.chemica.model.IndustrialMaterial;
import org.pfaa.chemica.model.Mixture;
import org.pfaa.chemica.model.SimpleChemical;
import org.pfaa.chemica.model.Thermo;
import org.pfaa.chemica.model.Vaporization;

public interface Compound
extends Chemical {

    public static enum Compounds implements Compound
    {
        H2O(new Formula(Element.Elements.H, Element.Elements.O._(2)), "water", new ChemicalPhaseProperties.Solid(0.917, new Thermo(-291.0, 41.0, 2.79, 128.0), new Hazard(0, 0, 0)), new Fusion(273.0), new ChemicalPhaseProperties.Liquid(1.0, new Thermo(-204.0, 1523.0, -3196.0, 2474.0, 3.86, -257.0, -489.0), new Hazard(0, 0, 0), new ChemicalPhaseProperties.Liquid.Yaws(-10.2, 1790.0, 0.0177, 1.26E-5)), new Vaporization(4.65, 1435.0, -64.8), new ChemicalPhaseProperties.Gas(new Thermo(30.1, 6.83, 6.79, -2.53, 0.0821, -251.0, 223.0).addSegment(1700.0, 42.0, 8.62, -1.5, 0.0981, -11.2, -272.0, 220.0), new Hazard(0, 0, 0), new ChemicalPhaseProperties.Gas.Sutherland(13.0, 373.0, 961.0))),
        CO2(new Formula(Element.Elements.C, Element.Elements.O._(2)), null, new ChemicalPhaseProperties.Solid(1.56, new Thermo(-427.0, 51.1, 0.0, 300.0), new Hazard(3, 0, 0)), null, null, new Vaporization(6.81, 1301.0, -3.49), new ChemicalPhaseProperties.Gas(new Thermo(25.0, 55.2, -33.7, 7.95, -0.137, -404.0, 228.0).addSegment(1200.0, 58.2, 2.72, -0.492, 0.0388, -6.45, -426.0, 264.0), new Hazard(2, 0, 0), new ChemicalPhaseProperties.Gas.Sutherland(14.8, 293.0, 240.0))),
        Ag2S(new Formula(Element.Elements.Ag._(2), Element.Elements.S), "silver", new ChemicalPhaseProperties.Solid(Color.black, 7.23, new Thermo(-32.6, 144.0, 55.4, 77.9).addSegment(452.0, 91.2, 0.0, 5.86)), new Fusion(1098.0), new ChemicalPhaseProperties.Liquid(new Thermo(157.0))),
        AlOH3(new Formula(Element.Elements.Al, new Formula.Part(Element.Elements.O, Element.Elements.H)._(3)), "aluminum", new ChemicalPhaseProperties.Solid(2.42, new Thermo(-1277.0, 71.0, 25.7, 155.0, -98.6, 0.69))),
        As2S3(new Formula(Element.Elements.As._(2), Element.Elements.S._(3)), "arsenic", new ChemicalPhaseProperties.Solid(new Color(245, 210, 15), 3.43, new Thermo(-169.0, 164.0, 116.0)), new Fusion(583.0), new ChemicalPhaseProperties.Liquid(new Thermo(213.0)), new Vaporization(980.0)),
        AsS(new Formula(Element.Elements.As, Element.Elements.S), "arsenic", new ChemicalPhaseProperties.Solid(Color.red, 3.56, new Thermo()), new Fusion(633.0), new ChemicalPhaseProperties.Liquid(new Thermo()), new Vaporization(838.0)),
        BaSO4(new Formula(Element.Elements.Ba, Element.Elements.S, Element.Elements.O._(4)), "barium", new ChemicalPhaseProperties.Solid(4.5, new Thermo(-1465.0, 132.0, 141.0, 0.595, 0.0, 3.49), new Hazard(0, 0, 0)), new Fusion(1618.0), new ChemicalPhaseProperties.Liquid(new Thermo(157.0))),
        Be3Al2SiO36(new Formula(Element.Elements.Be._(3), Element.Elements.Al._(2), new Formula.Part(Element.Elements.Si, Element.Elements.O._(3))._(6)), "beryl", new ChemicalPhaseProperties.Solid(new Color(190, 255, 200), 2.7, new Thermo(-9000.0, 347.0, 593.0, 132.0, 17.1, -20.5)), new Fusion(1700.0), new ChemicalPhaseProperties.Liquid(new Thermo(495.0))),
        Bi2S3(new Formula(Element.Elements.Bi._(2), Element.Elements.S._(3)), "bismuth", new ChemicalPhaseProperties.Solid(new Color(160, 106, 0), 6.78, new Thermo(-143.0, 200.0, 155.0, -43.2, 36.2, 2.08), new Hazard(0, 0, 0)), new Fusion(1123.0), new ChemicalPhaseProperties.Liquid(new Thermo(274.0))),
        CaCO3(new Formula(Element.Elements.Ca, new Formula.Part(Element.Elements.C, Element.Elements.O._(3))), "calcium", new ChemicalPhaseProperties.Solid(2.7, new Thermo(-1207.0, 93.0, 82.3, 49.8, 0.0, 1.29))),
        CaF2(new Formula(Element.Elements.Ca, Element.Elements.F._(2)), "fluorine", new ChemicalPhaseProperties.Solid(3.18, new Thermo(89.9, -46.1, 65.3, -17.9, -1.14, -1255.0, 182.0).addSegment(1424.0, 108.0, 10.4, 0.023, -0.00286, -0.028, -1288.0, 148.0), new Hazard(0, 0, 0)), new Fusion(1691.0), new ChemicalPhaseProperties.Liquid(3.58, new Thermo(-1186.0, 92.6, 99.9)), new Vaporization(2806.0), new ChemicalPhaseProperties.Gas(new Thermo(57.4, 0.718, -0.194, 0.0166, -0.571, -804.0, 340.0))),
        NaCaNb2O6OH(new Formula(Element.Elements.Na, Element.Elements.Ca, Element.Elements.Nb._(2), Element.Elements.O._(6), new Formula.Part(Element.Elements.O, Element.Elements.H)), "niobium", new ChemicalPhaseProperties.Solid()),
        NaCaTa2O6OH(new Formula(Element.Elements.Na, Element.Elements.Ca, Element.Elements.Ta._(2), Element.Elements.O._(6), new Formula.Part(Element.Elements.O, Element.Elements.H)), "tantalum", new ChemicalPhaseProperties.Solid()),
        CaSO4_2H2O(new Formula(Element.Elements.Ca, new Formula.Part(Element.Elements.S, Element.Elements.O._(4))).hydrate(2), "calcium", new ChemicalPhaseProperties.Solid(2.32, new Thermo(-1433.0, 107.0, 186.0))),
        CaWO4(new Formula(Element.Elements.Ca, new Formula.Part(Element.Elements.W, Element.Elements.O._(4))), "tungsten", new ChemicalPhaseProperties.Solid(4.7, new Thermo(-1645.0, 126.0, 133.0, 21.8, 0.0, 2.29)), new Fusion(1893.0)),
        Cs2Al2Si4O12(new Formula(Element.Elements.Cs._(2), Element.Elements.Al._(2), new Formula.Part(Element.Elements.Si, Element.Elements.O._(3))._(4)).hydrate(2), "caesium", new ChemicalPhaseProperties.Solid(Color.white, 2.9, new Thermo())),
        CdS(new Formula(Element.Elements.Cd, Element.Elements.S), "cadmium", new ChemicalPhaseProperties.Solid(new Color(244, 208, 10), 4.83, new Thermo(-162.0, 65.0, 54.0, 3.77), new Hazard(3, 0, 0)), null, null, new Vaporization(1250.0)),
        CeCO3F(new Formula(Element.Elements.Ce, new Formula.Part(Element.Elements.C, Element.Elements.O._(3), Element.Elements.F)), "cerium", new ChemicalPhaseProperties.Solid(new Color(177, 81, 39), 4.95, new Thermo())),
        CePO4(new Formula(Element.Elements.Ce, new Formula.Part(Element.Elements.P, Element.Elements.O._(4))), "cerium", new ChemicalPhaseProperties.Solid(new Color(184, 83, 43), 5.22, new Thermo())),
        CoAsS(new Formula(Element.Elements.Co, Element.Elements.As, Element.Elements.S), "cobalt", new ChemicalPhaseProperties.Solid(new Color(255, 80, 80), 6.33, new Thermo())),
        CoO(new Formula(Element.Elements.Co, Element.Elements.O), "cobalt", new ChemicalPhaseProperties.Solid(Color.black, 6.44, new Thermo(43.7, 22.4, -16.9, 6.56, 0.532, -250.0, 103.0).addSegment(1600.0, 36.0, 14.1, 1.16, -0.116, 5.16, -238.0, 106.0), new Hazard(2, 0, 0)), new Fusion(2103.0)),
        Cu2CO3OH2(new Formula(Element.Elements.Cu._(2), new Formula.Part(Element.Elements.C, Element.Elements.O._(3)), new Formula.Part(Element.Elements.O, Element.Elements.H)._(2)), "copper", new ChemicalPhaseProperties.Solid(Color.green, 3.8, new Thermo())),
        CuFeS2(new Formula(Element.Elements.Cu, Element.Elements.Fe, Element.Elements.S._(2)), "copper", new ChemicalPhaseProperties.Solid(new Color(195, 163, 104), 4.2, new Thermo(-194.0, 125.0, 100.0)), new Fusion(1223.0), new ChemicalPhaseProperties.Liquid(new Thermo(133.0))),
        Cu2O(new Formula(Element.Elements.Cu._(2), Element.Elements.O), "copper", new ChemicalPhaseProperties.Solid(new Color(135, 0, 20), 6.1, new Thermo(-169.0, 93.1, 59.6, 27.4, -5.11, 0.325)), new Fusion(1505.0), new ChemicalPhaseProperties.Liquid(new Thermo(136.0))),
        Fe2O3(new Formula(Element.Elements.Fe._(2), Element.Elements.O._(3)), "iron", new ChemicalPhaseProperties.Solid(new Color(200, 42, 42), 5.2, new Thermo(93.4, 108.0, 50.9, 25.6, -1.61, -863.0, 161.0).addSegment(950.0, 151.0, 0.0, 0.0, 0.0, 0.0, -876.0, 253.0).addSegment(1050.0, 111.0, 32.0, -9.19, 0.902, 5.43, -843.0, 228.0))),
        Fe3O4(new Formula(Element.Elements.Fe._(3), Element.Elements.O._(4)), "iron", new ChemicalPhaseProperties.Solid(Color.BLACK, 5.17, new Thermo(104.0, 179.0, 10.6, 1.13, -0.994, -1163.0, 212.0).addSegment(900.0, 201.0, 1.59, -6.66, 9.45, 3.19, -1174.0, 388.0)), new Fusion(1870.0), new ChemicalPhaseProperties.Liquid(new Thermo(164.0))),
        gamma_FeOH3(new Formula(Element.Elements.Fe, new Formula.Part(Element.Elements.O, Element.Elements.H)._(3)), "iron", new ChemicalPhaseProperties.Solid(new Color(120, 80, 40), 4.25, new Thermo(65.1, 182.0, -101.0, 19.0, -0.825, -862.0, 128.0))),
        alpha_FeOH3(new Formula(Element.Elements.Fe, new Formula.Part(Element.Elements.O, Element.Elements.H)._(3)), "iron", new ChemicalPhaseProperties.Solid(new Color(207, 189, 33), 4.25, new Thermo(65.1, 182.0, -101.0, 19.0, -0.825, -862.0, 128.0))),
        FeCr2O4(new Formula(Element.Elements.Fe, Element.Elements.Cr._(2), Element.Elements.O._(4)), "chromium", new ChemicalPhaseProperties.Solid(new Color(25, 10, 10), 4.7, new Thermo(-1438.0, 152.0, 160.0, 31.8, -6.33, 3.06)), new Fusion(2500.0)),
        FeNb2O6(new Formula(Element.Elements.Fe, Element.Elements.Nb._(2), Element.Elements.O._(6)), "niobium", new ChemicalPhaseProperties.Solid(new Color(40, 20, 20), 6.0, new Thermo())),
        FeS2(new Formula(Element.Elements.Fe, Element.Elements.S._(2)), "iron", new ChemicalPhaseProperties.Solid(new Color(204, 154, 0), 4.9, new Thermo(82.3, -23.7, 35.1, -9.6, -1.4, -196.0, 151.0))),
        FeTa2O6(new Formula(Element.Elements.Fe, Element.Elements.Ta._(2), Element.Elements.O._(6)), "tantalum", new ChemicalPhaseProperties.Solid(new Color(40, 20, 20), 7.94, new Thermo())),
        FeTiO3(new Formula(Element.Elements.Fe, Element.Elements.Ti, Element.Elements.O._(3)), "titanium", new ChemicalPhaseProperties.Solid(new Color(25, 10, 10), 4.6, new Thermo(-1234.0, 106.0, 110.0, 38.8, -10.3, 1.91), new Hazard(1, 0, 0)), new Fusion(1638.0), new ChemicalPhaseProperties.Liquid(new Thermo(161.0))),
        FeV2O4(new Formula(Element.Elements.Fe, Element.Elements.V._(2), Element.Elements.O._(4)), "vanadium", new ChemicalPhaseProperties.Solid()),
        FeWO4(new Formula(Element.Elements.Fe, new Formula.Part(Element.Elements.W, Element.Elements.O._(4))), "tungsten", new ChemicalPhaseProperties.Solid(Color.black, 6.64, new Thermo(-1155.0, 132.0, 114.0))),
        H2S(new Formula(Element.Elements.H._(2), Element.Elements.S), "sulfur", null, null, new ChemicalPhaseProperties.Liquid(0.949, new Thermo(122.0)), new Vaporization(4.53, 959.0, -0.539), new ChemicalPhaseProperties.Gas(new Thermo(26.9, 18.7, 3.43, -3.38, 0.136, -28.9, 233.0).addSegment(1400.0, 51.2, 4.15, -0.644, 0.0416, -10.5, -55.9, 244.0), new Hazard(4, 4, 0), new ChemicalPhaseProperties.Gas.Sutherland(11.3, 273.0, 313.0))),
        HgS(new Formula(Element.Elements.Hg, Element.Elements.S), "mercury", new ChemicalPhaseProperties.Solid(new Color(139, 0, 0), 8.1, new Thermo(-58.0, 78.0, 43.9, 15.3), new Hazard(2, 1, 0))),
        KCl(new Formula(Element.Elements.K, Element.Elements.Cl), "potassium", new ChemicalPhaseProperties.Solid(1.98, new Thermo(35.4, 70.0, -91.4, 52.5, 0.153, -449.0, 109.0).addSegment(900.0, -717.0, 1248.0, -709.0, 141.0, 104.0, 1.76, -738.0)), new Fusion(1094.0), new ChemicalPhaseProperties.Liquid(1.52, new Thermo(-422.0, 86.7, 73.6)), new Vaporization(4.78, 7441.0, -123.0), new ChemicalPhaseProperties.Gas(new Thermo(37.4, 0.792, -0.0097, 8.27E-4, -0.996, -226.0, 283.5))),
        K2U2V2O12(new Formula(Element.Elements.K._(2), new Formula.Part(Element.Elements.U, Element.Elements.O._(2))._(2), new Formula.Part(Element.Elements.V, Element.Elements.O._(4))._(2)).hydrate(3), "uranium", new ChemicalPhaseProperties.Solid(new Color(250, 250, 35), 4.7, new Thermo())),
        LiAlSiO32(new Formula(Element.Elements.Li, Element.Elements.Al, new Formula.Part(Element.Elements.Si, Element.Elements.O._(3))._(2)), "lithium", new ChemicalPhaseProperties.Solid(new Color(190, 170, 170), 3.1, new Thermo())),
        Li3KSi4O10OH2(new Formula(Element.Elements.Li._(3), Element.Elements.K, new Formula.Part(Element.Elements.Si._(4), Element.Elements.O._(10)), new Formula.Part(Element.Elements.O, Element.Elements.H)._(2)), "lithium", new ChemicalPhaseProperties.Solid(new Color(240, 50, 140), 2.8, new Thermo())),
        MgCl2(new Formula(Element.Elements.Mg, Element.Elements.Cl._(2)).hydrate(6), "magnesium", new ChemicalPhaseProperties.Solid(1.57, new Thermo(78.3, 2.44, 6.86, -1.73, -0.73, -668.0, 179.0)), new Fusion(987.0), new ChemicalPhaseProperties.Liquid(2.11, new Thermo(-602.0, 130.0, 92.0)), new Vaporization(1685.0), new ChemicalPhaseProperties.Gas(new Thermo(61.7, 0.573, -0.155, 0.0132, -0.431, -412.0, 349.0))),
        MgCO3(new Formula(Element.Elements.Mg, new Formula.Part(Element.Elements.C, Element.Elements.O._(3))), "magnesium", new ChemicalPhaseProperties.Solid(2.96, new Thermo(44.9, 150.0, -74.2, 12.0, -0.629, -1133.0, 75.2))),
        MnO2(new Formula(Element.Elements.Mn, Element.Elements.O._(2)), "manganese", new ChemicalPhaseProperties.Solid(Color.black, 5.03, new Thermo(-520.0, 53.0, 70.2, 8.86, 0.732, 1.67))),
        MoS2(new Formula(Element.Elements.Mo, Element.Elements.S._(2)), "molybdenum", new ChemicalPhaseProperties.Solid(new Color(26, 26, 26), 5.06, new Thermo(71.7, 7.52, -0.0449, 0.00887, -0.921, -301.0, 142.0), new Hazard(1, 1, 0))),
        Na2B4O7(new Formula(Element.Elements.Na._(2), new Formula.Part(Element.Elements.B._(4), Element.Elements.O._(5), new Formula.Part(Element.Elements.O, Element.Elements.H)._(4))).hydrate(8), "borax", new ChemicalPhaseProperties.Solid(Color.WHITE, 1.7, new Thermo(-3276.0, 189.0, 614.0)), new Fusion(1016.0), new ChemicalPhaseProperties.Liquid(new Thermo(265.0))),
        NaCl(new Formula(Element.Elements.Na, Element.Elements.Cl), "sodium", new ChemicalPhaseProperties.Solid(2.17, new Thermo(50.7, 6.67, -2.52, 10.2, -0.201, -427.0, 130.0)), new Fusion(1074.0), new ChemicalPhaseProperties.Liquid(Double.NaN, new Thermo(-42.4, 114.0, -43.6, 5.9, 39.1, -306.0, 91.1)), new Vaporization(5.07, 8388.0, -82.6), new ChemicalPhaseProperties.Gas(new Thermo(37.3, 0.792, -0.027, 0.00231, -0.157, -193.0, 274.0))),
        NiO(new Formula(Element.Elements.Ni, Element.Elements.O), "nickel", new ChemicalPhaseProperties.Solid(Color.GREEN, 2.7, new Thermo(-240.0, 38.0, 47.3, 9.0), new Hazard(2, 0, 0)), new Fusion(2228.0)),
        NiOH2(new Formula(Element.Elements.Ni, new Formula.Part(Element.Elements.O, Element.Elements.H)._(2)), "nickel", new ChemicalPhaseProperties.Solid(Color.GREEN, 4.1, new Thermo(-538.0, 79.0, 81.0), new Hazard(2, 0, 0))),
        Ni9S8(new Formula(Element.Elements.Ni._(9), Element.Elements.S._(8)), "nickel", new ChemicalPhaseProperties.Solid(new Color(165, 150, 5), 4.8, new Thermo(-847.0, 475.0, 443.0))),
        Ni3Si2O5OH4(new Formula(Element.Elements.Ni._(3), new Formula.Part(Element.Elements.Si._(2), Element.Elements.O._(5)), new Formula.Part(Element.Elements.O, Element.Elements.H)._(4)), "nickel", new ChemicalPhaseProperties.Solid(new Color(100, 150, 100), 3.2, new Thermo())),
        O2(new Formula(Element.Elements.O._(2)), "oxygen", null, null, new ChemicalPhaseProperties.Liquid(1.14, new Thermo(129.0)), new Vaporization(3.95, 340.0, -4.14), new ChemicalPhaseProperties.Gas(new Thermo(31.3, -20.2, 57.9, -36.5, -0.00737, -8.9, 247.0).addSegment(700.0, 30.03, 8.77, -3.99, 0.788, -0.742, -11.3, 236.0).addSegment(2000.0, 20.9, 10.7, -2.02, 0.146, 9.25, 5.34, 238.0), new Hazard(3, 0, 0, Hazard.SpecialCode.OXIDIZER), new ChemicalPhaseProperties.Gas.Sutherland(127.0, 292.0, 20.1))),
        PbS(new Formula(Element.Elements.Pb, Element.Elements.S), "lead", new ChemicalPhaseProperties.Solid(new Color(26, 26, 26), 7.6, new Thermo(47.4, 7.55, 2.01, -0.7, -0.0318, -113.0, 146.0), new Hazard(2, 0, 0)), new Fusion(1391.0), new ChemicalPhaseProperties.Liquid(new Thermo(-98.3, 101.0, 66.9)), new Vaporization(1554.0), new ChemicalPhaseProperties.Gas(new Thermo(77.9, -29.8, 7.55, -0.51, -25.1, 68.6, 311.0))),
        Pb5V3O12Cl(new Formula(Element.Elements.Pb._(5), new Formula.Part(Element.Elements.V, Element.Elements.O._(4))._(3), Element.Elements.Cl), "vanadium", new ChemicalPhaseProperties.Solid(new Color(210, 0, 0), 6.9, new Thermo())),
        Sb2S3(new Formula(Element.Elements.Sb._(2), Element.Elements.S._(3)), "antimony", new ChemicalPhaseProperties.Solid(new Color(100, 100, 100), 4.64, new Thermo(-175.0, 182.0, 101.0, 55.2), new Hazard(2, 1, 0)), new Fusion(823.0), new ChemicalPhaseProperties.Liquid(new Thermo(231.0))),
        SnO2(new Formula(Element.Elements.Sn, Element.Elements.O._(2)), "tin", new ChemicalPhaseProperties.Solid(Color.WHITE, 7.0, new Thermo(-581.0, 52.0, 60.0), new Hazard(2, 0, 0)), new Fusion(1903.0), new ChemicalPhaseProperties.Liquid()),
        SrSO4(new Formula(Element.Elements.Sr, new Formula.Part(Element.Elements.S, Element.Elements.O._(4))), "strontium", new ChemicalPhaseProperties.Solid(Color.WHITE, 3.96, new Thermo(-1453.0, 117.0, 91.7, 55.4), new Hazard(1, 0, 0)), new Fusion(1879.0), new ChemicalPhaseProperties.Liquid(new Thermo(136.0))),
        TiO2(new Formula(Element.Elements.Ti, Element.Elements.O._(2)), "titanium", new ChemicalPhaseProperties.Solid(4.23, new Thermo(67.0, 18.7, -11.6, 2.45, -1.49, -965.0, 117.0), new Hazard(1, 0, 0)), new Fusion(2116.0), new ChemicalPhaseProperties.Liquid(new Thermo(78.0)), new Vaporization(3245.0), new ChemicalPhaseProperties.Gas(new Thermo(285.0))),
        UO2(new Formula(Element.Elements.U, Element.Elements.O._(2)), "uranium", new ChemicalPhaseProperties.Solid(Color.black, 11.0, new Thermo(70.0, 40.0, -37.5, 12.7, -1.45, -1111.0, 144.0), new Hazard(1, 0, 0)), new Fusion(3140.0), new ChemicalPhaseProperties.Liquid(new Thermo(100.0))),
        ZnS(new Formula(Element.Elements.Zn, Element.Elements.S), "zinc", new ChemicalPhaseProperties.Solid(4.09, new Thermo(-206.0, 201.0, 53.6, 3.97, 0.0, 0.814), new Hazard(1, 0, 0))),
        ZrSiO4(new Formula(Element.Elements.Zr, Element.Elements.Si, Element.Elements.O._(4)), "zirconium", new ChemicalPhaseProperties.Solid(new Color(210, 210, 210), 4.56, new Thermo(85.2, 137.0, -94.6, 21.7, -1.74, -2061.0, 140.0).addSegment(1700.0, 151.0, 0.0, 0.0, 0.0, 0.0, -2082.0, 238.0), new Hazard(1, 0, 1))),
        METHANE(new Formula(Element.Elements.C, Element.Elements.H._(4)).setSmiles("c"), "methane", new ChemicalPhaseProperties.Solid(0.494, new Thermo(104.0)), new Fusion(90.0), new ChemicalPhaseProperties.Liquid(new Thermo(-74.0, 116.0, 52.9)), new Vaporization(3.99, 443.0, -0.49), new ChemicalPhaseProperties.Gas(new Thermo(-0.703, 108.0, -42.5, 5.86, 0.679, -76.8, 159.0).addSegment(1300.0, 85.8, 11.2, -2.11, 0.138, -26.4, -154.0, 224.0), new Hazard(1, 4, 0), new ChemicalPhaseProperties.Gas.Sutherland(11.6, 311.0, 165.0))),
        ETHANE(new Formula(Element.Elements.C._(2), Element.Elements.H._(6)).setSmiles("cc"), "ethane", null, new Fusion(90.4), new ChemicalPhaseProperties.Liquid(new Thermo(127.0)), new Vaporization(4.51, 791.0, -6.42), new ChemicalPhaseProperties.Gas(new Thermo(6.16, 173.0, -0.683, 9.07, 0.126, -93.1, 186.0), new Hazard(1, 4, 0), new ChemicalPhaseProperties.Gas.Sutherland(9.1, 298.0, 272.0))),
        PROPANE(new Formula(Element.Elements.C._(3), Element.Elements.H._(8)).setSmiles("ccc"), "propane", new ChemicalPhaseProperties.Solid(new Thermo(130.0)), new Fusion(85.5), new ChemicalPhaseProperties.Liquid(new Thermo(-119.0, 171.0, 98.4)), new Vaporization(4.54, 1149.0, 24.9), new ChemicalPhaseProperties.Gas(new Thermo(-105.0, 270.0, 12.8, 231.0, -0.689, -0.00266), new Hazard(1, 4, 0), new ChemicalPhaseProperties.Gas.Sutherland(8.0, 289.0, 338.0))),
        N_BUTANE(new Formula(Element.Elements.C._(4), Element.Elements.H._(10)).setSmiles("cccc"), "butane", null, new Fusion(135.0), new ChemicalPhaseProperties.Liquid(new Thermo(-148.0, 230.0, 132.0)), new Vaporization(4.36, 1176.0, -2.07), new ChemicalPhaseProperties.Gas(new Thermo(-126.0, 310.0, 21.9, 294.0, -0.829, -0.00695), new Hazard(1, 4, 0), new ChemicalPhaseProperties.Gas.Sutherland(8.4, 289.0, 400.0))),
        ISO_BUTANE(new Formula(Element.Elements.C._(4), Element.Elements.H._(10)).setSmiles("cc(c)c"), "butane", null, new Fusion(113.0), new ChemicalPhaseProperties.Liquid(new Thermo(201.0)), new Vaporization(4.33, 1132.0, 0.918), new ChemicalPhaseProperties.Gas(new Thermo(-126.0, 310.0, 13.3, 316.0, -0.991, -0.0157), new Hazard(1, 4, 0), new ChemicalPhaseProperties.Gas.Sutherland(7.5, 296.0, 385.0)));

        private Chemical delegate;

        private Compounds(Formula formula, String oreDictKey, ChemicalPhaseProperties.Solid solid, Fusion fusion, ChemicalPhaseProperties.Liquid liquid, Vaporization vaporization, ChemicalPhaseProperties.Gas gas) {
            this.delegate = new SimpleChemical(formula, oreDictKey, solid, fusion, liquid, vaporization, gas);
            CompoundDictionary.register(formula, this);
        }

        private Compounds(Formula formula, String oreDictKey, ChemicalPhaseProperties.Solid solid, Fusion fusion, ChemicalPhaseProperties.Liquid liquid, Vaporization vaporization) {
            this(formula, oreDictKey, solid, fusion, liquid, vaporization, new ChemicalPhaseProperties.Gas());
        }

        private Compounds(Formula formula, String oreDictKey, ChemicalPhaseProperties.Solid solid, Fusion fusion, ChemicalPhaseProperties.Liquid liquid) {
            this(formula, oreDictKey, solid, fusion, liquid, null);
        }

        private Compounds(Formula formula, String oreDictKey, ChemicalPhaseProperties.Solid solid, Fusion fusion) {
            this(formula, oreDictKey, solid, fusion, new ChemicalPhaseProperties.Liquid());
        }

        private Compounds(Formula formula, String oreDictKey, ChemicalPhaseProperties.Solid solid) {
            this(formula, oreDictKey, solid, null);
        }

        @Override
        public Fusion getFusion() {
            return this.delegate.getFusion();
        }

        @Override
        public Vaporization getVaporization() {
            return this.delegate.getVaporization();
        }

        @Override
        public String getOreDictKey() {
            return this.delegate.getOreDictKey();
        }

        @Override
        public ChemicalConditionProperties getProperties(Condition condition) {
            return this.delegate.getProperties(condition);
        }

        @Override
        public Formula getFormula() {
            return this.delegate.getFormula();
        }

        @Override
        public Mixture mix(IndustrialMaterial material, double weight) {
            return this.delegate.mix(material, weight);
        }
    }
}

