/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.model;

import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pfaa.chemica.model.Condition;
import org.pfaa.chemica.model.ConditionProperties;
import org.pfaa.chemica.model.Hazard;
import org.pfaa.chemica.model.IndustrialMaterial;
import org.pfaa.chemica.model.Mixture;
import org.pfaa.chemica.model.MixtureComponent;
import org.pfaa.chemica.model.Phase;

public class SimpleMixture
implements Mixture {
    private List<MixtureComponent> components;
    private static final double THOMAS_A = 0.00273;
    private static final double THOMAS_B = 16.6;

    protected SimpleMixture(List<MixtureComponent> components) {
        this.components = components;
    }

    public SimpleMixture(MixtureComponent ... components) {
        this(Arrays.asList(components));
    }

    public SimpleMixture(IndustrialMaterial material, double weight) {
        this(new MixtureComponent(material, weight));
    }

    public SimpleMixture(IndustrialMaterial material) {
        this(new MixtureComponent(material, 1.0));
    }

    private double getTotalWeight() {
        double weight = 0.0;
        for (MixtureComponent comp : this.components) {
            weight += comp.weight;
        }
        return weight;
    }

    private double getTotalFluidWeight(Condition condition) {
        double weight = 0.0;
        for (MixtureComponent comp : this.components) {
            if (comp.getMaterial().getProperties((Condition)condition).phase == Phase.SOLID) continue;
            weight += comp.weight;
        }
        return weight;
    }

    @Override
    public String name() {
        String name = "Mixture of ";
        double totalWeight = this.getTotalWeight();
        for (MixtureComponent comp : this.components) {
            name = name + (int)(comp.weight / totalWeight * 100.0) + "% " + comp.material.name() + ", ";
        }
        return name.substring(0, name.length() - 1);
    }

    @Override
    public String getOreDictKey() {
        return null;
    }

    @Override
    public ConditionProperties getProperties(Condition condition) {
        if (this.components.size() == 0) {
            return null;
        }
        if (this.components.size() == 1) {
            return this.components.get((int)0).material.getProperties(condition);
        }
        double totalWeight = this.getTotalWeight();
        int r = 0;
        int g = 0;
        int b = 0;
        int luminosity = 0;
        float health = 0.0f;
        float flammability = 0.0f;
        float instability = 0.0f;
        double density = 0.0;
        double opaqueWeight = 0.0;
        double[] phaseWeight = new double[Phase.values().length];
        for (MixtureComponent comp : this.components) {
            ConditionProperties props = comp.material.getProperties(condition);
            if (props == null) continue;
            double normWeight = comp.weight / totalWeight;
            r = (int)((double)r + (double)props.color.getRed() * normWeight);
            b = (int)((double)b + (double)props.color.getBlue() * normWeight);
            g = (int)((double)g + (double)props.color.getGreen() * normWeight);
            density += props.density * normWeight;
            luminosity = (int)((double)luminosity + (double)props.luminosity * normWeight);
            health = (float)((double)health + (double)props.hazard.health * normWeight);
            flammability = (float)((double)flammability + (double)props.hazard.flammability * normWeight);
            instability = (float)((double)instability + (double)props.hazard.instability * normWeight);
            int n = props.phase.ordinal();
            phaseWeight[n] = phaseWeight[n] + comp.weight;
            if (!props.opaque) continue;
            opaqueWeight += normWeight;
        }
        Phase phase = Phase.values()[Doubles.indexOf((double[])phaseWeight, (double)Doubles.max((double[])phaseWeight))];
        return new ConditionProperties(phase, new Color(r, g, b), density, new Hazard(Math.round(health), Math.round(flammability), Math.round(instability)), this.getViscosity(condition, density), luminosity, opaqueWeight > 0.5);
    }

    private double getViscosity(Condition condition, double density) {
        double vbi = 0.0;
        double fluidWeight = this.getTotalFluidWeight(condition);
        for (MixtureComponent comp : this.components) {
            ConditionProperties props = comp.material.getProperties(condition);
            if (props.phase == Phase.SOLID) continue;
            double normWeight = comp.weight / fluidWeight;
            double cSt = props.viscosity / props.density;
            vbi += normWeight * Math.log(cSt) / Math.log(1000.0 * cSt);
        }
        double viscosity = Math.exp(vbi * Math.log(1000.0) / (1.0 - vbi)) * density;
        double solidFraction = 1.0 - fluidWeight / this.getTotalWeight();
        if (solidFraction > 0.0) {
            double relativeViscosity = 1.0 + 2.5 * solidFraction + 10.05 * Math.pow(solidFraction, 2.0) + 0.00273 * Math.exp(16.6 * solidFraction);
            viscosity *= relativeViscosity;
        }
        return viscosity;
    }

    @Override
    public List<MixtureComponent> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    @Override
    public Mixture mix(IndustrialMaterial material, double weight) {
        ArrayList<MixtureComponent> components = new ArrayList<MixtureComponent>(this.components);
        components.add(new MixtureComponent(material, weight));
        return new SimpleMixture(components);
    }
}

