/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.model;

import java.util.ArrayList;
import java.util.List;

public class Thermo {
    private List<Segment> shomates = new ArrayList<Segment>();
    private List<Double> temperatureBreaks = new ArrayList<Double>();

    private Thermo(Thermo thermo) {
        this.shomates.addAll(thermo.shomates);
        this.temperatureBreaks.addAll(thermo.temperatureBreaks);
    }

    private Thermo(Segment shomate) {
        this.shomates.add(shomate);
    }

    public Thermo() {
        this(Double.NaN);
    }

    public Thermo(double S) {
        this(Double.NaN, S, Double.NaN);
    }

    public Thermo(double H, double S, double Cp) {
        this(H, S, Cp, 0.0);
    }

    public Thermo(double H, double S, double a, double b) {
        this(H, S, a, b, 0.0, 0.0);
    }

    public Thermo(double H, double S, double a, double b, double c, double e) {
        this(new Segment(H, S, a, b, c, e));
    }

    public Thermo(double a, double b, double c, double d, double e, double f, double g) {
        this(new Segment(a, b, c, d, e, f, g));
    }

    private Segment findSegment(double t) {
        int si;
        for (si = this.temperatureBreaks.size() - 1; si >= 0 && this.temperatureBreaks.get(si) < t; --si) {
        }
        return this.shomates.get(si + 1);
    }

    public double getHeatCapacity(double t) {
        return this.findSegment(t).getHeatCapacity(t);
    }

    public double integrateHeatCapacity(double t) {
        return this.getEnthalpy(t) - this.getStandardEnthalpy();
    }

    public double getStandardEnthalpy() {
        return this.getHeatCapacity(298.0);
    }

    public double getStandardEntropy() {
        return this.getEntropy(298.0);
    }

    public double getEnthalpy(double t) {
        return this.findSegment(t).getEnthalpy(t);
    }

    public double getEntropy(double t) {
        return this.findSegment(t).getEntropy(t);
    }

    public Thermo addSegment(double t0, Segment segment) {
        Thermo clone = new Thermo(this);
        clone.shomates.add(segment);
        clone.temperatureBreaks.add(t0);
        return clone;
    }

    public Thermo addSegment(double t0, double Cp) {
        return this.addSegment(t0, Cp, 0.0);
    }

    public Thermo addSegment(double t0, double a, double b) {
        return this.addSegment(t0, a, b, 0.0);
    }

    public Thermo addSegment(double t0, double a, double b, double transition) {
        return this.addSegment(t0, new Segment(this.getStandardEnthalpy() + transition, this.getStandardEntropy(), a, b));
    }

    public Thermo addSegment(double t0, double a, double b, double c, double d, double e, double f, double g) {
        return this.addSegment(t0, new Segment(a, b, c, d, e, f, g));
    }

    private static class Segment {
        public final double a;
        public final double b;
        public final double c;
        public final double d;
        public final double e;
        public final double f;
        public final double g;

        public Segment(double a, double b, double c, double d, double e, double f, double g) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
            this.g = g;
        }

        public Segment(double H, double S, double a) {
            this(H, S, a, 0.0);
        }

        public Segment(double H, double S, double a, double b) {
            this(H, S, a, b, 0.0, 0.0);
        }

        public Segment(double H, double S, double a, double b, double c, double e) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = 0.0;
            this.e = e;
            this.f = H - this.getEnthalpy(298.0);
            this.g = S - this.getEntropy(298.0);
        }

        public double getHeatCapacity(double t) {
            return this.a + this.b * (t /= 1000.0) + this.c * Math.pow(t, 2.0) + this.d * Math.pow(t, 3.0) + this.e / Math.pow(t, 2.0);
        }

        public double getEnthalpy(double t) {
            return this.a * (t /= 1000.0) + this.b * Math.pow(t, 2.0) / 2.0 + this.c * Math.pow(t, 3.0) / 3.0 + this.d * Math.pow(t, 4.0) / 4.0 - this.e / t + this.f;
        }

        public double getEntropy(double t) {
            return this.a * Math.log(t /= 1000.0) + this.b * t + this.c * Math.pow(t, 2.0) / 2.0 + this.d * Math.pow(t, 3.0) / 3.0 - this.e / (2.0 * Math.pow(t, 2.0)) + this.g;
        }
    }
}

