/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.geologica;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import org.pfaa.chemica.model.Compound;
import org.pfaa.chemica.model.Condition;
import org.pfaa.chemica.model.ConditionProperties;
import org.pfaa.chemica.model.IndustrialMaterial;
import org.pfaa.chemica.model.Mixture;
import org.pfaa.chemica.model.MixtureComponent;
import org.pfaa.geologica.processing.Aggregate;
import org.pfaa.geologica.processing.Crude;
import org.pfaa.geologica.processing.IndustrialMineral;
import org.pfaa.geologica.processing.OreMineral;
import org.pfaa.geologica.processing.SimpleCrude;
import org.pfaa.geologica.processing.SimpleOre;
import org.pfaa.geologica.processing.SimpleVanillaOre;

public enum GeoMaterial implements Mixture
{
    BRECCIA(Aggregate.Aggregates.GRAVEL, Strength.WEAK),
    CARBONATITE(Aggregate.Aggregates.STONE.mix(OreMineral.Ores.CALCITE, 0.5).mix(OreMineral.Ores.PYROCHLORE, 0.02).mix(OreMineral.Ores.MICROLITE, 0.005), Strength.WEAK),
    CLAYSTONE(Aggregate.Aggregates.STONE, Strength.WEAK),
    CONGLOMERATE(Aggregate.Aggregates.SAND.mix(Aggregate.Aggregates.GRAVEL, 1.0), Strength.WEAK),
    MUDSTONE(Aggregate.Aggregates.STONE, Strength.WEAK),
    LIMESTONE(Aggregate.Aggregates.STONE.mix(OreMineral.Ores.CALCITE, 0.5), Strength.MEDIUM),
    SCHIST(Aggregate.Aggregates.STONE, Strength.MEDIUM),
    SERPENTINITE(Aggregate.Aggregates.STONE.mix(IndustrialMineral.IndustrialMinerals.CHRYSOTILE, 0.05).mix(IndustrialMineral.IndustrialMinerals.TALC, 0.05).mix(IndustrialMineral.IndustrialMinerals.OLIVINE, 0.05), Strength.MEDIUM),
    SLATE(Aggregate.Aggregates.STONE, Strength.MEDIUM),
    SKARN(Aggregate.Aggregates.STONE, Strength.MEDIUM),
    ANDESITE(Aggregate.Aggregates.STONE, Strength.STRONG),
    BASALT(Aggregate.Aggregates.STONE, Strength.STRONG),
    GNEISS(Aggregate.Aggregates.STONE, Strength.STRONG),
    GRANITE(Aggregate.Aggregates.STONE, Strength.STRONG),
    GREENSCHIST(Aggregate.Aggregates.STONE, Strength.STRONG),
    MARBLE(Aggregate.Aggregates.STONE.mix(OreMineral.Ores.CALCITE, 1.0), Strength.STRONG),
    PEGMATITE(Aggregate.Aggregates.STONE.mix(IndustrialMineral.IndustrialMinerals.FELDSPAR, 0.5).mix(IndustrialMineral.IndustrialMinerals.QUARTZ, 0.2).mix(IndustrialMineral.IndustrialMinerals.MICA, 0.2).mix(OreMineral.Ores.MICROLITE, 0.02), Strength.STRONG),
    RHYOLITE(Aggregate.Aggregates.STONE, Strength.STRONG),
    SANDSTONE(Aggregate.Aggregates.STONE, Strength.STRONG),
    DIORITE(Aggregate.Aggregates.STONE, Strength.VERY_STRONG),
    GABBRO(Aggregate.Aggregates.STONE, Strength.VERY_STRONG),
    HORNFELS(Aggregate.Aggregates.STONE, Strength.VERY_STRONG),
    PERIDOTITE(Aggregate.Aggregates.STONE.mix(IndustrialMineral.IndustrialMinerals.OLIVINE, 0.5), Strength.VERY_STRONG),
    QUARTZITE(Aggregate.Aggregates.SAND, Strength.VERY_STRONG),
    LIGHT_OIL((Mixture)new SimpleCrude(Crude.Crudes.FUEL_GAS, 0.1).mix(Crude.Crudes.LIGHT_NAPHTHA, 0.35).mix(Crude.Crudes.HEAVY_NAPHTHA, 0.25).mix(Crude.Crudes.KEROSENE, 0.1).mix(Crude.Crudes.LIGHT_GAS_OIL, 0.05).mix(Crude.Crudes.HEAVY_GAS_OIL, 0.05).mix(Crude.Crudes.BITUMEN, 0.1), Strength.WEAK, Material.field_151586_h),
    MEDIUM_OIL((Mixture)new SimpleCrude(Crude.Crudes.FUEL_GAS, 0.05).mix(Crude.Crudes.LIGHT_NAPHTHA, 0.15).mix(Crude.Crudes.HEAVY_NAPHTHA, 0.3).mix(Crude.Crudes.KEROSENE, 0.15).mix(Crude.Crudes.LIGHT_GAS_OIL, 0.1).mix(Crude.Crudes.HEAVY_GAS_OIL, 0.05).mix(Crude.Crudes.BITUMEN, 0.2), Strength.MEDIUM, Material.field_151586_h),
    HEAVY_OIL((Mixture)new SimpleCrude(Crude.Crudes.LIGHT_NAPHTHA, 0.05).mix(Crude.Crudes.HEAVY_NAPHTHA, 0.1).mix(Crude.Crudes.KEROSENE, 0.2).mix(Crude.Crudes.LIGHT_GAS_OIL, 0.25).mix(Crude.Crudes.HEAVY_GAS_OIL, 0.1).mix(Crude.Crudes.BITUMEN, 0.3), Strength.STRONG, Material.field_151586_h),
    EXTRA_HEAVY_OIL((Mixture)new SimpleCrude(Crude.Crudes.HEAVY_NAPHTHA, 0.05).mix(Crude.Crudes.KEROSENE, 0.05).mix(Crude.Crudes.LIGHT_GAS_OIL, 0.1).mix(Crude.Crudes.HEAVY_GAS_OIL, 0.2).mix(Crude.Crudes.BITUMEN, 0.6), Strength.STRONG, Material.field_151586_h),
    OIL_SAND(EXTRA_HEAVY_OIL.mix(Aggregate.Aggregates.SAND, 2.0), Strength.WEAK, Material.field_151595_p),
    NATURAL_GAS(Compound.Compounds.METHANE.mix(Compound.Compounds.ETHANE, 0.05).mix(Compound.Compounds.PROPANE, 0.002).mix(Compound.Compounds.N_BUTANE, 3.0E-4).mix(Compound.Compounds.ISO_BUTANE, 3.0E-4), Strength.WEAK, Material.field_151579_a),
    OIL_SHALE(new SimpleCrude(Crude.Crudes.KEROGEN, 0.15).mix(MUDSTONE, 1.0).mix(Crude.Crudes.BITUMEN, 0.05), Strength.WEAK),
    COAL((Mixture)new SimpleCrude(Crude.Crudes.FIXED_CARBON, 0.65).mix(Aggregate.Aggregates.STONE, 0.15).mix(EXTRA_HEAVY_OIL, 0.2), Strength.WEAK, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    BASALTIC_MINERAL_SAND((Mixture)OreMineral.Ores.MAGNETITE.mix(IndustrialMineral.IndustrialMinerals.GARNET, 0.4).mix(OreMineral.Ores.CHROMITE, 0.2).mix(OreMineral.Ores.ILMENITE, 0.6).mix(OreMineral.Ores.RUTILE, 0.2).mix(OreMineral.Ores.ZIRCON, 0.2), Strength.WEAK, (IndustrialMaterial)Aggregate.Aggregates.SAND),
    CASSITERITE_SAND((Mixture)OreMineral.Ores.CASSITERITE.mix(OreMineral.Ores.SCHEELITE, 0.2), Strength.WEAK, (IndustrialMaterial)Aggregate.Aggregates.SAND),
    GARNET_SAND((IndustrialMineral)IndustrialMineral.IndustrialMinerals.GARNET, Strength.WEAK, Material.field_151595_p),
    GRANITIC_MINERAL_SAND((Mixture)OreMineral.Ores.MAGNETITE.mix(IndustrialMineral.IndustrialMinerals.QUARTZ, 0.4).mix(IndustrialMineral.IndustrialMinerals.KYANITE, 0.2).mix(OreMineral.Ores.ILMENITE, 0.4).mix(OreMineral.Ores.RUTILE, 0.6).mix(OreMineral.Ores.ZIRCON, 0.4).mix(OreMineral.Ores.MONAZITE, 0.4), Strength.WEAK, (IndustrialMaterial)Aggregate.Aggregates.SAND),
    QUARTZ_SAND(IndustrialMineral.IndustrialMinerals.QUARTZ, Strength.WEAK, (IndustrialMaterial)Aggregate.Aggregates.SAND, Material.field_151595_p),
    VOLCANIC_ASH((IndustrialMineral)IndustrialMineral.IndustrialMinerals.VOLCANIC_ASH, Strength.WEAK, Material.field_151595_p),
    GLAUCONITE_SAND((IndustrialMineral)IndustrialMineral.IndustrialMinerals.GLAUCONITE, Strength.WEAK, (IndustrialMaterial)Aggregate.Aggregates.SAND),
    LATERITE((Mixture)Aggregate.Aggregates.CLAY, Strength.WEAK, Material.field_151571_B),
    BAUXITE((Mixture)OreMineral.Ores.GIBBSITE.mix(OreMineral.Ores.HEMATITE, 0.45).mix(OreMineral.Ores.CALCITE, 0.1).mix(IndustrialMineral.IndustrialMinerals.KAOLINITE, 0.1).mix(IndustrialMineral.IndustrialMinerals.QUARTZ, 0.05).mix(OreMineral.Ores.ANATASE, 0.05), Strength.WEAK, (IndustrialMaterial)LATERITE),
    BENTONITE((IndustrialMineral)IndustrialMineral.IndustrialMinerals.BENTONITE, Strength.WEAK, Material.field_151571_B),
    FULLERS_EARTH((IndustrialMineral)IndustrialMineral.IndustrialMinerals.FULLERS_EARTH, Strength.WEAK, Material.field_151571_B),
    KAOLINITE((IndustrialMineral)IndustrialMineral.IndustrialMinerals.KAOLINITE, Strength.WEAK, Material.field_151571_B),
    BROWN_LIMONITE(OreMineral.Ores.LEPIDOCROCITE, Strength.WEAK, (IndustrialMaterial)LATERITE),
    YELLOW_LIMONITE(OreMineral.Ores.GOETHITE, Strength.WEAK, (IndustrialMaterial)LATERITE),
    VERMICULITE((IndustrialMineral)IndustrialMineral.IndustrialMinerals.VERMICULITE, Strength.WEAK, Material.field_151571_B),
    BORAX(OreMineral.Ores.BORAX, Strength.WEAK, null, Material.field_151576_e),
    CINNABAR((Mixture)OreMineral.Ores.CINNABAR.mix(OreMineral.Ores.PYRITE, 0.05).mix(OreMineral.Ores.REALGAR, 0.04).mix(OreMineral.Ores.STIBNITE, 0.02).mix(OreMineral.Ores.BARITE, 0.02), Strength.WEAK, (IndustrialMaterial)BASALT),
    GALENA((Mixture)OreMineral.Ores.GALENA.mix(OreMineral.Ores.SPHALERITE, 0.2).mix(OreMineral.Ores.ACANTHITE, 0.05).mix(OreMineral.Ores.FLUORITE, 0.05).mix(OreMineral.Ores.BISMUTHINITE, 0.05).mix(OreMineral.Ores.REALGAR, 0.04).mix(OreMineral.Ores.STIBNITE, 0.02).mix(OreMineral.Ores.GREENOCKITE, 0.01).mix(OreMineral.Ores.VANADINITE, 0.01), Strength.WEAK, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    MOLYBDENITE((Mixture)OreMineral.Ores.MOLYBDENITE.mix(OreMineral.Ores.PYRITE, 0.05).mix(OreMineral.Ores.CHALCOPYRITE, 0.05).mix(OreMineral.Ores.FLUORITE, 0.02), Strength.WEAK, (IndustrialMaterial)BRECCIA),
    PYROLUSITE((Mixture)OreMineral.Ores.PYROLUSITE.mix(OreMineral.Ores.GOETHITE, 0.1), Strength.WEAK, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    ROCK_SALT(OreMineral.Ores.HALITE.mix(OreMineral.Ores.SYLVITE, 0.5).mix(OreMineral.Ores.CARNALLITE, 0.1).mix(OreMineral.Ores.GYPSUM, 0.05), Strength.WEAK),
    STIBNITE((Mixture)OreMineral.Ores.STIBNITE.mix(OreMineral.Ores.PYRITE, 0.05).mix(OreMineral.Ores.GALENA, 0.05).mix(OreMineral.Ores.REALGAR, 0.04).mix(OreMineral.Ores.CINNABAR, 0.02), Strength.WEAK, (IndustrialMaterial)GRANITE),
    BARITE(OreMineral.Ores.BARITE, Strength.MEDIUM, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    BASTNASITE(OreMineral.Ores.BASTNASITE, Strength.MEDIUM, (IndustrialMaterial)CARBONATITE),
    CHALCOPYRITE((Mixture)OreMineral.Ores.CHALCOPYRITE.mix(OreMineral.Ores.PYRITE, 0.1).mix(OreMineral.Ores.MOLYBDENITE, 0.05).mix(OreMineral.Ores.COBALTITE, 0.01), Strength.MEDIUM, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    GARNIERITE(OreMineral.Ores.NEPOUITE, Strength.MEDIUM, (IndustrialMaterial)SERPENTINITE),
    LEPIDOLITE((Mixture)OreMineral.Ores.LEPIDOLITE.mix(OreMineral.Ores.SPODUMENE, 0.2), Strength.MEDIUM, (IndustrialMaterial)PEGMATITE),
    MAGNESITE((Mixture)OreMineral.Ores.MAGNESITE.mix(IndustrialMineral.IndustrialMinerals.TALC, 0.2), Strength.MEDIUM, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    PENTLANDITE((Mixture)OreMineral.Ores.PENTLANDITE.mix(OreMineral.Ores.PYRITE, 0.1), Strength.MEDIUM, (IndustrialMaterial)SERPENTINITE),
    SCHEELITE((Mixture)OreMineral.Ores.SCHEELITE.mix(OreMineral.Ores.CASSITERITE, 0.2).mix(OreMineral.Ores.WOLFRAMITE, 0.2), Strength.MEDIUM, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    SPHALERITE((Mixture)OreMineral.Ores.SPHALERITE.mix(OreMineral.Ores.GALENA, 0.2).mix(OreMineral.Ores.PYRITE, 0.1), Strength.MEDIUM, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    WOLFRAMITE((Mixture)OreMineral.Ores.WOLFRAMITE.mix(OreMineral.Ores.CASSITERITE, 0.2).mix(OreMineral.Ores.SCHEELITE, 0.2), Strength.MEDIUM, (IndustrialMaterial)PEGMATITE),
    BANDED_IRON((Mixture)OreMineral.Ores.HEMATITE.mix(OreMineral.Ores.MAGNETITE, 0.5), Strength.STRONG, (IndustrialMaterial)MUDSTONE),
    QUARTZ((IndustrialMineral)IndustrialMineral.IndustrialMinerals.QUARTZ, Strength.STRONG, (IndustrialMaterial)GRANITE),
    CASSITERITE((Mixture)OreMineral.Ores.CASSITERITE.mix(OreMineral.Ores.FLUORITE, 0.1).mix(OreMineral.Ores.WOLFRAMITE, 0.1).mix(IndustrialMineral.IndustrialMinerals.APATITE, 0.05).mix(OreMineral.Ores.MOLYBDENITE, 0.05), Strength.STRONG, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    CHROMITE((Mixture)OreMineral.Ores.CHROMITE.mix(SERPENTINITE, 0.5).mix(OreMineral.Ores.MAGNETITE, 0.1), Strength.STRONG, (IndustrialMaterial)SERPENTINITE),
    ILMENITE((Mixture)OreMineral.Ores.ILMENITE.mix(OreMineral.Ores.RUTILE, 0.2).mix(OreMineral.Ores.MAGNETITE, 0.1), Strength.STRONG, (IndustrialMaterial)DIORITE),
    MAGNETITE(OreMineral.Ores.MAGNETITE, Strength.STRONG, (IndustrialMaterial)GRANITE),
    POLLUCITE((Mixture)OreMineral.Ores.POLLUCITE.mix(OreMineral.Ores.SPODUMENE, 0.1), Strength.STRONG, (IndustrialMaterial)PEGMATITE),
    SPODUMENE((Mixture)OreMineral.Ores.SPODUMENE.mix(OreMineral.Ores.LEPIDOLITE, 0.1), Strength.STRONG, (IndustrialMaterial)PEGMATITE),
    TANTALITE((Mixture)OreMineral.Ores.TANTALITE.mix(OreMineral.Ores.COLUMBITE, 2.0), Strength.STRONG, (IndustrialMaterial)PEGMATITE),
    PITCHBLENDE((Mixture)OreMineral.Ores.URANINITE.mix(OreMineral.Ores.CARNOTITE, 0.05), Strength.STRONG, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    VANADIUM_MAGNETITE(OreMineral.Ores.TITANO_MAGNETITE, Strength.STRONG, (IndustrialMaterial)PERIDOTITE),
    CHRYSOTILE(IndustrialMineral.IndustrialMinerals.CHRYSOTILE.mix(SERPENTINITE, 0.5), Strength.WEAK),
    DIATOMITE(IndustrialMineral.IndustrialMinerals.DIATOMITE, Strength.WEAK),
    REALGAR((Mixture)OreMineral.Ores.REALGAR.mix(OreMineral.Ores.ORPIMENT, 0.1).mix(OreMineral.Ores.STIBNITE, 0.04).mix(OreMineral.Ores.CINNABAR, 0.04), Strength.WEAK, (IndustrialMaterial)GRANITE),
    GRAPHITE(IndustrialMineral.IndustrialMinerals.GRAPHITE.mix(COAL, 0.5), Strength.WEAK),
    GYPSUM(IndustrialMineral.IndustrialMinerals.GYPSUM.mix(OreMineral.Ores.HALITE, 0.05), Strength.WEAK),
    MIRABILITE(IndustrialMineral.IndustrialMinerals.MIRABILITE.mix(IndustrialMineral.IndustrialMinerals.GYPSUM, 0.2).mix(OreMineral.Ores.HALITE, 0.05), Strength.WEAK),
    MICA((IndustrialMineral)IndustrialMineral.IndustrialMinerals.MICA, Strength.WEAK, (IndustrialMaterial)PEGMATITE),
    SOAPSTONE((IndustrialMineral)IndustrialMineral.IndustrialMinerals.TALC, Strength.WEAK, (IndustrialMaterial)SERPENTINITE),
    TRONA(IndustrialMineral.IndustrialMinerals.TRONA.mix(IndustrialMineral.IndustrialMinerals.GYPSUM, 0.2).mix(OreMineral.Ores.HALITE, 0.05), Strength.WEAK),
    ALUNITE(IndustrialMineral.IndustrialMinerals.ALUNITE.mix(IndustrialMineral.IndustrialMinerals.BENTONITE, 0.1), Strength.MEDIUM),
    CELESTINE((Mixture)OreMineral.Ores.CELESTINE.mix(IndustrialMineral.IndustrialMinerals.GYPSUM, 0.2).mix(OreMineral.Ores.HALITE, 0.05), Strength.MEDIUM, (IndustrialMaterial)GYPSUM),
    DOLOMITE(IndustrialMineral.IndustrialMinerals.DOLOMITE.mix(OreMineral.Ores.MAGNESITE, 0.05), Strength.MEDIUM),
    FLUORITE((Mixture)OreMineral.Ores.FLUORITE.mix(OreMineral.Ores.SPHALERITE, 0.06).mix(OreMineral.Ores.GALENA, 0.02), Strength.MEDIUM, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    WOLLASTONITE(IndustrialMineral.IndustrialMinerals.WOLLASTONITE.mix(OreMineral.Ores.CALCITE, 0.1), Strength.MEDIUM),
    ZEOLITE(IndustrialMineral.IndustrialMinerals.ZEOLITE, Strength.MEDIUM),
    APATITE((IndustrialMineral)IndustrialMineral.IndustrialMinerals.APATITE, Strength.STRONG, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    KYANITE((IndustrialMineral)IndustrialMineral.IndustrialMinerals.KYANITE, Strength.STRONG, (IndustrialMaterial)PEGMATITE),
    PERLITE((IndustrialMineral)IndustrialMineral.IndustrialMinerals.PERLITE, Strength.STRONG, (IndustrialMaterial)Aggregate.Aggregates.OBSIDIAN),
    PUMICE(IndustrialMineral.IndustrialMinerals.PUMICE, Strength.STRONG),
    PYRITE((Mixture)OreMineral.Ores.PYRITE.mix(OreMineral.Ores.CHALCOPYRITE, 0.05).mix(OreMineral.Ores.SPHALERITE, 0.05), Strength.STRONG, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    GOLD((Mixture)new SimpleVanillaOre(OreMineral.Ores.GOLD), Strength.STRONG, (IndustrialMaterial)Aggregate.Aggregates.STONE),
    LAPIS((Mixture)new SimpleVanillaOre(IndustrialMineral.IndustrialMinerals.LAZURITE.mix(OreMineral.Ores.CALCITE, 0.4).mix(IndustrialMineral.IndustrialMinerals.SODALITE, 0.4).mix(OreMineral.Ores.PYRITE, 0.2)), Strength.STRONG, (IndustrialMaterial)GRANITE),
    DIAMOND((Mixture)new SimpleVanillaOre(IndustrialMineral.IndustrialMinerals.DIAMOND), Strength.STRONG, (IndustrialMaterial)PERIDOTITE),
    EMERALD((Mixture)new SimpleVanillaOre(OreMineral.Ores.BERYL), Strength.STRONG, (IndustrialMaterial)PEGMATITE),
    REDSTONE((Mixture)new SimpleVanillaOre(OreMineral.Ores.CUPRITE.mix(OreMineral.Ores.CHALCOPYRITE, 0.25).mix(IndustrialMineral.IndustrialMinerals.AZURITE, 0.1).mix(OreMineral.Ores.MALACHITE, 0.1)), Strength.STRONG, (IndustrialMaterial)Aggregate.Aggregates.STONE);

    private Strength strength;
    private Material blockMaterial;
    private Mixture composition;
    private IndustrialMaterial host;

    private GeoMaterial(Mixture composition, Strength strength, IndustrialMaterial host, Material blockMaterial) {
        this.composition = composition;
        this.strength = strength;
        this.host = host;
        this.blockMaterial = blockMaterial;
    }

    private GeoMaterial(Mixture composition, Strength strength, Material blockMaterial) {
        this(composition, strength, null, blockMaterial);
    }

    private GeoMaterial(Mixture composition, Strength strength, IndustrialMaterial host) {
        this(composition, strength, host, GeoMaterial.blockMaterialFromHost(host));
    }

    private GeoMaterial(Mixture composition, Strength strength) {
        this(composition, strength, Material.field_151576_e);
    }

    private GeoMaterial(OreMineral composition, Strength strength, IndustrialMaterial host, Material blockMaterial) {
        this(new SimpleOre(composition), strength, host, blockMaterial);
    }

    private GeoMaterial(OreMineral composition, Strength strength, IndustrialMaterial host) {
        this(composition, strength, host, GeoMaterial.blockMaterialFromHost(host));
    }

    private GeoMaterial(IndustrialMineral composition, Strength strength, IndustrialMaterial host, Material blockMaterial) {
        this(new SimpleOre(composition), strength, host, blockMaterial);
    }

    private GeoMaterial(IndustrialMineral composition, Strength strength, IndustrialMaterial host) {
        this(composition, strength, host, GeoMaterial.blockMaterialFromHost(host));
    }

    private GeoMaterial(IndustrialMineral composition, Strength strength, Material blockMaterial) {
        this(composition, strength, null, blockMaterial);
    }

    private GeoMaterial(IndustrialMineral composition, Strength strength) {
        this(composition, strength, Material.field_151576_e);
    }

    public int getId() {
        return this.ordinal();
    }

    public Strength getStrength() {
        return this.strength;
    }

    public Material getBlockMaterial() {
        return this.blockMaterial;
    }

    public String getLowerName() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
    }

    @Override
    public String getOreDictKey() {
        return this.composition.getOreDictKey();
    }

    public static GeoMaterial getForId(int id) {
        return GeoMaterial.values()[id];
    }

    public IndustrialMaterial getComposition() {
        return this.composition;
    }

    public IndustrialMaterial getHost() {
        return this.host;
    }

    public static List<GeoMaterial> lookup(Strength strength, Class<? extends IndustrialMaterial> compositionType, Material blockMaterial) {
        ArrayList<GeoMaterial> materialsToReturn = new ArrayList<GeoMaterial>();
        for (GeoMaterial material : GeoMaterial.values()) {
            if (material.blockMaterial != blockMaterial || material.strength != strength || !compositionType.isAssignableFrom(material.composition.getClass())) continue;
            materialsToReturn.add(material);
        }
        return materialsToReturn;
    }

    @Override
    public ConditionProperties getProperties(Condition condition) {
        return this.composition.getProperties(condition);
    }

    @Override
    public List<MixtureComponent> getComponents() {
        return this.composition.getComponents();
    }

    @Override
    public Mixture mix(IndustrialMaterial material, double weight) {
        return this.composition.mix(material, weight);
    }

    private static Material blockMaterialFromHost(IndustrialMaterial host) {
        Material material = Material.field_151576_e;
        if (host == Aggregate.Aggregates.SAND) {
            material = Material.field_151595_p;
        } else if (host == Aggregate.Aggregates.STONE || host == Aggregate.Aggregates.OBSIDIAN) {
            material = Material.field_151576_e;
        } else if (host instanceof GeoMaterial) {
            material = ((GeoMaterial)host).getBlockMaterial();
        }
        return material;
    }

    public static enum Strength {
        WEAK,
        MEDIUM,
        STRONG,
        VERY_STRONG;


        public String getCamelName() {
            if (this == VERY_STRONG) {
                return "veryStrong";
            }
            return this.name().toLowerCase();
        }
    }
}

