/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.geologica.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.pfaa.block.CompositeBlock;
import org.pfaa.chemica.model.IndustrialMaterial;
import org.pfaa.geologica.GeoMaterial;
import org.pfaa.geologica.Geologica;
import org.pfaa.geologica.block.ChanceDropRegistry;
import org.pfaa.geologica.block.GeoBlockAccessors;
import org.pfaa.geologica.processing.Aggregate;
import org.pfaa.util.BlockWithMeta;

public abstract class GeoBlock
extends CompositeBlock
implements GeoBlockAccessors {
    private List<GeoMaterial> materials = new ArrayList<GeoMaterial>();
    private GeoMaterial.Strength strength;
    private Class<? extends IndustrialMaterial> composition;
    private static Map<GeoMaterial, BlockWithMeta<GeoBlock>> materialToNativeBlock = new HashMap<GeoMaterial, BlockWithMeta<GeoBlock>>();

    public GeoBlock(GeoMaterial.Strength strength, Class<? extends IndustrialMaterial> composition, Material material) {
        super(material);
        this.strength = strength;
        this.composition = composition;
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.setGeoMaterials();
        this.func_149711_c(this.determineHardness());
        this.func_149752_b(this.determineResistance());
        this.func_149672_a(this.determineStepSound());
        this.setHarvestLevel(this.determineHarvestTool(), this.determineHarvestLevel());
    }

    protected float determineResistance() {
        return Geologica.getConfiguration().getRockResistance(this.strength);
    }

    protected Block.SoundType determineStepSound() {
        Block.SoundType sound = null;
        if (this.field_149764_J == Material.field_151576_e) {
            sound = field_149769_e;
        } else if (this.field_149764_J == Material.field_151595_p) {
            sound = field_149776_m;
        } else if (this.field_149764_J == Material.field_151571_B) {
            sound = field_149767_g;
        }
        return sound;
    }

    protected float determineHardness() {
        float hardness = 0.0f;
        if (this.field_149764_J == Material.field_151576_e) {
            hardness = this.determineRockHardness();
        } else if (this.field_149764_J == Material.field_151571_B) {
            hardness = this.determineClayHardness();
        } else if (this.field_149764_J == Material.field_151595_p) {
            hardness = this.determineSandHardness();
        }
        return hardness;
    }

    private float determineRockHardness() {
        return Geologica.getConfiguration().getRockHardness(this.strength);
    }

    private float determineClayHardness() {
        return 0.7f;
    }

    private float determineSandHardness() {
        return 0.6f;
    }

    public String determineHarvestTool() {
        if (this.field_149764_J == Material.field_151576_e) {
            return "pickaxe";
        }
        return "shovel";
    }

    private int determineHarvestLevel() {
        return Geologica.getConfiguration().getHarvestLevel(this.composition, this.strength);
    }

    public boolean hasComposition(Class<? extends IndustrialMaterial> composition) {
        return composition.isAssignableFrom(this.composition);
    }

    private void setGeoMaterials() {
        List<GeoMaterial> materials = GeoMaterial.lookup(this.strength, this.composition, this.field_149764_J);
        if (materials.size() > 16) {
            materials = materials.subList(0, 16);
        }
        this.materials.clear();
        this.materials.addAll(materials);
    }

    public List<GeoMaterial> getGeoMaterials() {
        return Collections.unmodifiableList(this.materials);
    }

    @Override
    public GeoMaterial getGeoMaterial(int meta) {
        return this.materials.get(meta);
    }

    public GeoMaterial getGeoMaterial(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.getGeoMaterial(meta);
    }

    @Override
    public boolean containsGeoMaterial(GeoMaterial material) {
        return this.materials.contains(material);
    }

    @Override
    public int getMeta(GeoMaterial material) {
        return this.materials.indexOf(material);
    }

    @Override
    public int getMetaCount() {
        return this.materials.size();
    }

    @Override
    public String getBlockNameSuffix(int meta) {
        return this.getGeoMaterial(meta).getLowerName();
    }

    public ItemStack getItemStack(GeoMaterial material) {
        return new ItemStack((Block)this, 1, this.getMeta(material));
    }

    public GeoMaterial.Strength getStrength() {
        return this.strength;
    }

    public Class<? extends IndustrialMaterial> getComposition() {
        return this.composition;
    }

    public Material func_149688_o() {
        return this.field_149764_J;
    }

    public boolean isReplaceableOreGen(World world, int x, int y, int z, Block target) {
        return Aggregate.class.isAssignableFrom(this.composition);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        GeoMaterial material = this.getGeoMaterial(metadata);
        ArrayList<ItemStack> drops = ChanceDropRegistry.instance().getDrops(material, world.field_73012_v, fortune);
        if (drops != null) {
            return drops;
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IIcon getUnderlayIcon(IBlockAccess world, int x, int y, int z, int side) {
        IIcon icon;
        int meta = world.func_72805_g(x, y, z);
        IndustrialMaterial host = this.getGeoMaterial(meta).getHost();
        if (host != null && (icon = this.getHostIcon(host, world, x, y, z)) != null) {
            return icon;
        }
        return this.getUnderlayIcon(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getHostIcon(IndustrialMaterial host, IBlockAccess world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean useMultipassRendering() {
        return this.needsHost();
    }

    private boolean needsHost() {
        return !Aggregate.class.isAssignableFrom(this.getComposition());
    }

    private static Block getBlockForAggregate(Aggregate host) {
        if (host == Aggregate.Aggregates.STONE) {
            return Blocks.field_150348_b;
        }
        if (host == Aggregate.Aggregates.SAND) {
            return Blocks.field_150354_m;
        }
        if (host == Aggregate.Aggregates.CLAY) {
            return Blocks.field_150435_aG;
        }
        if (host == Aggregate.Aggregates.GRAVEL) {
            return Blocks.field_150351_n;
        }
        if (host == Aggregate.Aggregates.DIRT) {
            return Blocks.field_150346_d;
        }
        if (host == Aggregate.Aggregates.OBSIDIAN) {
            return Blocks.field_150343_Z;
        }
        return null;
    }

    @Override
    protected IIcon registerUnderlayIcon(IIconRegister registry, int i) {
        Block block;
        IndustrialMaterial host = this.getGeoMaterial(i).getHost();
        if (host instanceof GeoMaterial) {
            GeoMaterial material = (GeoMaterial)host;
            BlockWithMeta<GeoBlock> blockWithMeta = GeoBlock.getNative(material);
            return ((GeoBlock)blockWithMeta.block).registerMetaIcon(registry, blockWithMeta.meta);
        }
        if (host instanceof Aggregate && (block = GeoBlock.getBlockForAggregate((Aggregate)host)) != null) {
            return block.func_149691_a(0, 0);
        }
        return super.registerMetaIcon(registry, i);
    }

    public static GeoBlock registerNative(GeoBlock block) {
        List<GeoMaterial> materials = block.getGeoMaterials();
        int meta = 0;
        for (GeoMaterial key : materials) {
            materialToNativeBlock.put(key, new BlockWithMeta<GeoBlock>(block, meta++));
        }
        return block;
    }

    public static BlockWithMeta<GeoBlock> getNative(GeoMaterial material) {
        return materialToNativeBlock.get(material);
    }
}

