/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.fluid;

import com.google.common.base.CaseFormat;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.pfaa.chemica.fluid.IndustrialFluid;

public class FilledGlassBottleItem
extends ItemPotion {
    public FilledGlassBottleItem() {
        this.func_111206_d("potion");
        this.func_77625_d(64);
    }

    private Fluid getFluidForItemStack(ItemStack itemStack) {
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
        return fluidStack.getFluid();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int renderPass) {
        if (renderPass > 0) {
            return super.func_82790_a(itemStack, renderPass);
        }
        return this.getFluidForItemStack(itemStack).getBlock().func_149720_d(null, 0, 0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack p_77636_1_) {
        return false;
    }

    public List<PotionEffect> func_77832_l(ItemStack itemStack) {
        Fluid fluid = this.getFluidForItemStack(itemStack);
        if (fluid instanceof IndustrialFluid) {
            return ((IndustrialFluid)fluid).getProperties().hazard.getIngestionEffects();
        }
        return Collections.EMPTY_LIST;
    }

    public List<PotionEffect> func_77834_f(int damage) {
        return this.func_77832_l(new ItemStack((Item)this, 1, damage));
    }

    public String func_77667_c(ItemStack itemStack) {
        String fluidToken = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.getFluidForItemStack(itemStack).getName());
        return "item." + fluidToken + "Bottle";
    }

    public String func_77653_i(ItemStack p_77653_1_) {
        return StatCollector.func_74838_a((String)(this.func_77667_c(p_77653_1_) + ".name")).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemStacks) {
        Collection fluids = FluidRegistry.getRegisteredFluids().values();
        for (Fluid fluid : fluids) {
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)FluidContainerRegistry.EMPTY_BOTTLE);
            if (filledContainer == null) continue;
            itemStacks.add(filledContainer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List lines, boolean p_77624_4_) {
        Fluid fluid = this.getFluidForItemStack(itemStack);
        if (fluid instanceof IndustrialFluid) {
            IndustrialFluid industrialFluid = (IndustrialFluid)fluid;
            lines.add(EnumChatFormatting.BLUE + I18n.func_135052_a((String)"label.hazard.health", (Object[])new Object[0]) + ": " + industrialFluid.getProperties().hazard.health);
        }
    }
}

