/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.model;

import java.awt.Color;
import net.minecraftforge.fluids.FluidRegistry;
import org.pfaa.chemica.model.Condition;
import org.pfaa.chemica.model.Hazard;
import org.pfaa.chemica.model.Phase;
import org.pfaa.chemica.util.ColorUtils;

public class PhaseProperties {
    private final Phase phase;
    private final Color color;
    private final Hazard hazard;
    private final double density;
    private final boolean opaque;
    public static final int MIN_GLOWING_TEMPERATURE = 750;
    private static final int RED_TEMPERATURE = 950;
    private static final int YELLOW_TEMPERATURE = 1450;
    private static final int WHITE_TEMPERATURE = 1650;

    public PhaseProperties(Phase phase, Color color, double density, Hazard hazard, boolean opaque) {
        this.phase = phase;
        this.color = color;
        this.density = density;
        this.hazard = hazard;
        this.opaque = opaque;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public Color getColor() {
        return this.color;
    }

    public Hazard getHazard() {
        return this.hazard;
    }

    public Color getColor(double temperature) {
        return this.addThermalRadiation(this.color, temperature);
    }

    public double getDensity(Condition condition) {
        return this.density;
    }

    public double getViscosity(double temperature) {
        return this.phase == Phase.SOLID ? Double.POSITIVE_INFINITY : Double.NaN;
    }

    public int getLuminosity(double temperature) {
        if (temperature > 750.0) {
            double tempToLuminosity = FluidRegistry.LAVA.getLuminosity() / FluidRegistry.LAVA.getTemperature();
            return (int)(temperature * tempToLuminosity);
        }
        return 0;
    }

    private Color addThermalRadiation(Color color, double temperature) {
        if (temperature > 750.0) {
            color = ColorUtils.blendColors(color, Color.RED, temperature / 950.0);
            if (temperature > 950.0) {
                color = ColorUtils.blendColors(color, Color.YELLOW, temperature / 1450.0);
                if (temperature > 1450.0) {
                    color = ColorUtils.blendColors(color, Color.WHITE, temperature / 1650.0);
                }
            }
        }
        return color;
    }

    public boolean getOpaque() {
        return this.opaque;
    }
}

