/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.model;

import org.pfaa.chemica.model.Chemical;
import org.pfaa.chemica.model.ChemicalConditionProperties;
import org.pfaa.chemica.model.ChemicalPhaseProperties;
import org.pfaa.chemica.model.Condition;
import org.pfaa.chemica.model.Formula;
import org.pfaa.chemica.model.Fusion;
import org.pfaa.chemica.model.IndustrialMaterial;
import org.pfaa.chemica.model.Mixture;
import org.pfaa.chemica.model.Phase;
import org.pfaa.chemica.model.SimpleMixture;
import org.pfaa.chemica.model.Vaporization;

public class SimpleChemical
implements Chemical {
    private Formula formula;
    private String oreDictKey;
    private Fusion fusion;
    private Vaporization vaporization;
    private ChemicalPhaseProperties solid;
    private ChemicalPhaseProperties liquid;
    private ChemicalPhaseProperties gas;

    public SimpleChemical(Formula formula, String oreDictKey, ChemicalPhaseProperties.Solid solid) {
        this(formula, oreDictKey, solid, null, null, null, null);
    }

    public SimpleChemical(Formula formula, String oreDictKey, ChemicalPhaseProperties.Solid solid, Fusion fusion, ChemicalPhaseProperties.Liquid liquid, Vaporization vaporization, ChemicalPhaseProperties.Gas gas) {
        this.formula = formula;
        this.oreDictKey = oreDictKey == null ? formula.toString() : oreDictKey;
        this.solid = solid;
        this.fusion = fusion;
        this.liquid = liquid;
        this.vaporization = vaporization;
        this.gas = gas == null ? null : new ChemicalPhaseProperties.Gas(gas, formula.getMolarMass());
    }

    @Override
    public String getOreDictKey() {
        return this.oreDictKey;
    }

    @Override
    public Fusion getFusion() {
        return this.fusion;
    }

    @Override
    public Vaporization getVaporization() {
        return this.vaporization;
    }

    @Override
    public Formula getFormula() {
        return this.formula;
    }

    private Phase getPhaseForCondition(Condition condition) {
        if (this.vaporization != null && condition.temperature > this.vaporization.getTemperature(condition.pressure)) {
            return Phase.GAS;
        }
        if (this.fusion != null && condition.temperature > this.fusion.getTemperature()) {
            return Phase.LIQUID;
        }
        return Phase.SOLID;
    }

    @Override
    public ChemicalConditionProperties getProperties(Condition condition) {
        Phase phase = this.getPhaseForCondition(condition);
        return new ChemicalConditionProperties(this.getPhaseProperties(phase), condition);
    }

    private ChemicalPhaseProperties getPhaseProperties(Phase phase) {
        switch (phase) {
            case SOLID: {
                return this.solid;
            }
            case LIQUID: {
                return this.liquid;
            }
            case GAS: {
                return this.gas;
            }
        }
        throw new IllegalArgumentException("Unknown phase: " + (Object)((Object)phase));
    }

    @Override
    public String name() {
        return this.formula.toString();
    }

    @Override
    public Mixture mix(IndustrialMaterial material, double weight) {
        return new SimpleMixture(this).mix(material, weight);
    }
}

