/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.model;

public class Vaporization {
    private double temperature;
    private AntoineCoefficients antoineCoefficients;

    public Vaporization(AntoineCoefficients antoineCoefficients) {
        this.antoineCoefficients = antoineCoefficients;
    }

    public Vaporization(double a, double b, double c) {
        this(new AntoineCoefficients(a, b, c));
    }

    public Vaporization(double temperature) {
        this.temperature = temperature;
    }

    public double getTemperature() {
        return this.getTemperature(101.0);
    }

    public double getTemperature(double pressure) {
        if (this.antoineCoefficients != null) {
            return this.antoineCoefficients.getBoilingTemperature(pressure);
        }
        return this.temperature;
    }

    public AntoineCoefficients getAntoineCoefficients() {
        return this.antoineCoefficients;
    }

    public static class AntoineCoefficients {
        private double a;
        private double b;
        private double c;
        private static int KPA_PER_BAR = 100;

        public AntoineCoefficients(double a, double b, double c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public double getVaporPressure(double temperature) {
            return Math.pow(this.a - this.b / (this.c + temperature), 10.0) * (double)KPA_PER_BAR;
        }

        public double getBoilingTemperature(double pressure) {
            return this.b / (this.a - Math.log10(pressure / (double)KPA_PER_BAR)) - this.c;
        }

        public double getEvaporationRate(double temperature, double pressure, double molecularWeight) {
            return (this.getVaporPressure(temperature) - pressure) * Math.sqrt(molecularWeight / (0.05223840264389108 * temperature));
        }
    }
}

