/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.geologica;

import cpw.mods.fml.common.LoaderException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import org.pfaa.block.CompositeBlock;
import org.pfaa.chemica.block.IndustrialFluidBlock;
import org.pfaa.chemica.fluid.IndustrialFluid;
import org.pfaa.chemica.model.Condition;
import org.pfaa.chemica.model.IndustrialMaterial;
import org.pfaa.geologica.GeoMaterial;
import org.pfaa.geologica.Geologica;
import org.pfaa.geologica.block.BrickGeoBlock;
import org.pfaa.geologica.block.BrokenGeoBlock;
import org.pfaa.geologica.block.GeoBlock;
import org.pfaa.geologica.block.IntactGeoBlock;
import org.pfaa.geologica.block.LooseGeoBlock;
import org.pfaa.geologica.block.SlabBlock;
import org.pfaa.geologica.block.StairsBlock;
import org.pfaa.geologica.block.VanillaOreOverrideBlock;
import org.pfaa.geologica.block.WallBlock;
import org.pfaa.geologica.processing.Aggregate;
import org.pfaa.geologica.processing.Crude;
import org.pfaa.geologica.processing.Ore;
import org.pfaa.geologica.processing.VanillaOre;

public class GeologicaBlocks {
    public static final GeoBlock WEAK_STONE = GeologicaBlocks.createStoneBlock(GeoMaterial.Strength.WEAK);
    public static final GeoBlock MEDIUM_STONE = GeologicaBlocks.createStoneBlock(GeoMaterial.Strength.MEDIUM);
    public static final GeoBlock STRONG_STONE = GeologicaBlocks.createStoneBlock(GeoMaterial.Strength.STRONG);
    public static final GeoBlock VERY_STRONG_STONE = GeologicaBlocks.createStoneBlock(GeoMaterial.Strength.VERY_STRONG);
    public static final GeoBlock MEDIUM_COBBLE = GeologicaBlocks.createCobbleBlock(GeoMaterial.Strength.MEDIUM);
    public static final GeoBlock STRONG_COBBLE = GeologicaBlocks.createCobbleBlock(GeoMaterial.Strength.STRONG);
    public static final GeoBlock VERY_STRONG_COBBLE = GeologicaBlocks.createCobbleBlock(GeoMaterial.Strength.VERY_STRONG);
    public static final GeoBlock MEDIUM_STONE_BRICK = GeologicaBlocks.createStoneBrickBlock(GeoMaterial.Strength.MEDIUM);
    public static final GeoBlock STRONG_STONE_BRICK = GeologicaBlocks.createStoneBrickBlock(GeoMaterial.Strength.STRONG);
    public static final GeoBlock VERY_STRONG_STONE_BRICK = GeologicaBlocks.createStoneBrickBlock(GeoMaterial.Strength.VERY_STRONG);
    public static final SlabBlock MEDIUM_COBBLE_SLAB = GeologicaBlocks.createSlabBlock(MEDIUM_COBBLE, null);
    public static final SlabBlock MEDIUM_COBBLE_DOUBLE_SLAB = GeologicaBlocks.createSlabBlock(MEDIUM_COBBLE, MEDIUM_COBBLE_SLAB);
    public static final SlabBlock STRONG_COBBLE_SLAB = GeologicaBlocks.createSlabBlock(STRONG_COBBLE, null);
    public static final SlabBlock VERY_STRONG_COBBLE_SLAB = GeologicaBlocks.createSlabBlock(VERY_STRONG_COBBLE, null);
    public static final SlabBlock STRONG_COBBLE_DOUBLE_SLAB = GeologicaBlocks.createSlabBlock(STRONG_COBBLE, STRONG_COBBLE_SLAB);
    public static final SlabBlock VERY_STRONG_COBBLE_DOUBLE_SLAB = GeologicaBlocks.createSlabBlock(VERY_STRONG_COBBLE, VERY_STRONG_COBBLE_SLAB);
    public static final SlabBlock MEDIUM_STONE_BRICK_SLAB = GeologicaBlocks.createSlabBlock(MEDIUM_STONE_BRICK, null);
    public static final SlabBlock MEDIUM_STONE_BRICK_DOUBLE_SLAB = GeologicaBlocks.createSlabBlock(MEDIUM_STONE_BRICK, MEDIUM_STONE_BRICK_SLAB);
    public static final SlabBlock STRONG_STONE_BRICK_SLAB = GeologicaBlocks.createSlabBlock(STRONG_STONE_BRICK, null);
    public static final SlabBlock STRONG_STONE_BRICK_DOUBLE_SLAB = GeologicaBlocks.createSlabBlock(STRONG_STONE_BRICK, STRONG_STONE_BRICK_SLAB);
    public static final SlabBlock VERY_STRONG_STONE_BRICK_SLAB = GeologicaBlocks.createSlabBlock(VERY_STRONG_STONE_BRICK, null);
    public static final SlabBlock VERY_STRONG_STONE_BRICK_DOUBLE_SLAB = GeologicaBlocks.createSlabBlock(VERY_STRONG_STONE_BRICK, VERY_STRONG_STONE_BRICK_SLAB);
    public static final SlabBlock MEDIUM_STONE_SLAB = GeologicaBlocks.createSlabBlock(MEDIUM_STONE, null);
    public static final SlabBlock MEDIUM_STONE_DOUBLE_SLAB = GeologicaBlocks.createSlabBlock(MEDIUM_STONE, MEDIUM_STONE_SLAB);
    public static final SlabBlock STRONG_STONE_SLAB = GeologicaBlocks.createSlabBlock(STRONG_STONE, null);
    public static final SlabBlock STRONG_STONE_DOUBLE_SLAB = GeologicaBlocks.createSlabBlock(STRONG_STONE, STRONG_STONE_SLAB);
    public static final SlabBlock VERY_STRONG_STONE_SLAB = GeologicaBlocks.createSlabBlock(VERY_STRONG_STONE, null);
    public static final SlabBlock VERY_STRONG_STONE_DOUBLE_SLAB = GeologicaBlocks.createSlabBlock(VERY_STRONG_STONE, VERY_STRONG_STONE_SLAB);
    public static final Block MEDIUM_COBBLE_WALL = GeologicaBlocks.createWallBlock(MEDIUM_COBBLE);
    public static final Block STRONG_COBBLE_WALL = GeologicaBlocks.createWallBlock(STRONG_COBBLE);
    public static final Block VERY_STRONG_COBBLE_WALL = GeologicaBlocks.createWallBlock(VERY_STRONG_COBBLE);
    public static final Block MEDIUM_STONE_BRICK_WALL = GeologicaBlocks.createWallBlock(MEDIUM_STONE_BRICK);
    public static final Block STRONG_STONE_BRICK_WALL = GeologicaBlocks.createWallBlock(STRONG_STONE_BRICK);
    public static final Block VERY_STRONG_STONE_BRICK_WALL = GeologicaBlocks.createWallBlock(VERY_STRONG_STONE_BRICK);
    public static final StairsBlock MEDIUM_COBBLE_STAIRS__LIMESTONE = GeologicaBlocks.createStairsBlock(MEDIUM_COBBLE, GeoMaterial.LIMESTONE);
    public static final StairsBlock STRONG_COBBLE_STAIRS__GRANITE = GeologicaBlocks.createStairsBlock(STRONG_COBBLE, GeoMaterial.GRANITE);
    public static final StairsBlock STRONG_COBBLE_STAIRS__MARBLE = GeologicaBlocks.createStairsBlock(STRONG_COBBLE, GeoMaterial.MARBLE);
    public static final StairsBlock MEDIUM_STONE_BRICK_STAIRS__LIMESTONE = GeologicaBlocks.createStairsBlock(MEDIUM_STONE_BRICK, GeoMaterial.LIMESTONE);
    public static final StairsBlock STRONG_STONE_BRICK_STAIRS__GRANITE = GeologicaBlocks.createStairsBlock(STRONG_STONE_BRICK, GeoMaterial.GRANITE);
    public static final StairsBlock STRONG_STONE_BRICK_STAIRS__MARBLE = GeologicaBlocks.createStairsBlock(STRONG_STONE_BRICK, GeoMaterial.MARBLE);
    public static final GeoBlock WEAK_RUBBLE = GeologicaBlocks.createRubbleBlock(GeoMaterial.Strength.WEAK);
    public static final GeoBlock WEAK_ORE_SAND = GeologicaBlocks.createOreSandBlock();
    public static final GeoBlock WEAK_ORE_ROCK = GeologicaBlocks.createOreRockBlock(GeoMaterial.Strength.WEAK);
    public static final GeoBlock MEDIUM_ORE_ROCK = GeologicaBlocks.createOreRockBlock(GeoMaterial.Strength.MEDIUM);
    public static final GeoBlock STRONG_ORE_ROCK = GeologicaBlocks.createOreRockBlock(GeoMaterial.Strength.STRONG);
    public static final GeoBlock WEAK_CLAY = GeologicaBlocks.createClayBlock();
    public static final GeoBlock WEAK_ORE_CLAY = GeologicaBlocks.createOreClayBlock();
    public static final GeoBlock WEAK_CLAY_BRICK = GeologicaBlocks.createClayBrickBlock();
    public static final IndustrialFluidBlock LIGHT_OIL = GeologicaBlocks.createFluidBlock(GeoMaterial.LIGHT_OIL);
    public static final IndustrialFluidBlock MEDIUM_OIL = GeologicaBlocks.createFluidBlock(GeoMaterial.MEDIUM_OIL);
    public static final IndustrialFluidBlock HEAVY_OIL = GeologicaBlocks.createFluidBlock(GeoMaterial.HEAVY_OIL);
    public static final IndustrialFluidBlock EXTRA_HEAVY_OIL = GeologicaBlocks.createFluidBlock(GeoMaterial.EXTRA_HEAVY_OIL);
    public static final IndustrialFluidBlock NATURAL_GAS = GeologicaBlocks.createFluidBlock(GeoMaterial.NATURAL_GAS);
    public static final GeoBlock CRUDE_SAND = GeologicaBlocks.createCrudeSandBlock();
    public static final GeoBlock CRUDE_ROCK = GeologicaBlocks.createCrudeRockBlock();
    public static final VanillaOreOverrideBlock COAL_ORE = new VanillaOreOverrideBlock(Blocks.field_150365_q);
    public static final VanillaOreOverrideBlock DIAMOND_ORE = new VanillaOreOverrideBlock(Blocks.field_150482_ag);
    public static final VanillaOreOverrideBlock EMERALD_ORE = new VanillaOreOverrideBlock(Blocks.field_150412_bA);
    public static final VanillaOreOverrideBlock LAPIS_ORE = new VanillaOreOverrideBlock(Blocks.field_150369_x);
    public static final VanillaOreOverrideBlock REDSTONE_ORE = new VanillaOreOverrideBlock(Blocks.field_150450_ax);
    public static final GeoBlock VANILLA_ORE_ROCK = GeologicaBlocks.createVanillaOreRockBlock();

    private static GeoBlock createStoneBlock(GeoMaterial.Strength strength) {
        return GeoBlock.registerNative(GeologicaBlocks.createGeoBlock(IntactGeoBlock.class, strength, Aggregate.class, Material.field_151576_e));
    }

    private static GeoBlock createCobbleBlock(GeoMaterial.Strength strength) {
        return GeologicaBlocks.createGeoBlock(BrokenGeoBlock.class, strength, Aggregate.class, Material.field_151576_e);
    }

    private static GeoBlock createStoneBrickBlock(GeoMaterial.Strength strength) {
        return GeologicaBlocks.createGeoBlock(BrickGeoBlock.class, strength, Aggregate.class, Material.field_151576_e);
    }

    private static GeoBlock createRubbleBlock(GeoMaterial.Strength strength) {
        return GeologicaBlocks.createGeoBlock(LooseGeoBlock.class, strength, Aggregate.class, Material.field_151576_e);
    }

    private static GeoBlock createOreSandBlock() {
        return GeologicaBlocks.createGeoBlock(LooseGeoBlock.class, GeoMaterial.Strength.WEAK, Ore.class, Material.field_151595_p);
    }

    private static GeoBlock createOreRockBlock(GeoMaterial.Strength strength) {
        return GeoBlock.registerNative(GeologicaBlocks.createGeoBlock(IntactGeoBlock.class, strength, Ore.class, Material.field_151576_e));
    }

    private static GeoBlock createClayBlock() {
        return GeoBlock.registerNative(GeologicaBlocks.createGeoBlock(IntactGeoBlock.class, GeoMaterial.Strength.WEAK, Aggregate.class, Material.field_151571_B));
    }

    private static GeoBlock createOreClayBlock() {
        return GeologicaBlocks.createGeoBlock(IntactGeoBlock.class, GeoMaterial.Strength.WEAK, Ore.class, Material.field_151571_B);
    }

    private static GeoBlock createClayBrickBlock() {
        return GeologicaBlocks.createGeoBlock(BrickGeoBlock.class, GeoMaterial.Strength.WEAK, Aggregate.class, Material.field_151571_B);
    }

    private static GeoBlock createCrudeSandBlock() {
        return GeologicaBlocks.createGeoBlock(LooseGeoBlock.class, GeoMaterial.Strength.WEAK, Crude.class, Material.field_151595_p);
    }

    private static GeoBlock createCrudeRockBlock() {
        return GeologicaBlocks.createGeoBlock(IntactGeoBlock.class, GeoMaterial.Strength.WEAK, Crude.class, Material.field_151576_e);
    }

    private static GeoBlock createVanillaOreRockBlock() {
        return GeologicaBlocks.createGeoBlock(IntactGeoBlock.class, GeoMaterial.Strength.STRONG, VanillaOre.class, Material.field_151576_e);
    }

    public static List<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Field field : GeologicaBlocks.class.getFields()) {
            try {
                blocks.add((Block)field.get(null));
            }
            catch (Exception e) {
                Geologica.log.fatal("Failed to get block from field '" + field.getName() + "'");
                throw new LoaderException((Throwable)e);
            }
        }
        return blocks;
    }

    private static Block createWallBlock(CompositeBlock modelBlock) {
        return GeologicaBlocks.createDerivedBlock(WallBlock.class, modelBlock);
    }

    private static SlabBlock createSlabBlock(CompositeBlock modelBlock, SlabBlock singleSlab) {
        String doubleToken = singleSlab == null ? "" : "Double";
        SlabBlock block = new SlabBlock(modelBlock, singleSlab);
        return block;
    }

    private static StairsBlock createStairsBlock(GeoBlock modelBlock, GeoMaterial substance) {
        StairsBlock block = new StairsBlock(modelBlock, modelBlock.getMeta(substance));
        return block;
    }

    private static GeoBlock createGeoBlock(Class<? extends GeoBlock> blockClass, GeoMaterial.Strength strength, Class<? extends IndustrialMaterial> composition, Material material) {
        GeoBlock block = null;
        try {
            Constructor<? extends GeoBlock> constructor = blockClass.getConstructor(GeoMaterial.Strength.class, Class.class, Material.class);
            block = constructor.newInstance(new Object[]{strength, composition, material});
        }
        catch (Exception e) {
            Geologica.log.fatal("Failed to construct GeoBlock");
            throw new LoaderException((Throwable)e);
        }
        return block;
    }

    private static <T extends Block> T createDerivedBlock(Class<T> blockClass, CompositeBlock modelBlock) {
        Block block = null;
        try {
            Constructor<T> constructor = blockClass.getConstructor(CompositeBlock.class);
            block = (Block)constructor.newInstance(modelBlock);
        }
        catch (Exception e) {
            Geologica.log.fatal("Failed to construct derived block");
            throw new LoaderException((Throwable)e);
        }
        return (T)block;
    }

    private static IndustrialFluidBlock createFluidBlock(GeoMaterial material) {
        IndustrialFluid fluid = IndustrialFluid.getCanonicalFluidForPhase(material, Condition.STP);
        return new IndustrialFluidBlock(fluid);
    }
}

