/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.geologica.processing;

import java.awt.Color;
import java.util.List;
import org.pfaa.chemica.model.Chemical;
import org.pfaa.chemica.model.Compound;
import org.pfaa.chemica.model.Condition;
import org.pfaa.chemica.model.ConditionProperties;
import org.pfaa.chemica.model.Element;
import org.pfaa.chemica.model.IndustrialMaterial;
import org.pfaa.chemica.model.Mixture;
import org.pfaa.chemica.model.MixtureComponent;
import org.pfaa.geologica.processing.Mineral;
import org.pfaa.geologica.processing.Ore;
import org.pfaa.geologica.processing.SimpleOreMineral;

public interface OreMineral
extends Mineral {
    public Chemical getConcentrate();

    public static class Substitution
    extends MixtureComponent {
        public Substitution(Element substitute, double rate) {
            super(substitute, rate);
        }

        @Override
        public Element getMaterial() {
            return (Element)this.material;
        }
    }

    public static enum Ores implements OreMineral
    {
        ACANTHITE((Chemical)Compound.Compounds.Ag2S, new Substitution[0]),
        ANATASE((Chemical)Compound.Compounds.TiO2, new Substitution[0]),
        BARITE((Chemical)Compound.Compounds.BaSO4, new Color(250, 250, 170), new Substitution(Element.Elements.Sr, 0.05)),
        BASTNASITE((Chemical)Compound.Compounds.CeCO3F, new Substitution(Element.Elements.La, 0.2), new Substitution(Element.Elements.Y, 0.1)),
        BERYL((Chemical)Compound.Compounds.Be3Al2SiO36, new Substitution[0]),
        BISMUTHINITE((Chemical)Compound.Compounds.Bi2S3, new Substitution[0]),
        BORAX((Chemical)Compound.Compounds.Na2B4O7, new Substitution[0]),
        CALCITE((Chemical)Compound.Compounds.CaCO3, new Substitution[0]),
        CARNALLITE(Compound.Compounds.KCl.mix(Compound.Compounds.MgCl2, 1.0)),
        CARNOTITE((Chemical)Compound.Compounds.K2U2V2O12, new Substitution[0]),
        CASSITERITE((Chemical)Compound.Compounds.SnO2, new Color(30, 20, 0), new Substitution[0]),
        CELESTINE((Chemical)Compound.Compounds.SrSO4, new Color(200, 200, 250), new Substitution(Element.Elements.Ba, 0.2)),
        CHALCOPYRITE((Chemical)Compound.Compounds.CuFeS2, new Substitution[0]),
        CHROMITE((Chemical)Compound.Compounds.FeCr2O4, new Substitution[0]),
        CINNABAR((Chemical)Compound.Compounds.HgS, new Substitution[0]),
        COBALTITE((Chemical)Compound.Compounds.CoAsS, new Substitution[0]),
        COLUMBITE((Chemical)Compound.Compounds.FeNb2O6, new Substitution[0]),
        CUPRITE((Chemical)Compound.Compounds.Cu2O, Color.red, new Substitution[0]),
        FLUORITE((Chemical)Compound.Compounds.CaF2, new Color(155, 0, 165), new Substitution[0]),
        GALENA((Chemical)Compound.Compounds.PbS, new Substitution[0]),
        GIBBSITE((Chemical)Compound.Compounds.AlOH3, new Substitution(Element.Elements.Ga, 0.001)),
        GOETHITE((Chemical)Compound.Compounds.alpha_FeOH3, new Substitution(Element.Elements.Ni, 0.05), new Substitution(Element.Elements.Co, 0.01)),
        GREENOCKITE((Chemical)Compound.Compounds.CdS, new Substitution[0]),
        GYPSUM((Chemical)Compound.Compounds.CaSO4_2H2O, new Substitution[0]),
        HALITE((Chemical)Compound.Compounds.NaCl, new Substitution[0]),
        LEPIDOCROCITE((Chemical)Compound.Compounds.gamma_FeOH3, new Substitution[0]),
        HEMATITE((Chemical)Compound.Compounds.Fe2O3, new Substitution[0]),
        ILMENITE((Chemical)Compound.Compounds.FeTiO3, new Substitution[0]),
        LEPIDOLITE((Chemical)Compound.Compounds.Li3KSi4O10OH2, new Substitution(Element.Elements.Rb, 0.01), new Substitution(Element.Elements.Cs, 0.005)),
        MAGNETITE((Chemical)Compound.Compounds.Fe3O4, new Substitution[0]),
        MAGNESITE((Chemical)Compound.Compounds.MgCO3, new Substitution[0]),
        MALACHITE((Chemical)Compound.Compounds.Cu2CO3OH2, new Substitution[0]),
        MICROLITE((Chemical)Compound.Compounds.NaCaTa2O6OH, new Substitution[0]),
        MOLYBDENITE((Chemical)Compound.Compounds.MoS2, new Substitution(Element.Elements.Re, 0.01)),
        MONAZITE((Chemical)Compound.Compounds.CePO4, new Substitution(Element.Elements.La, 0.5), new Substitution(Element.Elements.Nd, 0.3), new Substitution(Element.Elements.Pr, 0.15), new Substitution(Element.Elements.Th, 0.5)),
        NEPOUITE((Chemical)Compound.Compounds.Ni3Si2O5OH4, new Substitution[0]),
        ORPIMENT((Chemical)Compound.Compounds.As2S3, new Substitution[0]),
        PENTLANDITE((Chemical)Compound.Compounds.Ni9S8, new Substitution(Element.Elements.Fe, 1.0), new Substitution(Element.Elements.Co, 0.01)),
        POLLUCITE((Chemical)Compound.Compounds.Cs2Al2Si4O12, new Substitution(Element.Elements.Rb, 0.05)),
        PYRITE((Chemical)Compound.Compounds.FeS2, new Substitution(Element.Elements.Ni, 0.1), new Substitution(Element.Elements.Co, 0.05)),
        PYROCHLORE((Chemical)Compound.Compounds.NaCaNb2O6OH, new Substitution(Element.Elements.Ce, 0.03), new Substitution(Element.Elements.La, 0.015), new Substitution(Element.Elements.Nd, 0.01), new Substitution(Element.Elements.Y, 0.01), new Substitution(Element.Elements.Th, 0.01), new Substitution(Element.Elements.U, 0.005)),
        PYROLUSITE((Chemical)Compound.Compounds.MnO2, new Substitution[0]),
        REALGAR((Chemical)Compound.Compounds.AsS, new Substitution[0]),
        RUTILE((Chemical)Compound.Compounds.TiO2, new Color(130, 60, 5), new Substitution[0]),
        SCHEELITE((Chemical)Compound.Compounds.CaWO4, new Color(240, 200, 150), new Substitution[0]),
        SPHALERITE((Chemical)Compound.Compounds.ZnS, new Color(30, 75, 50), new Substitution(Element.Elements.Cd, 0.01), new Substitution(Element.Elements.Ga, 0.001)),
        SPODUMENE((Chemical)Compound.Compounds.LiAlSiO32, new Substitution[0]),
        STIBNITE((Chemical)Compound.Compounds.Sb2S3, new Substitution[0]),
        SYLVITE((Chemical)Compound.Compounds.KCl, new Substitution[0]),
        TANTALITE((Chemical)Compound.Compounds.FeTa2O6, new Substitution[0]),
        TITANO_MAGNETITE(Compound.Compounds.Fe3O4.mix(Compound.Compounds.FeV2O4, 0.05)),
        URANINITE((Chemical)Compound.Compounds.UO2, new Substitution[0]),
        VANADINITE((Chemical)Compound.Compounds.Pb5V3O12Cl, new Substitution[0]),
        WOLFRAMITE((Chemical)Compound.Compounds.FeWO4, new Substitution[0]),
        ZIRCON((Chemical)Compound.Compounds.ZrSiO4, new Color(130, 60, 5), new Substitution[0]),
        GOLD((Chemical)Element.Elements.Au, new Substitution[0]);

        private OreMineral delegate;

        private Ores(OreMineral delegate) {
            this.delegate = delegate;
        }

        private Ores(Mixture mixture) {
            this(new SimpleOreMineral(mixture));
        }

        private Ores(Chemical material, Substitution ... substitution) {
            this(material, (Color)null, substitution);
        }

        private Ores(Chemical material, Color color, Substitution ... substitution) {
            this(new SimpleOreMineral(material, color, substitution));
        }

        @Override
        public String getOreDictKey() {
            return this.delegate.getOreDictKey();
        }

        @Override
        public List<MixtureComponent> getComponents() {
            return this.delegate.getComponents();
        }

        @Override
        public ConditionProperties getProperties(Condition condition) {
            return this.delegate.getProperties(condition);
        }

        @Override
        public Chemical getConcentrate() {
            return this.delegate.getConcentrate();
        }

        @Override
        public Ore mix(IndustrialMaterial material, double weight) {
            return this.delegate.mix(material, weight);
        }
    }

    public static enum SmeltingTemperature {
        LOW,
        MEDIUM,
        HIGH,
        VERY_HIGH;

    }
}

