/*
 * Decompiled with CFR 0.152.
 */
package org.pfaa.chemica.block;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import org.pfaa.chemica.ChemicaBlocks;
import org.pfaa.chemica.fluid.FluidMaterial;
import org.pfaa.chemica.fluid.IndustrialFluid;
import org.pfaa.chemica.model.Compound;
import org.pfaa.chemica.render.EntityDropParticleFX;

public class IndustrialFluidBlock
extends BlockFluidClassic {
    private IndustrialFluid fluid;

    public IndustrialFluidBlock(IndustrialFluid fluid) {
        super((Fluid)fluid, IndustrialFluidBlock.materialForIndustrialFluid(fluid));
        this.fluid = fluid;
    }

    private static Material materialForIndustrialFluid(IndustrialFluid fluid) {
        boolean flammable;
        boolean bl = flammable = fluid.getProperties().hazard.flammability > 0;
        return fluid.isGaseous() ? new FluidMaterial(MapColor.field_151660_b, flammable, false) : ((double)fluid.getTemperature() > 1000.0 ? Material.field_151587_i : Material.field_151586_h);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return this.fluid.getColor();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side != 0 && side != 1 ? this.fluid.getFlowingIcon() : this.fluid.getStillIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String prefix = this.fluid.isGaseous() ? "gas" : (this.fluid.isSuperHeated() ? "molten" : "fluid");
        String postfix = this.fluid.isOpaque() ? "_opaque" : "";
        this.fluid.setStillIcon(register.func_94245_a("chemica:" + prefix + "_still" + postfix));
        this.fluid.setFlowingIcon(register.func_94245_a("chemica:" + prefix + "_flow" + postfix));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        super.func_149734_b(world, x, y, z, rand);
        this.trySeepEffect(world, x, y, z, rand);
    }

    @SideOnly(value=Side.CLIENT)
    private void trySeepEffect(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(10) == 0 && World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && !world.func_147439_a(x, y - 2, z).func_149688_o().func_76230_c()) {
            double px = (float)x + rand.nextFloat();
            double py = (double)y - 1.05;
            double pz = (float)z + rand.nextFloat();
            int color = this.fluid.getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            EntityDropParticleFX fx = new EntityDropParticleFX(world, px, py, pz, red, green, blue);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public IndustrialFluid getFluid() {
        return this.fluid;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (this.getFluid().isGaseous()) {
            this.updateGas(world, x, y, z, rand);
        } else {
            if (this.fluid.isPollutant()) {
                this.polluteSoil(world, x, y, z, rand);
            }
            this.tryToCatchFireFromLava(world, x, y, z, rand);
            super.func_149674_a(world, x, y, z, rand);
        }
    }

    private void tryToChangePhase(World world, int x, int y, int z, Random rand) {
    }

    private void updateGas(World world, int x, int y, int z, Random rand) {
        int quantaRemaining = this.getQuantaValue((IBlockAccess)world, x, y, z);
        int expQuanta = -101;
        boolean source = this.isSourceBlock((IBlockAccess)world, x, y, z);
        if (!source) {
            int y2 = y - this.densityDir;
            if (world.func_147439_a(x, y2, z) == this) {
                expQuanta = this.getQuantaValue((IBlockAccess)world, x, y2, z);
                if (quantaRemaining < this.quantaPerBlock - 1 || this.isSourceBlock((IBlockAccess)world, x, y2, z) || this.hasSmallerQuanta((IBlockAccess)world, x - 1, y2, z, expQuanta) || this.hasSmallerQuanta((IBlockAccess)world, x + 1, y2, z, expQuanta) || this.hasSmallerQuanta((IBlockAccess)world, x, y2, z - 1, expQuanta) || this.hasSmallerQuanta((IBlockAccess)world, x, y2, z + 1, expQuanta)) {
                    --expQuanta;
                }
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x - 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x + 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.func_147449_b(x, y, z, Blocks.field_150350_a);
                } else {
                    world.func_72921_c(x, y, z, this.quantaPerBlock - expQuanta, 3);
                    world.func_147464_a(x, y, z, (Block)this, this.tickRate);
                    world.func_147459_d(x, y, z, (Block)this);
                }
            }
            if (world.func_147439_a(x, y + this.densityDir, z) == this) {
                return;
            }
        } else if (source) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        boolean[] canFlowLaterally = new boolean[]{this.canDisplaceInDirection(world, x, y, z, ForgeDirection.VALID_DIRECTIONS[2]), this.canDisplaceInDirection(world, x, y, z, ForgeDirection.VALID_DIRECTIONS[3]), this.canDisplaceInDirection(world, x, y, z, ForgeDirection.VALID_DIRECTIONS[4]), this.canDisplaceInDirection(world, x, y, z, ForgeDirection.VALID_DIRECTIONS[5])};
        int numFeasibleLateralFlows = 0;
        for (boolean dir : canFlowLaterally) {
            if (!dir) continue;
            ++numFeasibleLateralFlows;
        }
        boolean flowVertically = this.shouldGasFlowVertically(world, x, y, z, rand, numFeasibleLateralFlows);
        int numLateralFlows = flowVertically ? 1 : 2;
        boolean diffuse = this.shouldGasDiffuse(world, x, y, z, rand, numFeasibleLateralFlows, numLateralFlows);
        int flowMeta = Math.max(1, this.quantaPerBlock - quantaRemaining + (diffuse || quantaRemaining < this.quantaPerBlock - 1 ? 1 : 0));
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (!diffuse) {
            --numLateralFlows;
        }
        numLateralFlows = Math.min(numLateralFlows, numFeasibleLateralFlows);
        while (numLateralFlows > 0) {
            int i = rand.nextInt(canFlowLaterally.length);
            if (!canFlowLaterally[i]) continue;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i + 2];
            this.flowIntoBlock(world, x + dir.offsetX, y, z + dir.offsetZ, flowMeta);
            canFlowLaterally[i] = false;
            --numLateralFlows;
        }
        if (flowVertically) {
            this.flowIntoBlock(world, x, y + this.densityDir, z, flowMeta);
        }
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        int flammability = 0;
        flammability = Math.max(0, this.fluid.getProperties().hazard.flammability - 1) * 100;
        BiomeGenBase biome = world instanceof World ? ((World)world).func_72807_a(x, z) : world.func_72807_a(x, z);
        BiomeGenBase.TempCategory tempCategory = biome.func_150561_m();
        if (tempCategory == BiomeGenBase.TempCategory.COLD) {
            flammability -= 50;
        } else if (tempCategory == BiomeGenBase.TempCategory.WARM) {
            flammability += 50;
        }
        return flammability;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.getFlammability(world, x, y, z, face) / 3;
    }

    protected void flowIntoBlock(World world, int x, int y, int z, int meta) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150478_aa || block.func_149688_o() == Material.field_151581_o || block.func_149688_o() == Material.field_151587_i) {
            this.tryToIgnite(world, x, y, z);
        } else {
            super.flowIntoBlock(world, x, y, z, meta);
        }
    }

    private boolean canDisplaceInDirection(World world, int x, int y, int z, ForgeDirection dir) {
        return this.canDisplace((IBlockAccess)world, x + dir.offsetX, y, z + dir.offsetZ);
    }

    private boolean shouldGasDiffuse(World world, int x, int y, int z, Random rand, int numFeasibleFlows, int minFlows) {
        double steamTemperature = Compound.Compounds.H2O.getVaporization().getTemperature();
        float pDiffuse = (float)(Math.sqrt(this.temperature) / (Math.sqrt(steamTemperature) * 3.0));
        return rand.nextFloat() < pDiffuse && numFeasibleFlows >= minFlows;
    }

    private boolean shouldGasFlowVertically(World world, int x, int y, int z, Random rand, int numFeasibleLateralFlows) {
        double materialDensity = this.fluid.getProperties().density;
        double conc = (double)this.getQuantaValue((IBlockAccess)world, x, y, z) / (double)this.quantaPerBlock;
        double pVertical = Math.abs(conc * (0.001225 - conc * materialDensity)) / 0.001225;
        boolean laterallyConstrained = numFeasibleLateralFlows == 0;
        boolean flowVertically = this.canDisplace((IBlockAccess)world, x, y + this.densityDir, z) && ((double)rand.nextFloat() < 2.0 * pVertical || laterallyConstrained);
        return flowVertically;
    }

    private int getDensityAt(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int density = Integer.MAX_VALUE;
        if (block instanceof BlockFluidBase) {
            density = ((BlockFluidBase)block).getFluid().getDensity(world, x, y, z);
        }
        return density;
    }

    private boolean hasSmallerQuanta(IBlockAccess world, int x, int y, int z, int quanta) {
        int other = this.getQuantaValue(world, x, y, z);
        return other > 0 && other < quanta;
    }

    private boolean shouldDisplace(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block != this;
    }

    public boolean canFlowInto(IBlockAccess world, int x, int y, int z) {
        if (!this.shouldDisplace(world, x, y, z)) {
            return false;
        }
        return super.canFlowInto(world, x, y, z);
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (!this.shouldDisplace(world, x, y, z)) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (!this.shouldDisplace((IBlockAccess)world, x, y, z)) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity.func_70027_ad() && !this.tryToIgnite(world, x, y, z)) {
            entity.func_70066_B();
        }
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            List<PotionEffect> contactEffects = this.fluid.getProperties().hazard.getContactEffects();
            for (PotionEffect effect : contactEffects) {
                livingEntity.func_70690_d(effect);
            }
        }
    }

    private boolean tryToIgnite(World world, int x, int y, int z) {
        if (world.field_73012_v.nextInt(300) < this.getFlammability((IBlockAccess)world, x, y, z, ForgeDirection.UNKNOWN)) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
            return true;
        }
        return false;
    }

    public static IndustrialFluidBlock atEyeLevel(EntityLivingBase entity) {
        int k;
        int j;
        double j0 = entity.field_70163_u + (double)(entity.field_70170_p.field_72995_K ? 0.0f : entity.func_70047_e());
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        Block block = entity.field_70170_p.func_147439_a(i, j = MathHelper.func_76128_c((double)j0), k = MathHelper.func_76128_c((double)entity.field_70161_v));
        if (block instanceof IndustrialFluidBlock) {
            IndustrialFluidBlock fluidBlock = (IndustrialFluidBlock)block;
            float filled = fluidBlock.getFilledPercentage(entity.field_70170_p, i, j, k);
            float density = fluidBlock.getFluid().getDensity();
            Block nbor = entity.field_70170_p.func_147439_a(i, j - (density > 0.0f ? -1 : 1), k);
            if (nbor == block) {
                filled = 1.0f;
            }
            if (IndustrialFluidBlock.positionInFilledPortion(j0, filled)) {
                return fluidBlock;
            }
        }
        return null;
    }

    private static boolean positionInFilledPortion(double j0, float filled) {
        if (filled < 0.0f) {
            return j0 > (double)((float)MathHelper.func_76128_c((double)j0) + (1.0f - (filled *= -1.0f)));
        }
        return j0 < (double)((float)MathHelper.func_76128_c((double)j0) + filled);
    }

    private void polluteSoil(World world, int x, int y, int z, Random rand) {
        for (int xi = x - 4; xi <= x + 4; ++xi) {
            for (int yi = y - 1; yi <= y; ++yi) {
                for (int zi = z - 4; zi <= z + 4; ++zi) {
                    Block block = world.func_147439_a(xi, yi, zi);
                    if (block != Blocks.field_150458_ak && (block.func_149688_o() != Material.field_151578_c || rand.nextInt(5) != 1)) continue;
                    world.func_147449_b(xi, yi, zi, ChemicaBlocks.POLLUTED_SOIL);
                }
            }
        }
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        return !this.fluid.isPollutant();
    }

    private void tryToCatchFireFromLava(World world, int x, int y, int z, Random rand) {
        if (this.fluid.getProperties().hazard.flammability > 0 && world.func_147437_c(x, y + 1, z)) {
            for (int xi = x - 1; xi <= x + 1; ++xi) {
                for (int zi = z - 1; zi <= z + 1; ++zi) {
                    if ((world.func_147439_a(xi, y, zi).func_149688_o() != Material.field_151587_i || rand.nextInt(3) != 0) && (world.func_147439_a(xi, y - 1, zi).func_149688_o() != Material.field_151587_i || rand.nextInt(9) != 0)) continue;
                    world.func_147449_b(x, y + (this.isSourceBlock((IBlockAccess)world, x, y, z) ? 1 : 0), z, (Block)Blocks.field_150480_ab);
                    return;
                }
            }
        }
    }
}

